/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.log.dialect.tinylog;

import cn.hutool.core.util.ArrayUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.log.AbstractLog;
import cn.hutool.log.level.Level;
import org.tinylog.configuration.Configuration;
import org.tinylog.format.AdvancedMessageFormatter;
import org.tinylog.format.MessageFormatter;
import org.tinylog.provider.LoggingProvider;
import org.tinylog.provider.ProviderRegistry;

public class TinyLog2
extends AbstractLog {
    private static final long serialVersionUID = 1L;
    private static final int DEPTH = 5;
    private final int level;
    private final String name;
    private static final LoggingProvider provider = ProviderRegistry.getLoggingProvider();
    private static final MessageFormatter formatter = new AdvancedMessageFormatter(Configuration.getLocale(), Configuration.isEscapingEnabled());

    /*
     * WARNING - void declaration
     */
    public TinyLog2(Class<?> clazz) {
        this(clazz == null ? "null" : var1_1.getName());
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public TinyLog2(String name) {
        void var1_1;
        this.name = var1_1;
        this.level = provider.getMinimumLevel().ordinal();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public boolean isTraceEnabled() {
        return this.level <= org.tinylog.Level.TRACE.ordinal();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void trace(String fqcn, Throwable t, String format, Object ... arguments) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.logIfEnabled((String)var1_1, org.tinylog.Level.TRACE, (Throwable)var2_2, (String)var3_3, arguments);
    }

    @Override
    public boolean isDebugEnabled() {
        return this.level <= org.tinylog.Level.DEBUG.ordinal();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void debug(String fqcn, Throwable t, String format, Object ... arguments) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.logIfEnabled((String)var1_1, org.tinylog.Level.DEBUG, (Throwable)var2_2, (String)var3_3, arguments);
    }

    @Override
    public boolean isInfoEnabled() {
        return this.level <= org.tinylog.Level.INFO.ordinal();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void info(String fqcn, Throwable t, String format, Object ... arguments) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.logIfEnabled((String)var1_1, org.tinylog.Level.INFO, (Throwable)var2_2, (String)var3_3, arguments);
    }

    @Override
    public boolean isWarnEnabled() {
        return this.level <= org.tinylog.Level.WARN.ordinal();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void warn(String fqcn, Throwable t, String format, Object ... arguments) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.logIfEnabled((String)var1_1, org.tinylog.Level.WARN, (Throwable)var2_2, (String)var3_3, arguments);
    }

    @Override
    public boolean isErrorEnabled() {
        return this.level <= org.tinylog.Level.ERROR.ordinal();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void error(String fqcn, Throwable t, String format, Object ... arguments) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.logIfEnabled((String)var1_1, org.tinylog.Level.ERROR, (Throwable)var2_2, (String)var3_3, arguments);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void log(String fqcn, Level level, Throwable t, String format, Object ... arguments) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.logIfEnabled((String)var1_1, this.toTinyLevel((Level)var2_2), (Throwable)var3_3, format, arguments);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean isEnabled(Level level) {
        void var1_1;
        return this.level <= this.toTinyLevel((Level)var1_1).ordinal();
    }

    /*
     * WARNING - void declaration
     */
    private void logIfEnabled(String fqcn, org.tinylog.Level level, Throwable t, String format, Object ... arguments) {
        void var3_3;
        void var2_2;
        if (t == null) {
            t = TinyLog2.getLastArgumentIfThrowable(arguments);
        }
        provider.log(5, null, (org.tinylog.Level)var2_2, (Throwable)var3_3, formatter, (Object)StrUtil.toString(format), arguments);
    }

    /*
     * WARNING - void declaration
     */
    private org.tinylog.Level toTinyLevel(Level level) {
        void var1_1;
        switch (level) {
            case TRACE: {
                org.tinylog.Level tinyLevel = org.tinylog.Level.TRACE;
                break;
            }
            case DEBUG: {
                org.tinylog.Level tinyLevel = org.tinylog.Level.DEBUG;
                break;
            }
            case INFO: {
                org.tinylog.Level tinyLevel = org.tinylog.Level.INFO;
                break;
            }
            case WARN: {
                org.tinylog.Level tinyLevel = org.tinylog.Level.WARN;
                break;
            }
            case ERROR: {
                org.tinylog.Level tinyLevel = org.tinylog.Level.ERROR;
                break;
            }
            case OFF: {
                org.tinylog.Level tinyLevel = org.tinylog.Level.OFF;
                break;
            }
            default: {
                org.tinylog.Level tinyLevel;
                throw new Error(StrUtil.format("Can not identify level: {}", tinyLevel));
            }
        }
        return var1_1;
    }

    private static Throwable getLastArgumentIfThrowable(Object ... arguments) {
        if (ArrayUtil.isNotEmpty(arguments) && arguments[arguments.length - 1] instanceof Throwable) {
            Object[] objectArray;
            return (Throwable)objectArray[objectArray.length - 1];
        }
        return null;
    }
}

