/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.log.dialect.tinylog;

import cn.hutool.core.util.ArrayUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.log.AbstractLog;
import cn.hutool.log.level.Level;
import org.pmw.tinylog.LogEntryForwarder;
import org.pmw.tinylog.Logger;

public class TinyLog
extends AbstractLog {
    private static final long serialVersionUID = -4848042277045993735L;
    private static final int DEPTH = 4;
    private final int level;
    private final String name;

    /*
     * WARNING - void declaration
     */
    public TinyLog(Class<?> clazz) {
        this(clazz == null ? "null" : var1_1.getName());
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public TinyLog(String name) {
        void var1_1;
        this.name = name;
        this.level = Logger.getLevel((String)var1_1).ordinal();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public boolean isTraceEnabled() {
        return this.level <= org.pmw.tinylog.Level.TRACE.ordinal();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void trace(String fqcn, Throwable t, String format, Object ... arguments) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.logIfEnabled((String)var1_1, org.pmw.tinylog.Level.TRACE, (Throwable)var2_2, (String)var3_3, arguments);
    }

    @Override
    public boolean isDebugEnabled() {
        return this.level <= org.pmw.tinylog.Level.DEBUG.ordinal();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void debug(String fqcn, Throwable t, String format, Object ... arguments) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.logIfEnabled((String)var1_1, org.pmw.tinylog.Level.DEBUG, (Throwable)var2_2, (String)var3_3, arguments);
    }

    @Override
    public boolean isInfoEnabled() {
        return this.level <= org.pmw.tinylog.Level.INFO.ordinal();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void info(String fqcn, Throwable t, String format, Object ... arguments) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.logIfEnabled((String)var1_1, org.pmw.tinylog.Level.INFO, (Throwable)var2_2, (String)var3_3, arguments);
    }

    @Override
    public boolean isWarnEnabled() {
        return this.level <= org.pmw.tinylog.Level.WARNING.ordinal();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void warn(String fqcn, Throwable t, String format, Object ... arguments) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.logIfEnabled((String)var1_1, org.pmw.tinylog.Level.WARNING, (Throwable)var2_2, (String)var3_3, arguments);
    }

    @Override
    public boolean isErrorEnabled() {
        return this.level <= org.pmw.tinylog.Level.ERROR.ordinal();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void error(String fqcn, Throwable t, String format, Object ... arguments) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.logIfEnabled((String)var1_1, org.pmw.tinylog.Level.ERROR, (Throwable)var2_2, (String)var3_3, arguments);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void log(String fqcn, Level level, Throwable t, String format, Object ... arguments) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.logIfEnabled((String)var1_1, this.toTinyLevel((Level)var2_2), (Throwable)var3_3, format, arguments);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean isEnabled(Level level) {
        void var1_1;
        return this.level <= this.toTinyLevel((Level)var1_1).ordinal();
    }

    /*
     * WARNING - void declaration
     */
    private void logIfEnabled(String fqcn, org.pmw.tinylog.Level level, Throwable t, String format, Object ... arguments) {
        void var3_3;
        void var2_2;
        if (t == null) {
            t = TinyLog.getLastArgumentIfThrowable(arguments);
        }
        LogEntryForwarder.forward((int)4, (org.pmw.tinylog.Level)var2_2, (Throwable)var3_3, (String)StrUtil.toString(format), (Object[])arguments);
    }

    /*
     * WARNING - void declaration
     */
    private org.pmw.tinylog.Level toTinyLevel(Level level) {
        void var1_1;
        switch (level) {
            case TRACE: {
                org.pmw.tinylog.Level tinyLevel = org.pmw.tinylog.Level.TRACE;
                break;
            }
            case DEBUG: {
                org.pmw.tinylog.Level tinyLevel = org.pmw.tinylog.Level.DEBUG;
                break;
            }
            case INFO: {
                org.pmw.tinylog.Level tinyLevel = org.pmw.tinylog.Level.INFO;
                break;
            }
            case WARN: {
                org.pmw.tinylog.Level tinyLevel = org.pmw.tinylog.Level.WARNING;
                break;
            }
            case ERROR: {
                org.pmw.tinylog.Level tinyLevel = org.pmw.tinylog.Level.ERROR;
                break;
            }
            case OFF: {
                org.pmw.tinylog.Level tinyLevel = org.pmw.tinylog.Level.OFF;
                break;
            }
            default: {
                org.pmw.tinylog.Level tinyLevel;
                throw new Error(StrUtil.format("Can not identify level: {}", tinyLevel));
            }
        }
        return var1_1;
    }

    private static Throwable getLastArgumentIfThrowable(Object ... arguments) {
        if (ArrayUtil.isNotEmpty(arguments) && arguments[arguments.length - 1] instanceof Throwable) {
            Object[] objectArray;
            return (Throwable)objectArray[objectArray.length - 1];
        }
        return null;
    }
}

