/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.log.dialect.jdk;

import cn.hutool.core.io.IoUtil;
import cn.hutool.core.io.resource.ResourceUtil;
import cn.hutool.core.lang.Console;
import cn.hutool.log.Log;
import cn.hutool.log.LogFactory;
import cn.hutool.log.dialect.jdk.JdkLog;
import java.io.Closeable;
import java.io.InputStream;
import java.util.logging.LogManager;

public class JdkLogFactory
extends LogFactory {
    public JdkLogFactory() {
        super("JDK Logging");
        this.readConfig();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Log createLog(String name) {
        void var1_1;
        return new JdkLog((String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Log createLog(Class<?> clazz) {
        void var1_1;
        return new JdkLog((Class<?>)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private void readConfig() {
        InputStream in = ResourceUtil.getStreamSafe("logging.properties");
        if (in == null) {
            System.err.println("[WARN] Can not find [logging.properties], use [%JRE_HOME%/lib/logging.properties] as default!");
            return;
        }
        try {
            LogManager.getLogManager().readConfiguration(in);
        }
        catch (Exception exception) {
            try {
                Exception e = exception;
                Console.error(exception, "Read [logging.properties] from classpath error!", new Object[0]);
                try {
                    LogManager.getLogManager().readConfiguration();
                }
                catch (Exception exception2) {
                    void var2_2;
                    Console.error((Throwable)var2_2, "Read [logging.properties] from [%JRE_HOME%/lib/logging.properties] error!", new Object[0]);
                }
            }
            catch (Throwable throwable) {
                void var1_1;
                IoUtil.close((Closeable)var1_1);
                throw throwable;
            }
            IoUtil.close(in);
            return;
        }
        IoUtil.close(in);
        return;
    }
}

