/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.log.dialect.jdk;

import cn.hutool.core.util.StrUtil;
import cn.hutool.log.AbstractLog;
import cn.hutool.log.level.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;

public class JdkLog
extends AbstractLog {
    private static final long serialVersionUID = -6843151523380063975L;
    private final transient Logger logger;

    /*
     * WARNING - void declaration
     */
    public JdkLog(Logger logger) {
        void var1_1;
        this.logger = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public JdkLog(Class<?> clazz) {
        this(clazz == null ? "null" : var1_1.getName());
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public JdkLog(String name) {
        this(Logger.getLogger((String)var1_1));
        void var1_1;
    }

    @Override
    public String getName() {
        return this.logger.getName();
    }

    @Override
    public boolean isTraceEnabled() {
        return this.logger.isLoggable(java.util.logging.Level.FINEST);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void trace(String fqcn, Throwable t, String format, Object ... arguments) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.logIfEnabled((String)var1_1, java.util.logging.Level.FINEST, (Throwable)var2_2, (String)var3_3, arguments);
    }

    @Override
    public boolean isDebugEnabled() {
        return this.logger.isLoggable(java.util.logging.Level.FINE);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void debug(String fqcn, Throwable t, String format, Object ... arguments) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.logIfEnabled((String)var1_1, java.util.logging.Level.FINE, (Throwable)var2_2, (String)var3_3, arguments);
    }

    @Override
    public boolean isInfoEnabled() {
        return this.logger.isLoggable(java.util.logging.Level.INFO);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void info(String fqcn, Throwable t, String format, Object ... arguments) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.logIfEnabled((String)var1_1, java.util.logging.Level.INFO, (Throwable)var2_2, (String)var3_3, arguments);
    }

    @Override
    public boolean isWarnEnabled() {
        return this.logger.isLoggable(java.util.logging.Level.WARNING);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void warn(String fqcn, Throwable t, String format, Object ... arguments) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.logIfEnabled((String)var1_1, java.util.logging.Level.WARNING, (Throwable)var2_2, (String)var3_3, arguments);
    }

    @Override
    public boolean isErrorEnabled() {
        return this.logger.isLoggable(java.util.logging.Level.SEVERE);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void error(String fqcn, Throwable t, String format, Object ... arguments) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.logIfEnabled((String)var1_1, java.util.logging.Level.SEVERE, (Throwable)var2_2, (String)var3_3, arguments);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void log(String fqcn, Level level, Throwable t, String format, Object ... arguments) {
        void var3_3;
        void var2_2;
        void var1_1;
        switch (level) {
            case TRACE: {
                java.util.logging.Level jdkLevel = java.util.logging.Level.FINEST;
                break;
            }
            case DEBUG: {
                java.util.logging.Level jdkLevel = java.util.logging.Level.FINE;
                break;
            }
            case INFO: {
                java.util.logging.Level jdkLevel = java.util.logging.Level.INFO;
                break;
            }
            case WARN: {
                java.util.logging.Level jdkLevel = java.util.logging.Level.WARNING;
                break;
            }
            case ERROR: {
                java.util.logging.Level jdkLevel = java.util.logging.Level.SEVERE;
                break;
            }
            default: {
                java.util.logging.Level jdkLevel;
                throw new Error(StrUtil.format("Can not identify level: {}", jdkLevel));
            }
        }
        this.logIfEnabled((String)var1_1, (java.util.logging.Level)var2_2, (Throwable)var3_3, format, arguments);
    }

    /*
     * WARNING - void declaration
     */
    private void logIfEnabled(String callerFQCN, java.util.logging.Level level, Throwable throwable, String format, Object[] arguments) {
        if (this.logger.isLoggable(level)) {
            void var2_2;
            void var1_1;
            void var3_3;
            LogRecord record = new LogRecord(level, StrUtil.format(format, arguments));
            record.setLoggerName(this.getName());
            record.setThrown((Throwable)var3_3);
            JdkLog.fillCallerData((String)var1_1, record);
            this.logger.log((LogRecord)var2_2);
        }
    }

    /*
     * WARNING - void declaration
     */
    private static void fillCallerData(String callerFQCN, LogRecord record) {
        StackTraceElement[] steArray = Thread.currentThread().getStackTrace();
        int found = -1;
        for (int i = steArray.length - 2; i >= 0; --i) {
            String className = steArray[i].getClassName();
            if (!callerFQCN.equals(className)) continue;
            found = i;
            break;
        }
        if (found >= 0) {
            void var1_1;
            void var3_3;
            void var2_2;
            void ste = var2_2[var3_3 + true];
            record.setSourceClassName(ste.getClassName());
            var1_1.setSourceMethodName(ste.getMethodName());
        }
    }
}

