/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.log.dialect.console;

import cn.hutool.core.date.DateUtil;
import cn.hutool.core.lang.Assert;
import cn.hutool.core.lang.Console;
import cn.hutool.core.lang.Dict;
import cn.hutool.core.util.StrUtil;
import cn.hutool.log.AbstractLog;
import cn.hutool.log.level.Level;

public class ConsoleLog
extends AbstractLog {
    private static final long serialVersionUID = -6843151523380063975L;
    private static final String logFormat = "[{date}] [{level}] {name}: {msg}";
    private static Level currentLevel = Level.DEBUG;
    private final String name;

    /*
     * WARNING - void declaration
     */
    public ConsoleLog(Class<?> clazz) {
        void var1_1;
        this.name = clazz == null ? "null" : var1_1.getName();
    }

    /*
     * WARNING - void declaration
     */
    public ConsoleLog(String name) {
        void var1_1;
        this.name = var1_1;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public static void setLevel(Level customLevel) {
        Level level;
        Assert.notNull(customLevel);
        currentLevel = level;
    }

    @Override
    public boolean isTraceEnabled() {
        return ((AbstractLog)this).isEnabled(Level.TRACE);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void trace(String fqcn, Throwable t, String format, Object ... arguments) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.log((String)var1_1, Level.TRACE, (Throwable)var2_2, (String)var3_3, arguments);
    }

    @Override
    public boolean isDebugEnabled() {
        return ((AbstractLog)this).isEnabled(Level.DEBUG);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void debug(String fqcn, Throwable t, String format, Object ... arguments) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.log((String)var1_1, Level.DEBUG, (Throwable)var2_2, (String)var3_3, arguments);
    }

    @Override
    public boolean isInfoEnabled() {
        return ((AbstractLog)this).isEnabled(Level.INFO);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void info(String fqcn, Throwable t, String format, Object ... arguments) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.log((String)var1_1, Level.INFO, (Throwable)var2_2, (String)var3_3, arguments);
    }

    @Override
    public boolean isWarnEnabled() {
        return ((AbstractLog)this).isEnabled(Level.WARN);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void warn(String fqcn, Throwable t, String format, Object ... arguments) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.log((String)var1_1, Level.WARN, (Throwable)var2_2, (String)var3_3, arguments);
    }

    @Override
    public boolean isErrorEnabled() {
        return ((AbstractLog)this).isEnabled(Level.ERROR);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void error(String fqcn, Throwable t, String format, Object ... arguments) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.log((String)var1_1, Level.ERROR, (Throwable)var2_2, (String)var3_3, arguments);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void log(String fqcn, Level level, Throwable t, String format, Object ... arguments) {
        void var1_1;
        void var3_3;
        void var2_2;
        if (!((AbstractLog)this).isEnabled(level)) {
            return;
        }
        Dict dict = Dict.create().set("date", DateUtil.now()).set("level", level.toString()).set("name", this.name).set("msg", StrUtil.format(format, arguments));
        String logMsg = StrUtil.format((CharSequence)logFormat, dict);
        if (var2_2.ordinal() >= Level.WARN.ordinal()) {
            Console.error(t, logMsg, new Object[0]);
            return;
        }
        Console.log((Throwable)var3_3, (String)var1_1, new Object[0]);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean isEnabled(Level level) {
        void var1_1;
        return currentLevel.compareTo(var1_1) <= 0;
    }
}

