/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.log;

import cn.hutool.core.io.resource.ResourceUtil;
import cn.hutool.core.lang.caller.CallerUtil;
import cn.hutool.core.map.SafeConcurrentHashMap;
import cn.hutool.core.util.ServiceLoaderUtil;
import cn.hutool.log.GlobalLogFactory;
import cn.hutool.log.Log;
import cn.hutool.log.dialect.console.ConsoleLogFactory;
import cn.hutool.log.dialect.jdk.JdkLogFactory;
import java.net.URL;
import java.util.Map;

public abstract class LogFactory {
    protected String name;
    private final Map<Object, Log> logCache;

    /*
     * WARNING - void declaration
     */
    public LogFactory(String name) {
        void var1_1;
        this.name = var1_1;
        this.logCache = new SafeConcurrentHashMap<Object, Log>();
    }

    public String getName() {
        return this.name;
    }

    /*
     * WARNING - void declaration
     */
    public Log getLog(String name) {
        void var1_1;
        return this.logCache.computeIfAbsent(var1_1, o -> {
            void var1_1;
            return this.createLog((String)var1_1);
        });
    }

    /*
     * WARNING - void declaration
     */
    public Log getLog(Class<?> clazz) {
        void var1_1;
        return this.logCache.computeIfAbsent(var1_1, o -> {
            void var1_1;
            return this.createLog((Class)var1_1);
        });
    }

    public abstract Log createLog(String var1);

    public abstract Log createLog(Class<?> var1);

    protected void checkLogExist(Class<?> logClassName) {
    }

    public static LogFactory getCurrentLogFactory() {
        return GlobalLogFactory.get();
    }

    public static LogFactory setCurrentLogFactory(Class<? extends LogFactory> logFactoryClass) {
        return GlobalLogFactory.set(logFactoryClass);
    }

    public static LogFactory setCurrentLogFactory(LogFactory logFactory) {
        return GlobalLogFactory.set(logFactory);
    }

    public static Log get(String name) {
        String string;
        return LogFactory.getCurrentLogFactory().getLog(string);
    }

    public static Log get(Class<?> clazz) {
        Class<?> clazz2;
        return LogFactory.getCurrentLogFactory().getLog(clazz2);
    }

    public static Log get() {
        return LogFactory.get(CallerUtil.getCallerCaller());
    }

    /*
     * WARNING - void declaration
     */
    public static LogFactory create() {
        void var0;
        LogFactory factory = LogFactory.doCreate();
        factory.getLog(LogFactory.class).debug("Use [{}] Logger As Default.", factory.name);
        return var0;
    }

    /*
     * WARNING - void declaration
     */
    private static LogFactory doCreate() {
        void var0;
        LogFactory factory = ServiceLoaderUtil.loadFirstAvailable(LogFactory.class);
        if (factory != null) {
            return factory;
        }
        URL url = ResourceUtil.getResource("logging.properties");
        if (var0 != null) {
            return new JdkLogFactory();
        }
        return new ConsoleLogFactory();
    }
}

