/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.log;

import cn.hutool.log.LogFactory;

public class GlobalLogFactory {
    private static volatile LogFactory currentLogFactory;
    private static final Object lock;

    public static LogFactory get() {
        if (currentLogFactory == null) {
            Object object = lock;
            synchronized (object) {
                if (currentLogFactory == null) {
                    currentLogFactory = LogFactory.create();
                }
            }
        }
        return currentLogFactory;
    }

    /*
     * WARNING - void declaration
     */
    public static LogFactory set(Class<? extends LogFactory> logFactoryClass) {
        try {
            return GlobalLogFactory.set(logFactoryClass.newInstance());
        }
        catch (Exception e) {
            void var0_1;
            throw new IllegalArgumentException("Can not instance LogFactory class!", (Throwable)var0_1);
        }
    }

    public static LogFactory set(LogFactory logFactory) {
        LogFactory logFactory2;
        logFactory.getLog(GlobalLogFactory.class).debug("Custom Use [{}] Logger.", logFactory.name);
        currentLogFactory = logFactory2;
        return currentLogFactory;
    }

    static {
        lock = new Object();
    }
}

