/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.jwt.signers;

import cn.hutool.core.lang.Assert;
import cn.hutool.core.util.ReUtil;
import cn.hutool.jwt.signers.AlgorithmUtil;
import cn.hutool.jwt.signers.AsymmetricJWTSigner;
import cn.hutool.jwt.signers.EllipticCurveJWTSigner;
import cn.hutool.jwt.signers.HMacJWTSigner;
import cn.hutool.jwt.signers.JWTSigner;
import cn.hutool.jwt.signers.NoneJWTSigner;
import java.security.Key;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.PublicKey;

public class JWTSignerUtil {
    public static JWTSigner none() {
        return NoneJWTSigner.NONE;
    }

    public static JWTSigner hs256(byte[] key) {
        byte[] byArray;
        return JWTSignerUtil.createSigner("HS256", byArray);
    }

    public static JWTSigner hs384(byte[] key) {
        byte[] byArray;
        return JWTSignerUtil.createSigner("HS384", byArray);
    }

    public static JWTSigner hs512(byte[] key) {
        byte[] byArray;
        return JWTSignerUtil.createSigner("HS512", byArray);
    }

    public static JWTSigner rs256(Key key) {
        Key key2;
        return JWTSignerUtil.createSigner("RS256", key2);
    }

    public static JWTSigner rs384(Key key) {
        Key key2;
        return JWTSignerUtil.createSigner("RS384", key2);
    }

    public static JWTSigner rs512(Key key) {
        Key key2;
        return JWTSignerUtil.createSigner("RS512", key2);
    }

    public static JWTSigner es256(Key key) {
        Key key2;
        return JWTSignerUtil.createSigner("ES256", key2);
    }

    public static JWTSigner es384(Key key) {
        Key key2;
        return JWTSignerUtil.createSigner("ES384", key2);
    }

    public static JWTSigner es512(Key key) {
        Key key2;
        return JWTSignerUtil.createSigner("ES512", key2);
    }

    public static JWTSigner hmd5(Key key) {
        Key key2;
        return JWTSignerUtil.createSigner("HMD5", key2);
    }

    public static JWTSigner hsha1(Key key) {
        Key key2;
        return JWTSignerUtil.createSigner("HSHA1", key2);
    }

    public static JWTSigner sm4cmac(Key key) {
        Key key2;
        return JWTSignerUtil.createSigner("SM4CMAC", key2);
    }

    public static JWTSigner rmd2(Key key) {
        Key key2;
        return JWTSignerUtil.createSigner("RMD2", key2);
    }

    public static JWTSigner rmd5(Key key) {
        Key key2;
        return JWTSignerUtil.createSigner("RMD5", key2);
    }

    public static JWTSigner rsha1(Key key) {
        Key key2;
        return JWTSignerUtil.createSigner("RSHA1", key2);
    }

    public static JWTSigner dnone(Key key) {
        Key key2;
        return JWTSignerUtil.createSigner("DNONE", key2);
    }

    public static JWTSigner dsha1(Key key) {
        Key key2;
        return JWTSignerUtil.createSigner("DSHA1", key2);
    }

    public static JWTSigner enone(Key key) {
        Key key2;
        return JWTSignerUtil.createSigner("ENONE", key2);
    }

    public static JWTSigner esha1(Key key) {
        Key key2;
        return JWTSignerUtil.createSigner("ESHA1", key2);
    }

    /*
     * WARNING - void declaration
     */
    public static JWTSigner createSigner(String algorithmId, byte[] key) {
        void var1_1;
        String string;
        Assert.notNull(key, "Signer key must be not null!", new Object[0]);
        if (algorithmId == null || "none".equals(algorithmId)) {
            return JWTSignerUtil.none();
        }
        return new HMacJWTSigner(AlgorithmUtil.getAlgorithm(string), (byte[])var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static JWTSigner createSigner(String algorithmId, KeyPair keyPair) {
        void var1_1;
        String string;
        Assert.notNull(keyPair, "Signer key pair must be not null!", new Object[0]);
        if (algorithmId == null || "none".equals(algorithmId)) {
            return JWTSignerUtil.none();
        }
        if (ReUtil.isMatch("es\\d{3}", (CharSequence)algorithmId.toLowerCase())) {
            return new EllipticCurveJWTSigner(AlgorithmUtil.getAlgorithm(algorithmId), keyPair);
        }
        return new AsymmetricJWTSigner(AlgorithmUtil.getAlgorithm(string), (KeyPair)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static JWTSigner createSigner(String algorithmId, Key key) {
        void var1_1;
        String string;
        Assert.notNull(key, "Signer key must be not null!", new Object[0]);
        if (algorithmId == null || "none".equals(algorithmId)) {
            return NoneJWTSigner.NONE;
        }
        if (key instanceof PrivateKey || key instanceof PublicKey) {
            if (ReUtil.isMatch("ES\\d{3}", (CharSequence)algorithmId)) {
                return new EllipticCurveJWTSigner(algorithmId, key);
            }
            return new AsymmetricJWTSigner(AlgorithmUtil.getAlgorithm(algorithmId), key);
        }
        return new HMacJWTSigner(AlgorithmUtil.getAlgorithm(string), (Key)var1_1);
    }
}

