/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.jwt.signers;

import cn.hutool.jwt.JWTException;
import cn.hutool.jwt.signers.AsymmetricJWTSigner;
import java.security.Key;
import java.security.KeyPair;

public class EllipticCurveJWTSigner
extends AsymmetricJWTSigner {
    /*
     * WARNING - void declaration
     */
    public EllipticCurveJWTSigner(String algorithm, Key key) {
        super((String)var1_1, (Key)var2_2);
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public EllipticCurveJWTSigner(String algorithm, KeyPair keyPair) {
        super((String)var1_1, (KeyPair)var2_2);
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected byte[] sign(byte[] data) {
        void var1_1;
        return EllipticCurveJWTSigner.derToConcat(super.sign((byte[])var1_1), EllipticCurveJWTSigner.getSignatureByteArrayLength(this.getAlgorithm()));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected boolean verify(byte[] data, byte[] signed) {
        void var2_2;
        void var1_1;
        return super.verify((byte[])var1_1, EllipticCurveJWTSigner.concatToDER((byte[])var2_2));
    }

    private static int getSignatureByteArrayLength(String alg) throws JWTException {
        String string;
        switch (alg) {
            case "ES256": 
            case "SHA256withECDSA": {
                return 64;
            }
            case "ES384": 
            case "SHA384withECDSA": {
                return 96;
            }
            case "ES512": 
            case "SHA512withECDSA": {
                return 132;
            }
        }
        throw new JWTException("Unsupported Algorithm: {}", string);
    }

    /*
     * WARNING - void declaration
     */
    private static byte[] derToConcat(byte[] derSignature, int outputLength) throws JWTException {
        void var1_2;
        void var3_4;
        void var2_3;
        byte[] byArray;
        int sLength;
        int j;
        int rLength;
        int i;
        int offset;
        if (derSignature.length < 8 || derSignature[0] != 48) {
            throw new JWTException("Invalid ECDSA signature format");
        }
        if (derSignature[1] > 0) {
            offset = 2;
        } else if (derSignature[1] == -127) {
            offset = 3;
        } else {
            throw new JWTException("Invalid ECDSA signature format");
        }
        for (i = rLength = derSignature[offset + 1]; i > 0 && derSignature[offset + 2 + rLength - i] == 0; --i) {
        }
        for (j = sLength = derSignature[offset + 2 + rLength + 1]; j > 0 && derSignature[offset + 2 + rLength + 2 + sLength - j] == 0; --j) {
        }
        int n = Math.max(i, j);
        int rawLen = Math.max(n, outputLength / 2);
        if ((derSignature[offset - 1] & 0xFF) != derSignature.length - offset || (derSignature[offset - 1] & 0xFF) != rLength + 2 + 2 + sLength || derSignature[offset] != 2 || derSignature[offset + 2 + rLength] != 2) {
            throw new JWTException("Invalid ECDSA signature format");
        }
        byte[] concatSignature = new byte[2 * rawLen];
        System.arraycopy(derSignature, offset + 2 + rLength - i, concatSignature, rawLen - i, i);
        System.arraycopy(byArray, (int)(var2_3 + 2 + var3_4 + 2 + sLength - j), concatSignature, 2 * rawLen - j, j);
        return var1_2;
    }

    /*
     * WARNING - void declaration
     */
    private static byte[] concatToDER(byte[] jwsSignature) throws ArrayIndexOutOfBoundsException {
        void var1_1;
        byte[] byArray;
        void var3_3;
        void var2_2;
        int offset;
        byte[] derSignature;
        int len;
        int k;
        int rawLen;
        int i;
        for (i = rawLen = jwsSignature.length / 2; i > 0 && jwsSignature[rawLen - i] == 0; --i) {
        }
        int j = i;
        if (jwsSignature[rawLen - i] < 0) {
            ++j;
        }
        for (k = rawLen; k > 0 && jwsSignature[2 * rawLen - k] == 0; --k) {
        }
        int l = k;
        if (jwsSignature[2 * rawLen - k] < 0) {
            ++l;
        }
        if ((len = j + 2 + 2 + l) > 255) {
            throw new JWTException("Invalid ECDSA signature format");
        }
        if (len < 128) {
            derSignature = new byte[j + 4 + 2 + l];
            offset = 1;
        } else {
            byte[] byArray2 = new byte[j + 5 + 2 + l];
            derSignature = byArray2;
            byArray2[1] = -127;
            offset = 2;
        }
        derSignature[0] = 48;
        derSignature[offset++] = (byte)len;
        derSignature[offset++] = 2;
        derSignature[offset++] = (byte)j;
        System.arraycopy(jwsSignature, rawLen - i, derSignature, offset + j - i, (int)var2_2);
        offset += var3_3;
        derSignature[offset++] = 2;
        derSignature[offset++] = (byte)l;
        System.arraycopy(byArray, 2 * var1_1 - k, derSignature, offset + l - k, k);
        return derSignature;
    }
}

