/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.jwt.signers;

import cn.hutool.core.codec.Base64;
import cn.hutool.core.util.CharsetUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.crypto.asymmetric.Sign;
import cn.hutool.jwt.signers.JWTSigner;
import java.nio.charset.Charset;
import java.security.Key;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.PublicKey;

public class AsymmetricJWTSigner
implements JWTSigner {
    private Charset charset = CharsetUtil.CHARSET_UTF_8;
    private final Sign sign;

    /*
     * WARNING - void declaration
     */
    public AsymmetricJWTSigner(String algorithm, Key key) {
        void var3_3;
        void var2_2;
        void var1_1;
        PublicKey publicKey = key instanceof PublicKey ? (PublicKey)key : null;
        PrivateKey privateKey = key instanceof PrivateKey ? (PrivateKey)key : null;
        this.sign = new Sign((String)var1_1, (PrivateKey)var2_2, (PublicKey)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    public AsymmetricJWTSigner(String algorithm, KeyPair keyPair) {
        void var2_2;
        void var1_1;
        this.sign = new Sign((String)var1_1, (KeyPair)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public AsymmetricJWTSigner setCharset(Charset charset) {
        void var1_1;
        this.charset = var1_1;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public String sign(String headerBase64, String payloadBase64) {
        void var1_1;
        void var2_2;
        String dataStr = StrUtil.format("{}.{}", headerBase64, var2_2);
        return Base64.encodeUrlSafe(this.sign(StrUtil.bytes((CharSequence)var1_1, this.charset)));
    }

    /*
     * WARNING - void declaration
     */
    protected byte[] sign(byte[] data) {
        void var1_1;
        return this.sign.sign((byte[])var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean verify(String headerBase64, String payloadBase64, String signBase64) {
        void var3_3;
        void var2_2;
        void var1_1;
        return this.verify(StrUtil.bytes((CharSequence)StrUtil.format("{}.{}", var1_1, var2_2), this.charset), Base64.decode((CharSequence)var3_3));
    }

    /*
     * WARNING - void declaration
     */
    protected boolean verify(byte[] data, byte[] signed) {
        void var2_2;
        void var1_1;
        return this.sign.verify((byte[])var1_1, (byte[])var2_2);
    }

    @Override
    public String getAlgorithm() {
        return this.sign.getSignature().getAlgorithm();
    }
}

