/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.jwt.signers;

import cn.hutool.core.map.BiMap;
import cn.hutool.core.map.MapWrapper;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.crypto.asymmetric.SignAlgorithm;
import cn.hutool.crypto.digest.HmacAlgorithm;
import java.util.HashMap;

public class AlgorithmUtil {
    private static final BiMap<String, String> map = new BiMap<String, String>(new HashMap());

    public static String getAlgorithm(String idOrAlgorithm) {
        String string;
        return ObjectUtil.defaultIfNull(AlgorithmUtil.getAlgorithmById(idOrAlgorithm), string);
    }

    public static String getId(String idOrAlgorithm) {
        String string;
        return ObjectUtil.defaultIfNull(AlgorithmUtil.getIdByAlgorithm(idOrAlgorithm), string);
    }

    private static String getAlgorithmById(String id) {
        String string;
        return (String)map.get(string.toUpperCase());
    }

    private static String getIdByAlgorithm(String algorithm) {
        String string;
        return map.getKey(string);
    }

    static {
        ((MapWrapper)map).put("HS256", HmacAlgorithm.HmacSHA256.getValue());
        ((MapWrapper)map).put("HS384", HmacAlgorithm.HmacSHA384.getValue());
        ((MapWrapper)map).put("HS512", HmacAlgorithm.HmacSHA512.getValue());
        ((MapWrapper)map).put("HMD5", HmacAlgorithm.HmacMD5.getValue());
        ((MapWrapper)map).put("HSHA1", HmacAlgorithm.HmacSHA1.getValue());
        ((MapWrapper)map).put("SM4CMAC", HmacAlgorithm.SM4CMAC.getValue());
        ((MapWrapper)map).put("RS256", SignAlgorithm.SHA256withRSA.getValue());
        ((MapWrapper)map).put("RS384", SignAlgorithm.SHA384withRSA.getValue());
        ((MapWrapper)map).put("RS512", SignAlgorithm.SHA512withRSA.getValue());
        ((MapWrapper)map).put("ES256", SignAlgorithm.SHA256withECDSA.getValue());
        ((MapWrapper)map).put("ES384", SignAlgorithm.SHA384withECDSA.getValue());
        ((MapWrapper)map).put("ES512", SignAlgorithm.SHA512withECDSA.getValue());
        ((MapWrapper)map).put("PS256", SignAlgorithm.SHA256withRSA_PSS.getValue());
        ((MapWrapper)map).put("PS384", SignAlgorithm.SHA384withRSA_PSS.getValue());
        ((MapWrapper)map).put("PS512", SignAlgorithm.SHA512withRSA_PSS.getValue());
        ((MapWrapper)map).put("RMD2", SignAlgorithm.MD2withRSA.getValue());
        ((MapWrapper)map).put("RMD5", SignAlgorithm.MD5withRSA.getValue());
        ((MapWrapper)map).put("RSHA1", SignAlgorithm.SHA1withRSA.getValue());
        ((MapWrapper)map).put("DNONE", SignAlgorithm.NONEwithDSA.getValue());
        ((MapWrapper)map).put("DSHA1", SignAlgorithm.SHA1withDSA.getValue());
        ((MapWrapper)map).put("ENONE", SignAlgorithm.NONEwithECDSA.getValue());
        ((MapWrapper)map).put("ESHA1", SignAlgorithm.SHA1withECDSA.getValue());
    }
}

