/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.jwt;

import cn.hutool.core.date.DateUtil;
import cn.hutool.core.exceptions.ValidateException;
import cn.hutool.core.util.StrUtil;
import cn.hutool.jwt.JWT;
import cn.hutool.jwt.JWTPayload;
import cn.hutool.jwt.signers.JWTSigner;
import cn.hutool.jwt.signers.NoneJWTSigner;
import java.io.Serializable;
import java.util.Date;

public class JWTValidator {
    private final JWT jwt;

    public static JWTValidator of(String token) {
        String string;
        return new JWTValidator(JWT.of(string));
    }

    public static JWTValidator of(JWT jwt) {
        JWT jWT;
        return new JWTValidator(jWT);
    }

    /*
     * WARNING - void declaration
     */
    public JWTValidator(JWT jwt) {
        void var1_1;
        this.jwt = var1_1;
    }

    public JWTValidator validateAlgorithm() throws ValidateException {
        return this.validateAlgorithm(null);
    }

    /*
     * WARNING - void declaration
     */
    public JWTValidator validateAlgorithm(JWTSigner signer) throws ValidateException {
        void var1_1;
        JWTValidator.validateAlgorithm(this.jwt, (JWTSigner)var1_1);
        return this;
    }

    public JWTValidator validateDate() throws ValidateException {
        return this.validateDate(DateUtil.beginOfSecond(DateUtil.date()));
    }

    /*
     * WARNING - void declaration
     */
    public JWTValidator validateDate(Date dateToCheck) throws ValidateException {
        void var1_1;
        JWTValidator.validateDate(this.jwt.getPayload(), (Date)var1_1, 0L);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public JWTValidator validateDate(Date dateToCheck, long leeway) throws ValidateException {
        void var2_2;
        void var1_1;
        JWTValidator.validateDate(this.jwt.getPayload(), (Date)var1_1, (long)var2_2);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    private static void validateAlgorithm(JWT jwt, JWTSigner signer) throws ValidateException {
        void var1_1;
        JWT jWT;
        String algorithmId = jwt.getAlgorithm();
        if (signer == null) {
            signer = jwt.getSigner();
        }
        if (StrUtil.isEmpty(algorithmId)) {
            if (signer == null || signer instanceof NoneJWTSigner) {
                return;
            }
            throw new ValidateException("No algorithm defined in header!");
        }
        if (signer == null) {
            throw new IllegalArgumentException("No Signer for validate algorithm!");
        }
        String algorithmIdInSigner = signer.getAlgorithmId();
        if (!StrUtil.equals(algorithmId, algorithmIdInSigner)) {
            void var3_3;
            void var2_2;
            throw new ValidateException("Algorithm [{}] defined in header doesn't match to [{}]!", var2_2, var3_3);
        }
        if (!jWT.verify((JWTSigner)var1_1)) {
            throw new ValidateException("Signature verification failed!");
        }
    }

    /*
     * WARNING - void declaration
     */
    private static void validateDate(JWTPayload payload, Date now, long leeway) throws ValidateException {
        void var2_2;
        void var1_1;
        Serializable serializable;
        if (now == null) {
            now = DateUtil.date();
            now.setTime(now.getTime() / 1000L * 1000L);
        }
        Date notBefore = payload.getClaimsJson().getDate("nbf");
        JWTValidator.validateNotAfter("nbf", notBefore, now, leeway);
        Date expiresAt = payload.getClaimsJson().getDate("exp");
        JWTValidator.validateNotBefore("exp", expiresAt, now, leeway);
        Serializable issueAt = payload.getClaimsJson().getDate("iat");
        JWTValidator.validateNotAfter("iat", (Date)serializable, (Date)var1_1, (long)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    private static void validateNotAfter(String fieldName, Date dateToCheck, Date now, long leeway) throws ValidateException {
        if (dateToCheck == null) {
            return;
        }
        if (leeway > 0L) {
            void var3_3;
            now = DateUtil.date(now.getTime() + var3_3 * 1000L);
        }
        if (dateToCheck.after(now)) {
            void var2_2;
            void var1_1;
            String string;
            throw new ValidateException("'{}':[{}] is after now:[{}]", string, DateUtil.date((Date)var1_1), DateUtil.date((Date)var2_2));
        }
    }

    /*
     * WARNING - void declaration
     */
    private static void validateNotBefore(String fieldName, Date dateToCheck, Date now, long leeway) throws ValidateException {
        if (dateToCheck == null) {
            return;
        }
        if (leeway > 0L) {
            void var3_3;
            now = DateUtil.date(now.getTime() - var3_3 * 1000L);
        }
        if (dateToCheck.before(now)) {
            void var2_2;
            void var1_1;
            String string;
            throw new ValidateException("'{}':[{}] is before now:[{}]", string, DateUtil.date((Date)var1_1), DateUtil.date((Date)var2_2));
        }
    }
}

