/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.jwt;

import cn.hutool.core.codec.Base64;
import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.exceptions.ValidateException;
import cn.hutool.core.lang.Assert;
import cn.hutool.core.util.CharsetUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.json.JSONObject;
import cn.hutool.jwt.JWTException;
import cn.hutool.jwt.JWTHeader;
import cn.hutool.jwt.JWTPayload;
import cn.hutool.jwt.JWTValidator;
import cn.hutool.jwt.RegisteredPayload;
import cn.hutool.jwt.signers.AlgorithmUtil;
import cn.hutool.jwt.signers.JWTSigner;
import cn.hutool.jwt.signers.JWTSignerUtil;
import cn.hutool.jwt.signers.NoneJWTSigner;
import java.nio.charset.Charset;
import java.security.Key;
import java.security.KeyPair;
import java.util.List;
import java.util.Map;

public class JWT
implements RegisteredPayload<JWT> {
    private final JWTHeader header = new JWTHeader();
    private final JWTPayload payload = new JWTPayload();
    private Charset charset = CharsetUtil.CHARSET_UTF_8;
    private JWTSigner signer;
    private List<String> tokens;

    public static JWT create() {
        return new JWT();
    }

    public static JWT of(String token) {
        String string;
        return new JWT(string);
    }

    public JWT() {
    }

    /*
     * WARNING - void declaration
     */
    public JWT(String token) {
        this();
        void var1_1;
        this.parse((String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public JWT parse(String token) {
        void var1_1;
        Assert.notBlank(token, "Token String must be not blank!", new Object[0]);
        List<String> tokens = JWT.splitToken(token);
        this.tokens = tokens;
        this.header.parse(tokens.get(0), this.charset);
        this.payload.parse((String)var1_1.get(1), this.charset);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public JWT setCharset(Charset charset) {
        void var1_1;
        this.charset = var1_1;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public JWT setKey(byte[] key) {
        void var1_1;
        String claim = (String)this.header.getClaim(JWTHeader.ALGORITHM);
        if (StrUtil.isNotBlank(claim)) {
            void var2_2;
            return this.setSigner(JWTSignerUtil.createSigner((String)var2_2, key));
        }
        return this.setSigner(JWTSignerUtil.hs256((byte[])var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public JWT setSigner(String algorithmId, byte[] key) {
        void var2_2;
        void var1_1;
        return this.setSigner(JWTSignerUtil.createSigner((String)var1_1, (byte[])var2_2));
    }

    /*
     * WARNING - void declaration
     */
    public JWT setSigner(String algorithmId, Key key) {
        void var2_2;
        void var1_1;
        return this.setSigner(JWTSignerUtil.createSigner((String)var1_1, (Key)var2_2));
    }

    /*
     * WARNING - void declaration
     */
    public JWT setSigner(String algorithmId, KeyPair keyPair) {
        void var2_2;
        void var1_1;
        return this.setSigner(JWTSignerUtil.createSigner((String)var1_1, (KeyPair)var2_2));
    }

    /*
     * WARNING - void declaration
     */
    public JWT setSigner(JWTSigner signer) {
        void var1_1;
        this.signer = var1_1;
        return this;
    }

    public JWTSigner getSigner() {
        return this.signer;
    }

    public JSONObject getHeaders() {
        return this.header.getClaimsJson();
    }

    public JWTHeader getHeader() {
        return this.header;
    }

    /*
     * WARNING - void declaration
     */
    public Object getHeader(String name) {
        void var1_1;
        return this.header.getClaim((String)var1_1);
    }

    public String getAlgorithm() {
        return (String)this.header.getClaim(JWTHeader.ALGORITHM);
    }

    /*
     * WARNING - void declaration
     */
    public JWT setHeader(String name, Object value) {
        void var2_2;
        void var1_1;
        this.header.setClaim((String)var1_1, var2_2);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public JWT addHeaders(Map<String, ?> headers) {
        void var1_1;
        this.header.addHeaders((Map<String, ?>)var1_1);
        return this;
    }

    public JSONObject getPayloads() {
        return this.payload.getClaimsJson();
    }

    public JWTPayload getPayload() {
        return this.payload;
    }

    /*
     * WARNING - void declaration
     */
    public Object getPayload(String name) {
        void var1_1;
        return this.getPayload().getClaim((String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public JWT setPayload(String name, Object value) {
        void var2_2;
        void var1_1;
        this.payload.setClaim((String)var1_1, var2_2);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public JWT addPayloads(Map<String, ?> payloads) {
        void var1_1;
        this.payload.addPayloads((Map<String, ?>)var1_1);
        return this;
    }

    public String sign() {
        return this.sign(true);
    }

    /*
     * WARNING - void declaration
     */
    public String sign(boolean addTypeIfNot) {
        void var1_1;
        JWT jWT = this;
        return jWT.sign(jWT.signer, (boolean)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public String sign(JWTSigner signer) {
        void var1_1;
        return this.sign((JWTSigner)var1_1, true);
    }

    /*
     * WARNING - void declaration
     */
    public String sign(JWTSigner signer, boolean addTypeIfNot) {
        void var1_1;
        void var3_5;
        void var2_4;
        Assert.notNull(signer, () -> new JWTException("No Signer provided!"));
        if (addTypeIfNot && StrUtil.isBlank(addTypeIfNot = (String)this.header.getClaim(JWTHeader.TYPE))) {
            this.header.setClaim(JWTHeader.TYPE, "JWT");
        }
        if (StrUtil.isBlank(addTypeIfNot = (String)this.header.getClaim(JWTHeader.ALGORITHM))) {
            this.header.setClaim(JWTHeader.ALGORITHM, AlgorithmUtil.getId(signer.getAlgorithm()));
        }
        String headerBase64 = Base64.encodeUrlSafe((CharSequence)this.header.toString(), this.charset);
        String payloadBase64 = Base64.encodeUrlSafe((CharSequence)this.payload.toString(), this.charset);
        String sign = signer.sign(headerBase64, payloadBase64);
        return StrUtil.format("{}.{}.{}", var2_4, var3_5, var1_1);
    }

    public boolean verify() {
        JWT jWT = this;
        return jWT.verify(jWT.signer);
    }

    /*
     * WARNING - void declaration
     */
    public boolean validate(long leeway) {
        if (!this.verify()) {
            return false;
        }
        try {
            void var1_1;
            JWTValidator.of(this).validateDate(DateUtil.date(), (long)var1_1);
        }
        catch (ValidateException validateException) {
            return false;
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public boolean verify(JWTSigner signer) {
        void var2_2;
        void var1_1;
        List<String> tokens;
        if (signer == null) {
            signer = NoneJWTSigner.NONE;
        }
        if (CollUtil.isEmpty(tokens = this.tokens)) {
            throw new JWTException("No token to verify!");
        }
        return var1_1.verify(tokens.get(0), tokens.get(1), (String)var2_2.get(2));
    }

    private static List<String> splitToken(String token) {
        List<String> list;
        List<String> tokens = StrUtil.split((CharSequence)token, '.');
        if (3 != tokens.size()) {
            throw new JWTException("The token was expected 3 parts, but got {}.", tokens.size());
        }
        return list;
    }
}

