/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.json.xml;

import cn.hutool.core.util.ArrayUtil;
import cn.hutool.core.util.EscapeUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.json.JSONArray;
import cn.hutool.json.JSONException;
import cn.hutool.json.JSONObject;

public class JSONXMLSerializer {
    public static String toXml(Object object) throws JSONException {
        return JSONXMLSerializer.toXml(object, null);
    }

    /*
     * WARNING - void declaration
     */
    public static String toXml(Object object, String tagName) throws JSONException {
        void var1_1;
        return JSONXMLSerializer.toXml(object, (String)var1_1, "content");
    }

    /*
     * WARNING - void declaration
     */
    public static String toXml(Object object, String tagName, String ... contentKeys) throws JSONException {
        void var1_1;
        Object object2;
        if (object == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        if (object instanceof JSONObject) {
            JSONXMLSerializer.appendTag(sb, tagName, false);
            ((JSONObject)((Object)object)).forEach((key, value) -> {
                void var2_2;
                void var1_1;
                void var3_3;
                Object object;
                if (ArrayUtil.isArray(value)) {
                    value = new JSONArray(value);
                }
                if (ArrayUtil.contains(contentKeys, key)) {
                    if (value instanceof JSONArray) {
                        int i = 0;
                        for (Object val : (JSONArray)((Object)value)) {
                            if (i > 0) {
                                sb.append('\n');
                            }
                            sb.append(EscapeUtil.escapeXml(object.toString()));
                            ++i;
                        }
                        return;
                    }
                    sb.append(EscapeUtil.escapeXml(value.toString()));
                    return;
                }
                if (StrUtil.isEmptyIfStr(value)) {
                    sb.append(JSONXMLSerializer.wrapWithTag(null, key));
                    return;
                }
                if (value instanceof JSONArray) {
                    for (Object val : (JSONArray)((Object)value)) {
                        if (val instanceof JSONArray) {
                            sb.append(JSONXMLSerializer.wrapWithTag(JSONXMLSerializer.toXml(val, null, (String[])object), key));
                            continue;
                        }
                        sb.append(JSONXMLSerializer.toXml(var3_3, key, (String[])object));
                    }
                    return;
                }
                var1_1.append(JSONXMLSerializer.toXml(var3_3, (String)var2_2, (String[])object));
            });
            JSONXMLSerializer.appendTag(sb, tagName, true);
            return sb.toString();
        }
        if (ArrayUtil.isArray(object)) {
            object = new JSONArray(object);
        }
        if (object instanceof JSONArray) {
            void var3_3;
            for (Object val : (JSONArray)((Object)object)) {
                sb.append(JSONXMLSerializer.toXml(val, tagName == null ? "array" : tagName, contentKeys));
            }
            return var3_3.toString();
        }
        return JSONXMLSerializer.wrapWithTag(EscapeUtil.escapeXml(object2.toString()), (String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private static void appendTag(StringBuilder sb, String tagName, boolean isEndTag) {
        if (StrUtil.isNotBlank(tagName)) {
            void var1_1;
            StringBuilder stringBuilder;
            void var2_2;
            sb.append('<');
            if (var2_2 != false) {
                sb.append('/');
            }
            stringBuilder.append((String)var1_1).append('>');
        }
    }

    /*
     * WARNING - void declaration
     */
    private static String wrapWithTag(String content, String tagName) {
        void var1_1;
        String string;
        if (StrUtil.isBlank(tagName)) {
            return StrUtil.wrap(content, "\"");
        }
        if (StrUtil.isEmpty(content)) {
            return "<" + tagName + "/>";
        }
        return "<" + tagName + ">" + string + "</" + (String)var1_1 + ">";
    }
}

