/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.json.xml;

import cn.hutool.json.InternalJSONUtil;
import cn.hutool.json.JSONException;
import cn.hutool.json.JSONObject;
import cn.hutool.json.XML;
import cn.hutool.json.XMLTokener;
import cn.hutool.json.xml.ParseConfig;

public class JSONXMLParser {
    /*
     * WARNING - void declaration
     */
    public static void parseJSONObject(JSONObject jo, String xmlStr, boolean keepStrings) throws JSONException {
        void var2_2;
        void var1_1;
        JSONXMLParser.parseJSONObject(jo, (String)var1_1, ParseConfig.of().setKeepStrings((boolean)var2_2));
    }

    public static void parseJSONObject(JSONObject jo, String xmlStr, ParseConfig parseConfig) throws JSONException {
        XMLTokener x = new XMLTokener(xmlStr, jo.getConfig());
        while (x.more() && x.skipPast("<")) {
            JSONXMLParser.parse(x, jo, null, parseConfig, 0);
        }
    }

    /*
     * WARNING - void declaration
     */
    private static boolean parse(XMLTokener x, JSONObject context, String name, ParseConfig parseConfig, int currentNestingDepth) throws JSONException {
        XMLTokener xMLTokener;
        void var1_1;
        Object token = x.nextToken();
        if (token == XML.BANG) {
            char c = x.next();
            if (c == '-') {
                if (x.next() == '-') {
                    x.skipPast("-->");
                    return false;
                }
                x.back();
            } else if (c == '[') {
                token = x.nextToken();
                if ("CDATA".equals(token) && x.next() == '[') {
                    String string = x.nextCDATA();
                    if (string.length() > 0) {
                        context.accumulate("content", string);
                    }
                    return false;
                }
                throw x.syntaxError("Expected 'CDATA['");
            }
            int i = 1;
            do {
                if ((token = x.nextMeta()) == null) {
                    throw x.syntaxError("Missing '>' after '<!'.");
                }
                if (token == XML.LT) {
                    ++i;
                    continue;
                }
                if (token != XML.GT) continue;
                --i;
            } while (i > 0);
            return false;
        }
        if (token == XML.QUEST) {
            x.skipPast("?>");
            return false;
        }
        if (token == XML.SLASH) {
            void c;
            token = x.nextToken();
            if (c == null) {
                throw x.syntaxError("Mismatched close tag " + token);
            }
            if (!token.equals(c)) {
                throw x.syntaxError("Mismatched " + (String)c + " and " + token);
            }
            if (x.nextToken() != XML.GT) {
                throw x.syntaxError("Misshaped close tag");
            }
            return true;
        }
        if (token instanceof Character) {
            throw x.syntaxError("Misshaped tag");
        }
        String tagName = (String)token;
        token = null;
        JSONObject jsonobject = new JSONObject();
        boolean keepStrings = parseConfig.isKeepStrings();
        while (true) {
            if (token == null) {
                token = x.nextToken();
            }
            if (!(token instanceof String)) break;
            String string = (String)token;
            token = x.nextToken();
            if (token == XML.EQ) {
                token = x.nextToken();
                if (!(token instanceof String)) {
                    throw x.syntaxError("Missing value");
                }
                jsonobject.accumulate(string, keepStrings ? token : InternalJSONUtil.stringToValue((String)token));
                token = null;
                continue;
            }
            jsonobject.accumulate(string, "");
        }
        if (token == XML.SLASH) {
            if (x.nextToken() != XML.GT) {
                throw x.syntaxError("Misshaped tag");
            }
            if (jsonobject.size() > 0) {
                var1_1.accumulate(tagName, jsonobject);
            } else {
                var1_1.accumulate(tagName, "");
            }
            return false;
        }
        if (token == XML.GT) {
            while (true) {
                if ((token = x.nextContent()) == null) {
                    if (tagName != null) {
                        throw x.syntaxError("Unclosed tag " + tagName);
                    }
                    return false;
                }
                if (token instanceof String) {
                    String string = (String)token;
                    if (string.isEmpty()) continue;
                    jsonobject.accumulate("content", keepStrings ? token : InternalJSONUtil.stringToValue(string));
                    continue;
                }
                if (token != XML.LT) continue;
                int maxNestingDepth = parseConfig.getMaxNestingDepth();
                if (maxNestingDepth >= 0 && currentNestingDepth >= maxNestingDepth) {
                    throw x.syntaxError("Maximum nesting depth of " + maxNestingDepth + " reached");
                }
                if (JSONXMLParser.parse(x, jsonobject, tagName, parseConfig, currentNestingDepth + 1)) break;
            }
            if (jsonobject.isEmpty()) {
                var1_1.accumulate(tagName, "");
            } else if (jsonobject.size() == 1 && jsonobject.get("content") != null) {
                var1_1.accumulate(tagName, jsonobject.get("content"));
            } else {
                var1_1.accumulate(tagName, jsonobject);
            }
            return false;
        }
        throw xMLTokener.syntaxError("Misshaped tag");
    }
}

