/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.json.serialize;

import cn.hutool.core.lang.Assert;
import cn.hutool.json.JSON;
import cn.hutool.json.JSONException;
import cn.hutool.json.JSONObject;
import cn.hutool.json.serialize.JSONDeserializer;
import cn.hutool.json.serialize.JSONObjectSerializer;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.Month;
import java.time.temporal.TemporalAccessor;

public class TemporalAccessorSerializer
implements JSONDeserializer<TemporalAccessor>,
JSONObjectSerializer<TemporalAccessor> {
    private static final String YEAR_KEY = "year";
    private static final String MONTH_KEY = "month";
    private static final String DAY_KEY = "day";
    private static final String HOUR_KEY = "hour";
    private static final String MINUTE_KEY = "minute";
    private static final String SECOND_KEY = "second";
    private static final String NANO_KEY = "nano";
    private final Class<? extends TemporalAccessor> temporalAccessorClass;

    /*
     * WARNING - void declaration
     */
    public TemporalAccessorSerializer(Class<? extends TemporalAccessor> temporalAccessorClass) {
        void var1_1;
        this.temporalAccessorClass = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void serialize(JSONObject json, TemporalAccessor bean) {
        void var2_2;
        LocalDateTime localDateTime;
        LocalDate localDate;
        if (bean instanceof LocalDate) {
            localDate = (LocalDate)bean;
            json.set(YEAR_KEY, localDate.getYear());
            json.set(MONTH_KEY, localDate.getMonthValue());
            json.set(DAY_KEY, localDate.getDayOfMonth());
            return;
        }
        if (localDate instanceof LocalDateTime) {
            localDateTime = (LocalDateTime)((Object)localDate);
            json.set(YEAR_KEY, localDateTime.getYear());
            json.set(MONTH_KEY, localDateTime.getMonthValue());
            json.set(DAY_KEY, localDateTime.getDayOfMonth());
            json.set(HOUR_KEY, localDateTime.getHour());
            json.set(MINUTE_KEY, localDateTime.getMinute());
            json.set(SECOND_KEY, localDateTime.getSecond());
            json.set(NANO_KEY, localDateTime.getNano());
            return;
        }
        if (localDateTime instanceof LocalTime) {
            void var1_1;
            LocalTime localTime = (LocalTime)((Object)localDateTime);
            json.set(HOUR_KEY, localTime.getHour());
            json.set(MINUTE_KEY, localTime.getMinute());
            json.set(SECOND_KEY, localTime.getSecond());
            var1_1.set(NANO_KEY, var2_2.getNano());
            return;
        }
        throw new JSONException("Unsupported type to JSON: {}", var2_2.getClass().getName());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public TemporalAccessor deserialize(JSON json) {
        void var1_1;
        JSONObject jsonObject = (JSONObject)json;
        if (LocalDate.class.equals(this.temporalAccessorClass) || LocalDateTime.class.equals(this.temporalAccessorClass)) {
            void var2_2;
            void var3_3;
            Integer day;
            Integer year = jsonObject.getInt(YEAR_KEY);
            Assert.notNull(year, "Field 'year' must be not null", new Object[0]);
            Integer month = jsonObject.getInt(MONTH_KEY);
            if (month == null) {
                Month monthEnum = Month.valueOf(jsonObject.getStr(MONTH_KEY));
                Assert.notNull(monthEnum, "Field 'month' must be not null", new Object[0]);
                month = monthEnum.getValue();
            }
            if ((day = jsonObject.getInt(DAY_KEY)) == null) {
                day = jsonObject.getInt("dayOfMonth");
                Assert.notNull(day, "Field 'day' or 'dayOfMonth' must be not null", new Object[0]);
            }
            LocalDate localDate = LocalDate.of((int)year, var3_3.intValue(), (int)day);
            if (LocalDate.class.equals(this.temporalAccessorClass)) {
                return localDate;
            }
            LocalTime localTime = LocalTime.of(jsonObject.getInt(HOUR_KEY, 0), jsonObject.getInt(MINUTE_KEY, 0), jsonObject.getInt(SECOND_KEY, 0), jsonObject.getInt(NANO_KEY, 0));
            return LocalDateTime.of((LocalDate)var2_2, (LocalTime)var1_1);
        }
        if (LocalTime.class.equals(this.temporalAccessorClass)) {
            return LocalTime.of(var1_1.getInt(HOUR_KEY), var1_1.getInt(MINUTE_KEY), var1_1.getInt(SECOND_KEY), var1_1.getInt(NANO_KEY));
        }
        throw new JSONException("Unsupported type from JSON: {}", this.temporalAccessorClass);
    }
}

