/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.json.serialize;

import cn.hutool.core.convert.Convert;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.date.TemporalAccessorUtil;
import cn.hutool.core.io.IORuntimeException;
import cn.hutool.core.lang.Filter;
import cn.hutool.core.lang.mutable.MutablePair;
import cn.hutool.core.util.ArrayUtil;
import cn.hutool.core.util.NumberUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.json.JSON;
import cn.hutool.json.JSONArray;
import cn.hutool.json.JSONConfig;
import cn.hutool.json.JSONException;
import cn.hutool.json.JSONNull;
import cn.hutool.json.JSONObject;
import cn.hutool.json.JSONString;
import cn.hutool.json.JSONUtil;
import java.io.IOException;
import java.io.Writer;
import java.time.MonthDay;
import java.time.temporal.TemporalAccessor;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;

public class JSONWriter
extends Writer {
    private final int indentFactor;
    private final int indent;
    private final Writer writer;
    private final JSONConfig config;
    private boolean needSeparator;
    private boolean arrayMode;

    /*
     * WARNING - void declaration
     */
    public static JSONWriter of(Writer writer, int indentFactor, int indent, JSONConfig config) {
        void var3_3;
        void var2_2;
        void var1_1;
        Writer writer2;
        return new JSONWriter(writer2, (int)var1_1, (int)var2_2, (JSONConfig)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    public JSONWriter(Writer writer, int indentFactor, int indent, JSONConfig config) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.writer = var1_1;
        this.indentFactor = var2_2;
        this.indent = var3_3;
        this.config = config;
    }

    public JSONWriter beginObj() {
        this.writeRaw('{');
        return this;
    }

    public JSONWriter beginArray() {
        this.writeRaw('[');
        this.arrayMode = true;
        return this;
    }

    public JSONWriter end() {
        this.writeLF().writeSpace(this.indent);
        JSONWriter jSONWriter = this;
        jSONWriter.writeRaw(jSONWriter.arrayMode ? (char)']' : '}');
        this.flush();
        this.arrayMode = false;
        this.needSeparator = true;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public JSONWriter writeKey(String key) {
        void var1_1;
        if (this.needSeparator) {
            this.writeRaw(',');
        }
        this.writeLF().writeSpace(this.indentFactor + this.indent);
        return this.writeRaw(JSONUtil.quote((String)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public JSONWriter writeValue(Object value) {
        void var1_1;
        if (JSONUtil.isNull(value) && this.config.isIgnoreNullValue()) {
            return this;
        }
        return this.writeValueDirect(var1_1, null);
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public JSONWriter writeField(String key, Object value) {
        void var2_2;
        void var1_1;
        if (JSONUtil.isNull(value) && this.config.isIgnoreNullValue()) {
            return this;
        }
        return this.writeKey((String)var1_1).writeValueDirect(var2_2, null);
    }

    /*
     * WARNING - void declaration
     */
    public JSONWriter writeField(MutablePair<Object, Object> pair, Filter<MutablePair<Object, Object>> filter) {
        if (JSONUtil.isNull(pair.getValue()) && this.config.isIgnoreNullValue()) {
            return this;
        }
        if (filter == null || filter.accept(pair)) {
            void var2_2;
            void var1_1;
            if (!this.arrayMode) {
                this.writeKey(StrUtil.toString(pair.getKey()));
            }
            return this.writeValueDirect(var1_1.getValue(), (Filter<MutablePair<Object, Object>>)var2_2);
        }
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void write(char[] cbuf, int off, int len) throws IOException {
        void var3_3;
        void var2_2;
        void var1_1;
        this.writer.write((char[])var1_1, (int)var2_2, (int)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void flush() {
        try {
            this.writer.flush();
            return;
        }
        catch (IOException e) {
            void var1_1;
            throw new IORuntimeException((Throwable)var1_1);
        }
    }

    @Override
    public void close() throws IOException {
        this.writer.close();
    }

    /*
     * WARNING - void declaration
     */
    private JSONWriter writeValueDirect(Object value, Filter<MutablePair<Object, Object>> filter) {
        void var2_2;
        void var1_1;
        if (this.arrayMode) {
            if (this.needSeparator) {
                this.writeRaw(',');
            }
            this.writeLF().writeSpace(this.indentFactor + this.indent);
        } else {
            this.writeRaw(':').writeSpace(1);
        }
        this.needSeparator = true;
        return this.writeObjValue(var1_1, (Filter<MutablePair<Object, Object>>)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    private JSONWriter writeObjValue(Object value, Filter<MutablePair<Object, Object>> filter) {
        int indent = this.indentFactor + this.indent;
        if (value == null || value instanceof JSONNull) {
            this.writeRaw(JSONNull.NULL.toString());
        } else if (value instanceof JSON) {
            if (value instanceof JSONObject) {
                ((JSONObject)value).write(this.writer, this.indentFactor, indent, filter);
            } else if (value instanceof JSONArray) {
                ((JSONArray)value).write(this.writer, this.indentFactor, indent, filter);
            }
        } else if (value instanceof Map || value instanceof Map.Entry) {
            new JSONObject(value).write(this.writer, this.indentFactor, indent);
        } else if (value instanceof Iterable || value instanceof Iterator || ArrayUtil.isArray(value)) {
            void var3_3;
            new JSONArray(value).write(this.writer, this.indentFactor, (int)var3_3);
        } else if (value instanceof Number) {
            this.writeNumberValue((Number)value);
        } else if (value instanceof Date || value instanceof Calendar || value instanceof TemporalAccessor) {
            void var2_2;
            if (value instanceof MonthDay) {
                this.writeStrValue(value.toString());
                return this;
            }
            String format = this.config == null ? null : this.config.getDateFormat();
            this.writeRaw(JSONWriter.formatDate(value, (String)var2_2));
        } else if (value instanceof Boolean) {
            this.writeBooleanValue((Boolean)value);
        } else if (value instanceof JSONString) {
            this.writeJSONStringValue((JSONString)value);
        } else {
            void var1_1;
            this.writeStrValue(var1_1.toString());
        }
        return this;
    }

    /*
     * WARNING - void declaration
     */
    private void writeNumberValue(Number number) {
        void var2_2;
        void var1_1;
        boolean isStripTrailingZeros = this.config == null || this.config.isStripTrailingZeros();
        this.writeRaw(NumberUtil.toStr((Number)var1_1, (boolean)var2_2));
    }

    /*
     * WARNING - void declaration
     */
    private void writeBooleanValue(Boolean value) {
        void var1_1;
        this.writeRaw(var1_1.toString());
    }

    /*
     * WARNING - void declaration
     */
    private void writeJSONStringValue(JSONString jsonString) {
        void var1_1;
        String valueStr;
        try {
            valueStr = jsonString.toJSONString();
        }
        catch (Exception e) {
            void var1_2;
            throw new JSONException((Throwable)var1_2);
        }
        if (valueStr != null) {
            void var2_3;
            this.writeRaw((String)var2_3);
            return;
        }
        this.writeStrValue(var1_1.toString());
    }

    /*
     * WARNING - void declaration
     */
    private void writeStrValue(String csq) {
        try {
            JSONUtil.quote(csq, this.writer);
            return;
        }
        catch (IOException e) {
            void var1_2;
            throw new IORuntimeException((Throwable)var1_2);
        }
    }

    private void writeSpace(int count) {
        if (this.indentFactor > 0) {
            for (int i = 0; i < count; ++i) {
                this.writeRaw(' ');
            }
        }
    }

    private JSONWriter writeLF() {
        if (this.indentFactor > 0) {
            this.writeRaw('\n');
        }
        return this;
    }

    /*
     * WARNING - void declaration
     */
    private JSONWriter writeRaw(String csq) {
        try {
            this.writer.append(csq);
        }
        catch (IOException e) {
            void var1_2;
            throw new IORuntimeException((Throwable)var1_2);
        }
        return this;
    }

    /*
     * WARNING - void declaration
     */
    private JSONWriter writeRaw(char c) {
        try {
            this.writer.write(c);
        }
        catch (IOException e) {
            void var1_2;
            throw new IORuntimeException((Throwable)var1_2);
        }
        return this;
    }

    /*
     * WARNING - void declaration
     */
    private static String formatDate(Object dateObj, String format) {
        void var2_3;
        long timeMillis;
        if (StrUtil.isNotBlank(format)) {
            void var1_1;
            String dateStr = dateObj instanceof TemporalAccessor ? TemporalAccessorUtil.format((TemporalAccessor)dateObj, format) : DateUtil.format(Convert.toDate(dateObj), format);
            if ("#sss".equals(format) || "#SSS".equals(var1_1)) {
                return dateStr;
            }
            return JSONUtil.quote(dateStr);
        }
        if (dateObj instanceof TemporalAccessor) {
            timeMillis = TemporalAccessorUtil.toEpochMilli((TemporalAccessor)dateObj);
        } else if (dateObj instanceof Date) {
            timeMillis = ((Date)dateObj).getTime();
        } else if (dateObj instanceof Calendar) {
            timeMillis = ((Calendar)dateObj).getTimeInMillis();
        } else {
            Object object;
            throw new UnsupportedOperationException("Unsupported Date type: " + object.getClass());
        }
        return String.valueOf((long)var2_3);
    }
}

