/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.json;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.ArrayIter;
import cn.hutool.core.convert.Convert;
import cn.hutool.core.io.IoUtil;
import cn.hutool.core.lang.Filter;
import cn.hutool.core.lang.mutable.Mutable;
import cn.hutool.core.lang.mutable.MutablePair;
import cn.hutool.core.util.ArrayUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.core.util.TypeUtil;
import cn.hutool.json.InternalJSONUtil;
import cn.hutool.json.JSON;
import cn.hutool.json.JSONArray;
import cn.hutool.json.JSONConfig;
import cn.hutool.json.JSONException;
import cn.hutool.json.JSONObject;
import cn.hutool.json.JSONParser;
import cn.hutool.json.JSONTokener;
import cn.hutool.json.JSONUtil;
import cn.hutool.json.XML;
import cn.hutool.json.serialize.GlobalSerializeMapping;
import cn.hutool.json.serialize.JSONObjectSerializer;
import cn.hutool.json.serialize.JSONSerializer;
import java.io.InputStream;
import java.io.Reader;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import java.util.ResourceBundle;

public class ObjectMapper {
    private final Object source;

    public static ObjectMapper of(Object source) {
        Object object;
        return new ObjectMapper(object);
    }

    /*
     * WARNING - void declaration
     */
    public ObjectMapper(Object source) {
        void var1_1;
        this.source = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public void map(JSONObject jsonObject, Filter<MutablePair<String, Object>> filter) {
        void var3_3;
        Iterator source = this.source;
        if (source == null) {
            return;
        }
        JSONSerializer<JSON, ?> serializer = GlobalSerializeMapping.getSerializer(source.getClass());
        if (serializer instanceof JSONObjectSerializer) {
            serializer.serialize(jsonObject, source);
            return;
        }
        if (source instanceof JSONArray) {
            throw new JSONException("Unsupported type [{}] to JSONObject!", source.getClass());
        }
        if (source instanceof Map) {
            for (Map.Entry e : ((Map)((Object)source)).entrySet()) {
                jsonObject.set(Convert.toStr(e.getKey()), e.getValue(), filter, jsonObject.getConfig().isCheckDuplicate());
            }
            return;
        }
        if (source instanceof Map.Entry) {
            Map.Entry entry = (Map.Entry)((Object)source);
            jsonObject.set(Convert.toStr(entry.getKey()), var3_3.getValue(), filter, jsonObject.getConfig().isCheckDuplicate());
            return;
        }
        if (var3_3 instanceof CharSequence) {
            ObjectMapper.mapFromStr((CharSequence)var3_3, jsonObject, filter);
            return;
        }
        if (var3_3 instanceof Reader) {
            ObjectMapper.mapFromTokener(new JSONTokener((Reader)var3_3, jsonObject.getConfig()), jsonObject, filter);
            return;
        }
        if (var3_3 instanceof InputStream) {
            ObjectMapper.mapFromTokener(new JSONTokener((InputStream)var3_3, jsonObject.getConfig()), jsonObject, filter);
            return;
        }
        if (var3_3 instanceof byte[]) {
            ObjectMapper.mapFromTokener(new JSONTokener(IoUtil.toStream((byte[])var3_3), jsonObject.getConfig()), jsonObject, filter);
            return;
        }
        if (var3_3 instanceof JSONTokener) {
            ObjectMapper.mapFromTokener((JSONTokener)var3_3, jsonObject, filter);
            return;
        }
        if (var3_3 instanceof ResourceBundle) {
            void var2_2;
            ObjectMapper.mapFromResourceBundle((ResourceBundle)var3_3, jsonObject, (Filter<MutablePair<String, Object>>)var2_2);
            return;
        }
        if (BeanUtil.isReadableBean(var3_3.getClass())) {
            void var1_1;
            ObjectMapper.mapFromBean(var3_3, (JSONObject)var1_1);
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    public void map(JSONArray jsonArray, Filter<Mutable<Object>> filter22) throws JSONException {
        Iterator<Object> iter;
        Filter<Mutable<Object>> filter22;
        void var3_4;
        Object source = this.source;
        if (source == null) {
            return;
        }
        JSONSerializer<JSON, ?> serializer = GlobalSerializeMapping.getSerializer(source.getClass());
        if (serializer != null && JSONArray.class.equals((Object)TypeUtil.getTypeArgument(serializer.getClass()))) {
            serializer.serialize(jsonArray, source);
            return;
        }
        if (source instanceof CharSequence) {
            this.mapFromStr((CharSequence)source, jsonArray, filter22);
            return;
        }
        if (source instanceof Reader) {
            ObjectMapper.mapFromTokener(new JSONTokener((Reader)source, jsonArray.getConfig()), jsonArray, filter22);
            return;
        }
        if (source instanceof InputStream) {
            ObjectMapper.mapFromTokener(new JSONTokener((InputStream)source, jsonArray.getConfig()), jsonArray, filter22);
            return;
        }
        if (source instanceof byte[]) {
            byte[] bytesSource = (byte[])source;
            if (bytesSource.length > 1 && 91 == bytesSource[0] && 93 == bytesSource[bytesSource.length - 1]) {
                ObjectMapper.mapFromTokener(new JSONTokener(IoUtil.toStream(bytesSource), jsonArray.getConfig()), jsonArray, filter22);
                return;
            }
            byte[] byArray = bytesSource;
            int n = bytesSource.length;
            int filter22 = 0;
            while (filter22 < n) {
                void var3_5;
                byte b = byArray[filter22];
                jsonArray.add((Object)((byte)var3_5));
                ++filter22;
            }
            return;
        }
        if (var3_4 instanceof JSONTokener) {
            ObjectMapper.mapFromTokener((JSONTokener)var3_4, jsonArray, filter22);
            return;
        }
        if (ArrayUtil.isArray(var3_4)) {
            iter = new ArrayIter(var3_4);
        } else if (var3_4 instanceof Iterator) {
            iter = (Iterator)var3_4;
        } else {
            if (!(var3_4 instanceof Iterable)) {
                if (false != jsonArray.getConfig().isIgnoreError()) return;
                throw new JSONException("JSONArray initial value should be a string or collection or array.");
            }
            iter = ((Iterable)var3_4).iterator();
        }
        JSONConfig config = jsonArray.getConfig();
        while (iter.hasNext()) {
            Object next = iter.next();
            if (next == var3_4) continue;
            jsonArray.addRaw(JSONUtil.wrap(next, config), filter22);
        }
    }

    private static void mapFromResourceBundle(ResourceBundle bundle, JSONObject jsonObject, Filter<MutablePair<String, Object>> filter) {
        Enumeration<String> keys = bundle.getKeys();
        while (keys.hasMoreElements()) {
            String key = keys.nextElement();
            if (key == null) continue;
            InternalJSONUtil.propertyPut(jsonObject, key, bundle.getString(key), filter);
        }
    }

    /*
     * WARNING - void declaration
     */
    private static void mapFromStr(CharSequence source, JSONObject jsonObject, Filter<MutablePair<String, Object>> filter) {
        void var2_2;
        void var1_1;
        CharSequence charSequence;
        String jsonStr = StrUtil.trim(source);
        if (StrUtil.startWith((CharSequence)jsonStr, '<')) {
            void var3_3;
            XML.toJSONObject(jsonObject, (String)var3_3, false);
            return;
        }
        ObjectMapper.mapFromTokener(new JSONTokener(StrUtil.trim(charSequence), jsonObject.getConfig()), (JSONObject)var1_1, (Filter<MutablePair<String, Object>>)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    private void mapFromStr(CharSequence source, JSONArray jsonArray, Filter<Mutable<Object>> filter) {
        if (source != null) {
            void var3_3;
            void var2_2;
            void var1_1;
            ObjectMapper.mapFromTokener(new JSONTokener(StrUtil.trim((CharSequence)var1_1), jsonArray.getConfig()), (JSONArray)var2_2, (Filter<Mutable<Object>>)var3_3);
        }
    }

    /*
     * WARNING - void declaration
     */
    private static void mapFromTokener(JSONTokener x, JSONObject jsonObject, Filter<MutablePair<String, Object>> filter) {
        void var2_2;
        void var1_1;
        JSONParser.of(x).parseTo((JSONObject)var1_1, (Filter<MutablePair<String, Object>>)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    private static void mapFromTokener(JSONTokener x, JSONArray jsonArray, Filter<Mutable<Object>> filter) {
        void var2_2;
        void var1_1;
        JSONParser.of(x).parseTo((JSONArray)var1_1, (Filter<Mutable<Object>>)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    private static void mapFromBean(Object bean, JSONObject jsonObject) {
        void var1_1;
        void v0 = var1_1;
        BeanUtil.beanToMap(bean, (Map<String, Object>)v0, InternalJSONUtil.toCopyOptions(v0.getConfig()));
    }
}

