/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.json;

import cn.hutool.core.convert.NumberWithFormat;
import cn.hutool.core.io.IORuntimeException;
import cn.hutool.core.io.file.FileReader;
import cn.hutool.core.lang.TypeReference;
import cn.hutool.core.map.MapWrapper;
import cn.hutool.core.util.ArrayUtil;
import cn.hutool.core.util.ClassUtil;
import cn.hutool.core.util.HexUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.json.JSON;
import cn.hutool.json.JSONArray;
import cn.hutool.json.JSONConfig;
import cn.hutool.json.JSONNull;
import cn.hutool.json.JSONObject;
import cn.hutool.json.JSONStrFormatter;
import cn.hutool.json.JSONString;
import cn.hutool.json.XML;
import cn.hutool.json.serialize.GlobalSerializeMapping;
import cn.hutool.json.serialize.JSONArraySerializer;
import cn.hutool.json.serialize.JSONDeserializer;
import cn.hutool.json.serialize.JSONObjectSerializer;
import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Type;
import java.nio.charset.Charset;
import java.sql.SQLException;
import java.time.temporal.TemporalAccessor;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class JSONUtil {
    public static JSONObject createObj() {
        return new JSONObject();
    }

    public static JSONObject createObj(JSONConfig config) {
        JSONConfig jSONConfig;
        return new JSONObject(jSONConfig);
    }

    public static JSONArray createArray() {
        return new JSONArray();
    }

    public static JSONArray createArray(JSONConfig config) {
        JSONConfig jSONConfig;
        return new JSONArray(jSONConfig);
    }

    public static JSONObject parseObj(String jsonStr) {
        String string;
        return new JSONObject(string);
    }

    public static JSONObject parseObj(Object obj) {
        return JSONUtil.parseObj(obj, null);
    }

    /*
     * WARNING - void declaration
     */
    public static JSONObject parseObj(Object obj, JSONConfig config) {
        void var1_1;
        Object object;
        return new JSONObject(object, ObjectUtil.defaultIfNull(var1_1, JSONConfig::create));
    }

    /*
     * WARNING - void declaration
     */
    public static JSONObject parseObj(Object obj, boolean ignoreNullValue) {
        void var1_1;
        Object object;
        return new JSONObject(object, (boolean)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public static JSONObject parseObj(Object obj, boolean ignoreNullValue, boolean isOrder) {
        void var1_1;
        Object object;
        return new JSONObject(object, (boolean)var1_1);
    }

    public static JSONArray parseArray(String jsonStr) {
        String string;
        return new JSONArray(string);
    }

    public static JSONArray parseArray(Object arrayOrCollection) {
        return JSONUtil.parseArray(arrayOrCollection, null);
    }

    /*
     * WARNING - void declaration
     */
    public static JSONArray parseArray(Object arrayOrCollection, JSONConfig config) {
        void var1_1;
        Object object;
        return new JSONArray(object, (JSONConfig)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static JSONArray parseArray(Object arrayOrCollection, boolean ignoreNullValue) {
        void var1_1;
        Object object;
        return new JSONArray(object, (boolean)var1_1);
    }

    public static JSON parse(Object obj) {
        return JSONUtil.parse(obj, null);
    }

    /*
     * WARNING - void declaration
     */
    public static JSON parse(Object obj, JSONConfig config) {
        Object object;
        void var1_1;
        Object jsonStr;
        Object json;
        if (obj == null) {
            return null;
        }
        json = obj instanceof JSON ? (JSON)obj : (json instanceof CharSequence ? (JSONUtil.isTypeJSONArray((String)(jsonStr = StrUtil.trim((CharSequence)json))) ? JSONUtil.parseArray(jsonStr, config) : JSONUtil.parseObj(jsonStr, config)) : (!(json instanceof MapWrapper) && (json instanceof Iterable || json instanceof Iterator || ArrayUtil.isArray(json)) ? JSONUtil.parseArray(json, config) : JSONUtil.parseObj(json, (JSONConfig)var1_1)));
        return object;
    }

    public static JSONObject parseFromXml(String xmlStr) {
        return XML.toJSONObject(xmlStr);
    }

    /*
     * WARNING - void declaration
     */
    public static JSON readJSON(File file, Charset charset) throws IORuntimeException {
        void var1_1;
        return JSONUtil.parse(FileReader.create(file, (Charset)var1_1).readString());
    }

    /*
     * WARNING - void declaration
     */
    public static JSONObject readJSONObject(File file, Charset charset) throws IORuntimeException {
        void var1_1;
        return JSONUtil.parseObj(FileReader.create(file, (Charset)var1_1).readString());
    }

    /*
     * WARNING - void declaration
     */
    public static JSONArray readJSONArray(File file, Charset charset) throws IORuntimeException {
        void var1_1;
        return JSONUtil.parseArray(FileReader.create(file, (Charset)var1_1).readString());
    }

    /*
     * WARNING - void declaration
     */
    public static String toJsonStr(JSON json, int indentFactor) {
        void var1_1;
        JSON jSON;
        if (json == null) {
            return null;
        }
        return jSON.toJSONString((int)var1_1);
    }

    public static String toJsonStr(JSON json) {
        JSON jSON;
        if (json == null) {
            return null;
        }
        return jSON.toJSONString(0);
    }

    /*
     * WARNING - void declaration
     */
    public static void toJsonStr(JSON json, Writer writer) {
        if (json != null) {
            void var1_1;
            JSON jSON;
            jSON.write((Writer)var1_1);
        }
    }

    public static String toJsonPrettyStr(JSON json) {
        JSON jSON;
        if (json == null) {
            return null;
        }
        return jSON.toJSONString(4);
    }

    public static String toJsonStr(Object obj) {
        return JSONUtil.toJsonStr(obj, null);
    }

    /*
     * WARNING - void declaration
     */
    public static String toJsonStr(Object obj, JSONConfig jsonConfig) {
        void var1_1;
        Object object;
        if (obj == null) {
            return null;
        }
        if (obj instanceof CharSequence) {
            return StrUtil.str((CharSequence)obj);
        }
        return JSONUtil.toJsonStr(JSONUtil.parse(object, (JSONConfig)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public static void toJsonStr(Object obj, Writer writer) {
        if (obj != null) {
            void var1_1;
            Object object;
            JSONUtil.toJsonStr(JSONUtil.parse(object), (Writer)var1_1);
        }
    }

    public static String toJsonPrettyStr(Object obj) {
        return JSONUtil.toJsonPrettyStr(JSONUtil.parse(obj));
    }

    public static String toXmlStr(JSON json) {
        return XML.toXml(json);
    }

    /*
     * WARNING - void declaration
     */
    public static <T> T toBean(String jsonString, Class<T> beanClass) {
        void var1_1;
        return JSONUtil.toBean(JSONUtil.parseObj(jsonString), var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static <T> T toBean(String jsonString, JSONConfig config, Class<T> beanClass) {
        void var2_2;
        void var1_1;
        return JSONUtil.toBean(JSONUtil.parseObj((Object)jsonString, (JSONConfig)var1_1), var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public static <T> T toBean(JSONObject json, Class<T> beanClass) {
        void var1_1;
        JSONObject jSONObject;
        if (json == null) {
            return null;
        }
        return jSONObject.toBean(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static <T> T toBean(String jsonString, TypeReference<T> typeReference, boolean ignoreError) {
        void var2_2;
        void var1_1;
        return JSONUtil.toBean(jsonString, var1_1.getType(), (boolean)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public static <T> T toBean(String jsonString, Type beanType, boolean ignoreError) {
        void var1_1;
        JSON jSON;
        void var2_2;
        JSON json = JSONUtil.parse(jsonString, JSONConfig.create().setIgnoreError((boolean)var2_2));
        if (json == null) {
            return null;
        }
        return jSON.toBean((Type)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static <T> T toBean(JSON json, TypeReference<T> typeReference, boolean ignoreError) {
        void var2_2;
        void var1_1;
        return JSONUtil.toBean(json, var1_1.getType(), (boolean)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public static <T> T toBean(JSON json, Type beanType, boolean ignoreError) {
        void var2_2;
        void var1_1;
        JSON jSON;
        if (json == null) {
            return null;
        }
        return jSON.toBean((Type)var1_1, (boolean)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public static <T> List<T> toList(String jsonArray, Class<T> elementType) {
        void var1_1;
        return JSONUtil.toList(JSONUtil.parseArray(jsonArray), var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static <T> List<T> toList(JSONArray jsonArray, Class<T> elementType) {
        void var1_1;
        JSONArray jSONArray;
        if (jsonArray == null) {
            return null;
        }
        return jSONArray.toList(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static Object getByPath(JSON json, String expression) {
        void var1_1;
        return JSONUtil.getByPath(json, (String)var1_1, null);
    }

    /*
     * WARNING - void declaration
     */
    public static <T> T getByPath(JSON json, String expression, T defaultValue) {
        void var1_1;
        JSON jSON;
        if (json == null || StrUtil.isBlank(expression)) {
            return defaultValue;
        }
        if (defaultValue != null) {
            void var2_2;
            void var3_3;
            Class<?> type = defaultValue.getClass();
            return ObjectUtil.defaultIfNull(json.getByPath(expression, var3_3), var2_2);
        }
        return (T)jSON.getByPath((String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static void putByPath(JSON json, String expression, Object value) {
        void var2_2;
        void var1_1;
        json.putByPath((String)var1_1, var2_2);
    }

    public static String quote(String string) {
        return JSONUtil.quote(string, true);
    }

    /*
     * WARNING - void declaration
     */
    public static String quote(String string, boolean isWrap) {
        StringWriter sw = new StringWriter();
        try {
            void var1_1;
            void var2_2;
            String string2;
            return JSONUtil.quote(string2, (Writer)var2_2, (boolean)var1_1).toString();
        }
        catch (IOException iOException) {
            return "";
        }
    }

    /*
     * WARNING - void declaration
     */
    public static Writer quote(String str, Writer writer) throws IOException {
        void var1_1;
        return JSONUtil.quote(str, (Writer)var1_1, true);
    }

    /*
     * WARNING - void declaration
     */
    public static Writer quote(String str, Writer writer, boolean isWrap) throws IOException {
        void var1_1;
        void var2_2;
        if (StrUtil.isEmpty(str)) {
            if (isWrap) {
                writer.write("\"\"");
            }
            return writer;
        }
        int len = str.length();
        if (isWrap) {
            writer.write(34);
        }
        block3: for (int i = 0; i < len; ++i) {
            char c = str.charAt(i);
            switch (c) {
                case '\"': 
                case '\\': {
                    writer.write("\\");
                    writer.write(c);
                    continue block3;
                }
                default: {
                    void var3_5;
                    writer.write(JSONUtil.escape((char)var3_5));
                }
            }
        }
        if (var2_2 != false) {
            writer.write(34);
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public static String escape(String str) {
        void var2_2;
        if (StrUtil.isEmpty(str)) {
            return str;
        }
        int len = str.length();
        StringBuilder builder = new StringBuilder(len);
        for (int i = 0; i < len; ++i) {
            void var3_4;
            char c = str.charAt(i);
            builder.append(JSONUtil.escape((char)var3_4));
        }
        return var2_2.toString();
    }

    /*
     * WARNING - void declaration
     */
    public static Object wrap(Object object, JSONConfig jsonConfig) {
        void var1_1;
        Object object2;
        block13: {
            if (object == null) {
                if (jsonConfig.isIgnoreNullValue()) {
                    return null;
                }
                return JSONNull.NULL;
            }
            if (object instanceof JSON || ObjectUtil.isNull(object) || object instanceof JSONString || object instanceof CharSequence || object instanceof Number || ObjectUtil.isBasicType(object)) {
                if (object instanceof Number && null != jsonConfig.getDateFormat()) {
                    return new NumberWithFormat((Number)object, jsonConfig.getDateFormat());
                }
                return object;
            }
            try {
                if (object instanceof SQLException) {
                    return object.toString();
                }
                if (object instanceof Iterable || ArrayUtil.isArray(object)) {
                    return new JSONArray(object, jsonConfig);
                }
                if (!(object instanceof Map) && !(object instanceof Map.Entry)) break block13;
                return new JSONObject(object, jsonConfig);
            }
            catch (Exception exception) {
                return null;
            }
        }
        if (object instanceof Date || object instanceof Calendar || object instanceof TemporalAccessor) {
            return object;
        }
        if (object instanceof Enum) {
            return object.toString();
        }
        if (object instanceof Class) {
            return ((Class)object).getName();
        }
        if (ClassUtil.isJdkClass(object.getClass())) {
            return object.toString();
        }
        return new JSONObject(object2, (JSONConfig)var1_1);
    }

    public static String formatJsonStr(String jsonStr) {
        return JSONStrFormatter.format(jsonStr);
    }

    @Deprecated
    public static boolean isJson(String str) {
        return JSONUtil.isTypeJSON(str);
    }

    public static boolean isTypeJSON(String str) {
        String string;
        return JSONUtil.isTypeJSONObject(str) || JSONUtil.isTypeJSONArray(string);
    }

    @Deprecated
    public static boolean isJsonObj(String str) {
        return JSONUtil.isTypeJSONObject(str);
    }

    public static boolean isTypeJSONObject(String str) {
        String string;
        if (StrUtil.isBlank(str)) {
            return false;
        }
        return StrUtil.isWrap((CharSequence)StrUtil.trim(string), '{', '}');
    }

    @Deprecated
    public static boolean isJsonArray(String str) {
        return JSONUtil.isTypeJSONArray(str);
    }

    public static boolean isTypeJSONArray(String str) {
        String string;
        if (StrUtil.isBlank(str)) {
            return false;
        }
        return StrUtil.isWrap((CharSequence)StrUtil.trim(string), '[', ']');
    }

    public static boolean isNull(Object obj) {
        Object object;
        return obj == null || object instanceof JSONNull;
    }

    public static JSONObject xmlToJson(String xml) {
        return XML.toJSONObject(xml);
    }

    /*
     * WARNING - void declaration
     */
    public static void putSerializer(Type type, JSONArraySerializer<?> serializer) {
        void var1_1;
        GlobalSerializeMapping.put(type, var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static void putSerializer(Type type, JSONObjectSerializer<?> serializer) {
        void var1_1;
        GlobalSerializeMapping.put(type, var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static void putDeserializer(Type type, JSONDeserializer<?> deserializer) {
        void var1_1;
        GlobalSerializeMapping.put(type, var1_1);
    }

    private static String escape(char c) {
        char c2;
        switch (c) {
            case '\b': {
                return "\\b";
            }
            case '\t': {
                return "\\t";
            }
            case '\n': {
                return "\\n";
            }
            case '\f': {
                return "\\f";
            }
            case '\r': {
                return "\\r";
            }
        }
        if (c < ' ' || c >= '\u0080' && c <= '\u00a0' || c >= '\u2000' && c <= '\u2010' || c >= '\u2028' && c <= '\u202f' || c >= '\u2066' && c <= '\u206f') {
            return HexUtil.toUnicodeHex(c);
        }
        return Character.toString(c2);
    }
}

