/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.json;

import cn.hutool.core.lang.Filter;
import cn.hutool.core.lang.mutable.Mutable;
import cn.hutool.core.lang.mutable.MutablePair;
import cn.hutool.json.JSONArray;
import cn.hutool.json.JSONNull;
import cn.hutool.json.JSONObject;
import cn.hutool.json.JSONTokener;

public class JSONParser {
    private final JSONTokener tokener;

    public static JSONParser of(JSONTokener tokener) {
        JSONTokener jSONTokener;
        return new JSONParser(jSONTokener);
    }

    /*
     * WARNING - void declaration
     */
    public JSONParser(JSONTokener tokener) {
        void var1_1;
        this.tokener = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public void parseTo(JSONObject jsonObject, Filter<MutablePair<String, Object>> filter) {
        void var3_3;
        JSONTokener tokener = this.tokener;
        if (tokener.nextClean() != '{') {
            throw tokener.syntaxError("A JSONObject text must begin with '{'");
        }
        block9: while (true) {
            char prev = tokener.getPrevious();
            char c = tokener.nextClean();
            switch (c) {
                case '\u0000': {
                    throw tokener.syntaxError("A JSONObject text must end with '}'");
                }
                case '}': {
                    return;
                }
                case '[': 
                case '{': {
                    if (prev != '{') break;
                    throw tokener.syntaxError("A JSONObject can not directly nest another JSONObject or JSONArray.");
                }
            }
            tokener.back();
            String key = tokener.nextStringValue();
            c = tokener.nextClean();
            if (c != ':') {
                throw tokener.syntaxError("Expected a ':' after a key");
            }
            jsonObject.set(key, tokener.nextValue(), filter, jsonObject.getConfig().isCheckDuplicate());
            switch (tokener.nextClean()) {
                case ',': 
                case ';': {
                    if (tokener.nextClean() == '}') {
                        return;
                    }
                    tokener.back();
                    continue block9;
                }
                case '}': {
                    return;
                }
            }
            break;
        }
        throw var3_3.syntaxError("Expected a ',' or '}'");
    }

    /*
     * WARNING - void declaration
     */
    public void parseTo(JSONArray jsonArray, Filter<Mutable<Object>> filter) {
        JSONTokener x = this.tokener;
        if (x.nextClean() != '[') {
            throw x.syntaxError("A JSONArray text must start with '['");
        }
        if (x.nextClean() != ']') {
            void var3_3;
            x.back();
            block4: while (true) {
                if (x.nextClean() == ',') {
                    x.back();
                    jsonArray.addRaw(JSONNull.NULL, filter);
                } else {
                    x.back();
                    jsonArray.addRaw(x.nextValue(), filter);
                }
                switch (x.nextClean()) {
                    case ',': {
                        if (x.nextClean() == ']') {
                            return;
                        }
                        x.back();
                        continue block4;
                    }
                    case ']': {
                        return;
                    }
                }
                break;
            }
            throw var3_3.syntaxError("Expected a ',' or ']'");
        }
    }
}

