/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.json;

import cn.hutool.core.bean.BeanPath;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.lang.Filter;
import cn.hutool.core.lang.mutable.MutablePair;
import cn.hutool.core.map.CaseInsensitiveMap;
import cn.hutool.core.map.MapWrapper;
import cn.hutool.core.util.ArrayUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.ReflectUtil;
import cn.hutool.json.InternalJSONUtil;
import cn.hutool.json.JSON;
import cn.hutool.json.JSONArray;
import cn.hutool.json.JSONConfig;
import cn.hutool.json.JSONConverter;
import cn.hutool.json.JSONException;
import cn.hutool.json.JSONGetter;
import cn.hutool.json.JSONUtil;
import cn.hutool.json.ObjectMapper;
import cn.hutool.json.serialize.JSONWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Collection;
import java.util.Map;

public class JSONObject
extends MapWrapper<String, Object>
implements JSON,
JSONGetter<String> {
    private static final long serialVersionUID = -330220388580734346L;
    public static final int DEFAULT_CAPACITY = 16;
    private JSONConfig config;

    public JSONObject() {
        this(16, false);
    }

    /*
     * WARNING - void declaration
     */
    public JSONObject(boolean isOrder) {
        this(16, (boolean)var1_1);
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public JSONObject(int capacity, boolean isOrder) {
        this((int)var1_1, false, (boolean)var2_2);
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public JSONObject(int capacity, boolean isIgnoreCase, boolean isOrder) {
        this((int)var1_1, JSONConfig.create().setIgnoreCase((boolean)var2_2));
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public JSONObject(JSONConfig config) {
        this(16, (JSONConfig)var1_1);
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public JSONObject(int capacity, JSONConfig config) {
        super(InternalJSONUtil.createRawMap((int)var1_1, ObjectUtil.defaultIfNull(config, JSONConfig.create())));
        void var2_2;
        void var1_1;
        this.config = ObjectUtil.defaultIfNull(var2_2, JSONConfig.create());
    }

    /*
     * WARNING - void declaration
     */
    public JSONObject(Object source) {
        void var1_1;
        void v0 = var1_1;
        this((Object)v0, InternalJSONUtil.defaultIgnoreNullValue(v0));
    }

    /*
     * WARNING - void declaration
     */
    public JSONObject(Object source, boolean ignoreNullValue) {
        this((Object)var1_1, JSONConfig.create().setIgnoreNullValue((boolean)var2_2));
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public JSONObject(Object source, boolean ignoreNullValue, boolean isOrder) {
        this(source, JSONConfig.create().setIgnoreCase(var1_1 instanceof CaseInsensitiveMap).setIgnoreNullValue((boolean)var2_2));
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public JSONObject(Object source, JSONConfig config) {
        this((Object)var1_1, (JSONConfig)var2_2, null);
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public JSONObject(Object source, JSONConfig config, Filter<MutablePair<String, Object>> filter) {
        this(16, (JSONConfig)var2_2);
        void var3_3;
        void var1_1;
        void var2_2;
        ObjectMapper.of(var1_1).map(this, (Filter<MutablePair<String, Object>>)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    public JSONObject(Object source, String ... names) {
        this();
        void var2_2;
        if (ArrayUtil.isEmpty(names)) {
            ObjectMapper.of(source).map(this, null);
            return;
        }
        if (source instanceof Map) {
            String[] stringArray = names;
            int n = names.length;
            for (int i = 0; i < n; ++i) {
                String name = stringArray[i];
                Object value = ((Map)source).get(name);
                this.set(name, var2_2, null, this.getConfig().isCheckDuplicate());
            }
            return;
        }
        for (void name : var2_2) {
            try {
                this.putOpt((String)name, ReflectUtil.getFieldValue(source, (String)name));
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public JSONObject(CharSequence source, boolean isOrder) throws JSONException {
        this((Object)var1_1, JSONConfig.create());
        void var1_1;
    }

    @Override
    public JSONConfig getConfig() {
        return this.config;
    }

    /*
     * WARNING - void declaration
     */
    public JSONObject setDateFormat(String format) {
        void var1_1;
        this.config.setDateFormat((String)var1_1);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public JSONArray toJSONArray(Collection<String> names) throws JSONException {
        void var2_2;
        if (CollectionUtil.isEmpty(names)) {
            return null;
        }
        JSONArray ja = new JSONArray(this.config);
        for (String name : names) {
            void var1_1;
            Object value = this.get(name);
            if (value == null) continue;
            ja.set(var1_1);
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Object getObj(String key, Object defaultValue) {
        void var2_2;
        void var1_1;
        return this.getOrDefault(var1_1, var2_2);
    }

    @Override
    public Object getByPath(String expression) {
        return BeanPath.create(expression).get(this);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public <T> T getByPath(String expression, Class<T> resultType) {
        void var1_1;
        return JSONConverter.jsonConvert(resultType, this.getByPath((String)var1_1), this.getConfig());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void putByPath(String expression, Object value) {
        void var2_2;
        BeanPath.create(expression).set(this, var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Deprecated
    public JSONObject put(String key, Object value) throws JSONException {
        void var2_2;
        void var1_1;
        return this.set((String)var1_1, var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public JSONObject set(String key, Object value) throws JSONException {
        void var2_2;
        void var1_1;
        return this.set((String)var1_1, var2_2, null, false);
    }

    /*
     * WARNING - void declaration
     */
    public JSONObject set(String key, Object value, Filter<MutablePair<String, Object>> filter, boolean checkDuplicate) throws JSONException {
        if (key == null) {
            return this;
        }
        if (filter != null) {
            void var3_3;
            MutablePair<String, Object> pair = new MutablePair<String, Object>(key, value);
            if (var3_3.accept(pair)) {
                key = (String)pair.getKey();
                value = pair.getValue();
            } else {
                return this;
            }
        }
        boolean ignoreNullValue = this.config.isIgnoreNullValue();
        if (ObjectUtil.isNull(value) && ignoreNullValue) {
            this.remove(key);
        } else {
            void var2_2;
            void var1_1;
            if (checkDuplicate && this.containsKey(key)) {
                throw new JSONException("Duplicate key \"{}\"", key);
            }
            super.put(var1_1, JSONUtil.wrap(InternalJSONUtil.testValidity(var2_2), this.config));
        }
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public JSONObject putOnce(String key, Object value) throws JSONException {
        void var2_2;
        void var1_1;
        return this.setOnce((String)var1_1, var2_2, null);
    }

    /*
     * WARNING - void declaration
     */
    public JSONObject setOnce(String key, Object value, Filter<MutablePair<String, Object>> filter) throws JSONException {
        void var3_3;
        void var2_2;
        void var1_1;
        return this.set((String)var1_1, var2_2, (Filter<MutablePair<String, Object>>)var3_3, true);
    }

    /*
     * WARNING - void declaration
     */
    public JSONObject putOpt(String key, Object value) throws JSONException {
        if (key != null && value != null) {
            void var2_2;
            void var1_1;
            this.set((String)var1_1, var2_2);
        }
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void putAll(Map<? extends String, ?> m) {
        for (Map.Entry<String, ?> entry : m.entrySet()) {
            void var2_2;
            this.set(entry.getKey(), var2_2.getValue());
        }
    }

    /*
     * WARNING - void declaration
     */
    public JSONObject accumulate(String key, Object value) throws JSONException {
        InternalJSONUtil.testValidity(value);
        Object object = this.getObj(key);
        if (object == null) {
            this.set(key, value);
        } else if (object instanceof JSONArray) {
            ((JSONArray)object).set(value);
        } else {
            void var2_2;
            void var3_3;
            void var1_1;
            this.set((String)var1_1, JSONUtil.createArray(this.config).set(var3_3).set(var2_2));
        }
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public JSONObject append(String key, Object value) throws JSONException {
        InternalJSONUtil.testValidity(value);
        Object object = this.getObj(key);
        if (object == null) {
            this.set(key, new JSONArray(this.config).set(value));
        } else if (object instanceof JSONArray) {
            void var2_2;
            void var3_3;
            this.set(key, ((JSONArray)var3_3).set(var2_2));
        } else {
            void var1_1;
            throw new JSONException("JSONObject [" + (String)var1_1 + "] is not a JSONArray.");
        }
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public JSONObject increment(String key) throws JSONException {
        Object value = this.getObj(key);
        if (value == null) {
            this.set(key, 1);
        } else if (value instanceof BigInteger) {
            this.set(key, ((BigInteger)value).add(BigInteger.ONE));
        } else if (value instanceof BigDecimal) {
            this.set(key, ((BigDecimal)value).add(BigDecimal.ONE));
        } else if (value instanceof Integer) {
            this.set(key, (Integer)value + 1);
        } else if (value instanceof Long) {
            this.set(key, (Long)value + 1L);
        } else if (value instanceof Double) {
            this.set(key, (Double)value + 1.0);
        } else if (value instanceof Float) {
            void var2_2;
            this.set(key, Float.valueOf(((Float)var2_2).floatValue() + 1.0f));
        } else {
            void var1_1;
            throw new JSONException("Unable to increment [" + JSONUtil.quote((String)var1_1) + "].");
        }
        return this;
    }

    @Override
    public String toString() {
        return this.toJSONString(0);
    }

    /*
     * WARNING - void declaration
     */
    public String toJSONString(int indentFactor, Filter<MutablePair<Object, Object>> filter) {
        StringWriter sw = new StringWriter();
        StringBuffer stringBuffer = sw.getBuffer();
        synchronized (stringBuffer) {
            void var2_3;
            void var1_1;
            void var3_4;
            return this.write((Writer)var3_4, (int)var1_1, 0, (Filter<MutablePair<Object, Object>>)var2_3).toString();
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Writer write(Writer writer, int indentFactor, int indent) throws JSONException {
        void var3_3;
        void var2_2;
        void var1_1;
        return this.write((Writer)var1_1, (int)var2_2, (int)var3_3, null);
    }

    /*
     * WARNING - void declaration
     */
    public Writer write(Writer writer, int indentFactor, int indent, Filter<MutablePair<Object, Object>> filter) throws JSONException {
        void var1_1;
        void var2_3;
        void var3_4;
        JSONWriter jsonWriter = JSONWriter.of(writer, indentFactor, (int)var3_4, this.config).beginObj();
        this.forEach((? super K key, ? super V value) -> {
            void var1_1;
            void var3_3;
            void var2_2;
            jsonWriter.writeField(new MutablePair<void, void>(var2_2, var3_3), (Filter<MutablePair<Object, Object>>)var1_1);
        });
        var2_3.end();
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public JSONObject clone() throws CloneNotSupportedException {
        void var1_1;
        JSONObject clone = (JSONObject)super.clone();
        ((JSONObject)super.clone()).config = this.config;
        return var1_1;
    }
}

