/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.json;

import cn.hutool.core.convert.Convert;
import cn.hutool.core.convert.ConvertException;
import cn.hutool.core.convert.NumberWithFormat;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.date.LocalDateTimeUtil;
import cn.hutool.core.getter.OptNullBasicTypeFromObjectGetter;
import cn.hutool.core.util.StrUtil;
import cn.hutool.json.JSON;
import cn.hutool.json.JSONArray;
import cn.hutool.json.JSONConfig;
import cn.hutool.json.JSONConverter;
import cn.hutool.json.JSONObject;
import cn.hutool.json.JSONUtil;
import java.lang.reflect.Type;
import java.time.LocalDateTime;
import java.util.Date;
import java.util.List;
import java.util.Optional;

public interface JSONGetter<K>
extends OptNullBasicTypeFromObjectGetter<K> {
    public JSONConfig getConfig();

    /*
     * WARNING - void declaration
     */
    default public boolean isNull(K key) {
        void var1_1;
        return JSONUtil.isNull(this.getObj(var1_1));
    }

    /*
     * WARNING - void declaration
     */
    default public String getStrEscaped(K key) {
        void var1_1;
        return this.getStrEscaped(var1_1, null);
    }

    /*
     * WARNING - void declaration
     */
    default public String getStrEscaped(K key, String defaultValue) {
        void var2_2;
        void var1_1;
        return JSONUtil.escape(this.getStr(var1_1, (String)var2_2));
    }

    /*
     * WARNING - void declaration
     */
    default public JSONArray getJSONArray(K key) {
        void var1_1;
        Object object = this.getObj(key);
        if (JSONUtil.isNull(object)) {
            return null;
        }
        if (object instanceof JSON) {
            return (JSONArray)object;
        }
        return new JSONArray((Object)var1_1, this.getConfig());
    }

    /*
     * WARNING - void declaration
     */
    default public JSONObject getJSONObject(K key) {
        void var1_1;
        Object object = this.getObj(key);
        if (JSONUtil.isNull(object)) {
            return null;
        }
        if (object instanceof JSON) {
            return (JSONObject)object;
        }
        return new JSONObject((Object)var1_1, this.getConfig());
    }

    /*
     * WARNING - void declaration
     */
    default public <T> T getBean(K key, Class<T> beanType) {
        void var2_2;
        void var1_1;
        JSONObject obj = this.getJSONObject(key);
        if (obj == null) {
            return null;
        }
        return var1_1.toBean(var2_2);
    }

    /*
     * WARNING - void declaration
     */
    default public <T> List<T> getBeanList(K key, Class<T> beanType) {
        void var2_2;
        void var1_1;
        JSONArray jsonArray = this.getJSONArray(key);
        if (jsonArray == null) {
            return null;
        }
        return var1_1.toList(var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    default public Date getDate(K key, Date defaultValue) {
        void var2_2;
        void var1_1;
        String format;
        Object obj = this.getObj(key);
        if (JSONUtil.isNull(obj)) {
            return defaultValue;
        }
        if (obj instanceof Date) {
            return (Date)obj;
        }
        if (obj instanceof NumberWithFormat) {
            return (Date)((NumberWithFormat)obj).convert((Type)((Object)Date.class), obj);
        }
        Optional<String> formatOps = Optional.ofNullable(this.getConfig()).map(JSONConfig::getDateFormat);
        if (formatOps.isPresent() && StrUtil.isNotBlank(format = formatOps.get())) {
            void var3_3;
            String str = Convert.toStr(obj);
            if (str == null) {
                return defaultValue;
            }
            return DateUtil.parse((CharSequence)var1_1, (String)var3_3);
        }
        return Convert.toDate(var1_1, (Date)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    default public LocalDateTime getLocalDateTime(K key, LocalDateTime defaultValue) {
        void var2_2;
        void var1_1;
        String format;
        Object obj = this.getObj(key);
        if (JSONUtil.isNull(obj)) {
            return defaultValue;
        }
        if (obj instanceof LocalDateTime) {
            return (LocalDateTime)obj;
        }
        Optional<String> formatOps = Optional.ofNullable(this.getConfig()).map(JSONConfig::getDateFormat);
        if (formatOps.isPresent() && StrUtil.isNotBlank(format = formatOps.get())) {
            void var3_3;
            String str = Convert.toStr(obj);
            if (str == null) {
                return defaultValue;
            }
            return LocalDateTimeUtil.parse((CharSequence)var1_1, (String)var3_3);
        }
        return Convert.toLocalDateTime(var1_1, (LocalDateTime)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    default public byte[] getBytes(K key) {
        void var1_1;
        return this.get(var1_1, byte[].class);
    }

    /*
     * WARNING - void declaration
     */
    default public <T> T get(K key, Class<T> type) throws ConvertException {
        void var2_2;
        void var1_1;
        return this.get(var1_1, (Class<T>)var2_2, false);
    }

    /*
     * WARNING - void declaration
     */
    default public <T> T get(K key, Class<T> type, boolean ignoreError) throws ConvertException {
        void var3_3;
        void var1_1;
        void var2_2;
        Object value = this.getObj(key);
        if (JSONUtil.isNull(value)) {
            return null;
        }
        return JSONConverter.jsonConvert((Type)var2_2, var1_1, JSONConfig.create().setIgnoreError((boolean)var3_3));
    }
}

