/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.json;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.codec.Base64;
import cn.hutool.core.convert.Convert;
import cn.hutool.core.convert.ConvertException;
import cn.hutool.core.convert.Converter;
import cn.hutool.core.convert.ConverterRegistry;
import cn.hutool.core.convert.impl.ArrayConverter;
import cn.hutool.core.convert.impl.BeanConverter;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.ReflectUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.core.util.TypeUtil;
import cn.hutool.json.InternalJSONUtil;
import cn.hutool.json.JSON;
import cn.hutool.json.JSONArray;
import cn.hutool.json.JSONBeanParser;
import cn.hutool.json.JSONConfig;
import cn.hutool.json.JSONGetter;
import cn.hutool.json.JSONObject;
import cn.hutool.json.JSONUtil;
import cn.hutool.json.serialize.GlobalSerializeMapping;
import cn.hutool.json.serialize.JSONDeserializer;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;

public class JSONConverter
implements Converter<JSON> {
    /*
     * WARNING - void declaration
     */
    protected static Object toArray(JSONArray jsonArray, Class<?> arrayClass) {
        JSONArray jSONArray;
        void var1_1;
        return new ArrayConverter((Class<?>)var1_1).convert(jSONArray, null);
    }

    protected static <T> List<T> toList(JSONArray jsonArray, Class<T> elementType) {
        JSONArray jSONArray;
        return Convert.toList(elementType, jSONArray);
    }

    /*
     * WARNING - void declaration
     */
    protected static <T> T jsonConvert(Type targetType, Object value, JSONConfig jsonConfig) throws ConvertException {
        void var1_1;
        Type type;
        void var2_2;
        if (JSONUtil.isNull(value)) {
            return null;
        }
        if (targetType instanceof Class) {
            Class clazz = (Class)targetType;
            if (JSONBeanParser.class.isAssignableFrom(clazz)) {
                void var3_3;
                JSONBeanParser target = (JSONBeanParser)ReflectUtil.newInstanceIfPossible(var3_3);
                if (target == null) {
                    throw new ConvertException("Can not instance [{}]", targetType);
                }
                target.parse(value);
                return var2_2;
            }
            if (targetType == byte[].class && value instanceof CharSequence) {
                return (T)Base64.decode((CharSequence)value);
            }
        }
        return JSONConverter.jsonToBean(type, var1_1, var2_2.isIgnoreError());
    }

    /*
     * WARNING - void declaration
     */
    protected static <T> T jsonToBean(Type targetType, Object value, boolean ignoreError) throws ConvertException {
        void var3_3;
        void var2_2;
        Object targetValue;
        if (JSONUtil.isNull(value)) {
            return null;
        }
        if (value instanceof JSON) {
            JSONDeserializer<?> deserializer = GlobalSerializeMapping.getDeserializer((Type)targetType);
            if (deserializer != null) {
                return (T)deserializer.deserialize((JSON)value);
            }
            if (value instanceof JSONGetter && targetType instanceof Class && !Map.Entry.class.isAssignableFrom((Class)targetType) && BeanUtil.hasSetter((Class)targetType)) {
                JSONConfig config = ((JSONGetter)value).getConfig();
                targetType = new BeanConverter<Object>((Type)targetType, InternalJSONUtil.toCopyOptions(config).setIgnoreError(ignoreError));
                return targetType.convertWithCheck(value, null, ignoreError);
            }
        }
        if ((targetValue = Convert.convertWithCheck((Type)targetType, value, null, ignoreError)) == null && var2_2 == false) {
            Type type;
            void var1_1;
            if (StrUtil.isBlankIfStr(value)) {
                return null;
            }
            throw new ConvertException("Can not convert {} to type {}", var1_1, ObjectUtil.defaultIfNull(TypeUtil.getClass((Type)targetType), type));
        }
        return var3_3;
    }

    @Override
    public JSON convert(Object value, JSON defaultValue) throws IllegalArgumentException {
        return JSONUtil.parse(value);
    }

    /*
     * WARNING - void declaration
     */
    static {
        void var0;
        ConverterRegistry registry = ConverterRegistry.getInstance();
        registry.putCustom((Type)((Object)JSON.class), (Class<? extends Converter<?>>)JSONConverter.class);
        registry.putCustom((Type)((Object)JSONObject.class), (Class<? extends Converter<?>>)JSONConverter.class);
        var0.putCustom((Type)((Object)JSONArray.class), (Class<? extends Converter<?>>)JSONConverter.class);
    }
}

