/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.json;

import cn.hutool.core.bean.BeanPath;
import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.lang.Filter;
import cn.hutool.core.lang.Validator;
import cn.hutool.core.lang.mutable.Mutable;
import cn.hutool.core.lang.mutable.MutableObj;
import cn.hutool.core.lang.mutable.MutablePair;
import cn.hutool.core.text.StrJoiner;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.json.InternalJSONUtil;
import cn.hutool.json.JSON;
import cn.hutool.json.JSONConfig;
import cn.hutool.json.JSONConverter;
import cn.hutool.json.JSONException;
import cn.hutool.json.JSONGetter;
import cn.hutool.json.JSONNull;
import cn.hutool.json.JSONObject;
import cn.hutool.json.JSONObjectIter;
import cn.hutool.json.JSONUtil;
import cn.hutool.json.ObjectMapper;
import cn.hutool.json.serialize.JSONWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.RandomAccess;

public class JSONArray
implements JSON,
JSONGetter<Integer>,
List<Object>,
RandomAccess {
    private static final long serialVersionUID = 2664900568717612292L;
    public static final int DEFAULT_CAPACITY = 10;
    private List<Object> rawList;
    private final JSONConfig config;

    public JSONArray() {
        this(10);
    }

    /*
     * WARNING - void declaration
     */
    public JSONArray(int initialCapacity) {
        this((int)var1_1, JSONConfig.create());
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public JSONArray(JSONConfig config) {
        this(10, (JSONConfig)var1_1);
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public JSONArray(int initialCapacity, JSONConfig config) {
        void var2_2;
        void var1_1;
        this.rawList = new ArrayList<Object>((int)var1_1);
        this.config = ObjectUtil.defaultIfNull(var2_2, JSONConfig::create);
    }

    /*
     * WARNING - void declaration
     */
    public JSONArray(Object object) throws JSONException {
        this((Object)var1_1, true);
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public JSONArray(Object object, boolean ignoreNullValue) throws JSONException {
        this((Object)var1_1, JSONConfig.create().setIgnoreNullValue((boolean)var2_2));
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public JSONArray(Object object, JSONConfig jsonConfig) throws JSONException {
        this(var1_1, (JSONConfig)var2_2, null);
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public JSONArray(Object object, JSONConfig jsonConfig, Filter<Mutable<Object>> filter) throws JSONException {
        this(10, (JSONConfig)var2_2);
        void var3_3;
        void var1_1;
        void var2_2;
        ObjectMapper.of(var1_1).map(this, (Filter<Mutable<Object>>)var3_3);
    }

    @Override
    public JSONConfig getConfig() {
        return this.config;
    }

    /*
     * WARNING - void declaration
     */
    public JSONArray setDateFormat(String format) {
        void var1_1;
        this.config.setDateFormat((String)var1_1);
        return this;
    }

    public String join(String separator) throws JSONException {
        return StrJoiner.of(separator).append(this, InternalJSONUtil::valueToString).toString();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Object get(int index) {
        void var1_1;
        return this.rawList.get((int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Object getObj(Integer index, Object defaultValue) {
        void var1_1;
        if (index < 0 || index >= this.size()) {
            void var2_2;
            return var2_2;
        }
        return this.rawList.get(var1_1.intValue());
    }

    @Override
    public Object getByPath(String expression) {
        return BeanPath.create(expression).get(this);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public <T> T getByPath(String expression, Class<T> resultType) {
        void var1_1;
        return JSONConverter.jsonConvert(resultType, this.getByPath((String)var1_1), this.getConfig());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void putByPath(String expression, Object value) {
        void var2_2;
        BeanPath.create(expression).set(this, var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public JSONArray put(Object value) {
        void var1_1;
        return this.set(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public JSONArray set(Object value) {
        void var1_1;
        this.add((Object)var1_1);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public JSONArray put(int index, Object value) throws JSONException {
        void var2_2;
        void var1_1;
        this.set((int)var1_1, (Object)var2_2);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public JSONObject toJSONObject(JSONArray names) throws JSONException {
        void var2_2;
        if (names == null || names.size() == 0 || this.size() == 0) {
            return null;
        }
        JSONObject jo = new JSONObject(this.config);
        for (int i = 0; i < names.size(); ++i) {
            jo.set(names.getStr(i), this.getObj(i));
        }
        return var2_2;
    }

    @Override
    public int hashCode() {
        int n = 31 + (this.rawList == null ? 0 : this.rawList.hashCode());
        return n;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean equals(Object obj) {
        void var1_1;
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        JSONArray other = (JSONArray)obj;
        if (this.rawList == null) {
            return other.rawList == null;
        }
        return this.rawList.equals(var1_1.rawList);
    }

    @Override
    public Iterator<Object> iterator() {
        return this.rawList.iterator();
    }

    public Iterable<JSONObject> jsonIter() {
        return new JSONObjectIter(this.iterator());
    }

    @Override
    public int size() {
        return this.rawList.size();
    }

    @Override
    public boolean isEmpty() {
        return this.rawList.isEmpty();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean contains(Object o) {
        void var1_1;
        return this.rawList.contains(var1_1);
    }

    @Override
    public Object[] toArray() {
        return this.rawList.toArray();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public <T> T[] toArray(T[] a) {
        void var1_1;
        return (Object[])JSONConverter.toArray(this, var1_1.getClass().getComponentType());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean add(Object e) {
        void var1_1;
        return this.addRaw(JSONUtil.wrap(var1_1, this.config), null);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Object remove(int index) {
        if (index >= 0 && index < this.size()) {
            void var1_1;
            return this.rawList.remove((int)var1_1);
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean remove(Object o) {
        void var1_1;
        return this.rawList.remove(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean containsAll(Collection<?> c) {
        void var1_1;
        return this.rawList.containsAll((Collection<?>)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean addAll(Collection<?> c) {
        Iterator iterator;
        if (CollUtil.isEmpty(c)) {
            return false;
        }
        iterator = iterator.iterator();
        while (iterator.hasNext()) {
            void var2_2;
            Object obj = iterator.next();
            this.add((Object)var2_2);
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean addAll(int index, Collection<?> c) {
        void var3_3;
        void var1_1;
        Iterator iterator;
        if (CollUtil.isEmpty(c)) {
            return false;
        }
        ArrayList<Object> list = new ArrayList<Object>(c.size());
        iterator = iterator.iterator();
        while (iterator.hasNext()) {
            Object object = iterator.next();
            list.add(JSONUtil.wrap(object, this.config));
        }
        return this.rawList.addAll((int)var1_1, (Collection<Object>)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean removeAll(Collection<?> c) {
        void var1_1;
        return this.rawList.removeAll((Collection<?>)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean retainAll(Collection<?> c) {
        void var1_1;
        return this.rawList.retainAll((Collection<?>)var1_1);
    }

    @Override
    public void clear() {
        this.rawList.clear();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Object set(int index, Object element) {
        void var2_2;
        void var1_1;
        return this.set((int)var1_1, var2_2, null);
    }

    /*
     * WARNING - void declaration
     */
    public Object set(int index, Object element, Filter<MutablePair<Integer, Object>> filter) {
        void var2_2;
        void var1_1;
        MutablePair<Integer, Object> pair;
        void var3_3;
        if (filter != null && var3_3.accept(pair = new MutablePair<Integer, Object>(index, element))) {
            element = pair.getValue();
        }
        if (index >= this.size()) {
            this.add(index, element);
        }
        return this.rawList.set((int)var1_1, JSONUtil.wrap(var2_2, this.config));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void add(int index, Object element) {
        void var2_2;
        if (index < 0) {
            throw new JSONException("JSONArray[{}] not found.", index);
        }
        if (index < this.size()) {
            InternalJSONUtil.testValidity(element);
            this.rawList.add(index, JSONUtil.wrap(element, this.config));
            return;
        }
        Validator.checkIndexLimit(index, this.size());
        while (index != this.size()) {
            this.add(JSONNull.NULL);
        }
        this.set(var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int indexOf(Object o) {
        void var1_1;
        return this.rawList.indexOf(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int lastIndexOf(Object o) {
        void var1_1;
        return this.rawList.lastIndexOf(var1_1);
    }

    @Override
    public ListIterator<Object> listIterator() {
        return this.rawList.listIterator();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ListIterator<Object> listIterator(int index) {
        void var1_1;
        return this.rawList.listIterator((int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public List<Object> subList(int fromIndex, int toIndex) {
        void var2_2;
        void var1_1;
        return this.rawList.subList((int)var1_1, (int)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public Object toArray(Class<?> arrayClass) {
        void var1_1;
        return JSONConverter.toArray(this, var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public <T> List<T> toList(Class<T> elementType) {
        void var1_1;
        return JSONConverter.toList(this, var1_1);
    }

    public String toString() {
        return this.toJSONString(0);
    }

    /*
     * WARNING - void declaration
     */
    public String toJSONString(int indentFactor, Filter<MutablePair<Object, Object>> filter) {
        StringWriter sw = new StringWriter();
        StringBuffer stringBuffer = sw.getBuffer();
        synchronized (stringBuffer) {
            void var2_3;
            void var1_1;
            void var3_4;
            return this.write((Writer)var3_4, (int)var1_1, 0, (Filter<MutablePair<Object, Object>>)var2_3).toString();
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Writer write(Writer writer, int indentFactor, int indent) throws JSONException {
        void var3_3;
        void var2_2;
        void var1_1;
        return this.write((Writer)var1_1, (int)var2_2, (int)var3_3, null);
    }

    /*
     * WARNING - void declaration
     */
    public Writer write(Writer writer, int indentFactor, int indent, Filter<MutablePair<Object, Object>> filter) throws JSONException {
        void var1_1;
        void var2_3;
        void var3_4;
        JSONWriter jsonWriter = JSONWriter.of(writer, indentFactor, (int)var3_4, this.config).beginArray();
        CollUtil.forEach(this, (value, index) -> {
            void var1_1;
            void var2_2;
            void var3_3;
            jsonWriter.writeField(new MutablePair<Integer, void>((int)var3_3, var2_2), (Filter<MutablePair<Object, Object>>)var1_1);
        });
        var2_3.end();
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public Object clone() throws CloneNotSupportedException {
        void var1_1;
        JSONArray clone = (JSONArray)super.clone();
        ((JSONArray)super.clone()).rawList = ObjectUtil.clone(this.rawList);
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    protected boolean addRaw(Object obj, Filter<Mutable<Object>> filter) {
        Object t;
        if (filter != null) {
            void var2_2;
            MutableObj<Object> mutable = new MutableObj<Object>(obj);
            if (var2_2.accept(mutable)) {
                t = t.get();
            } else {
                return false;
            }
        }
        return this.rawList.add(t);
    }
}

