/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.json;

import cn.hutool.core.bean.copier.CopyOptions;
import cn.hutool.core.convert.Convert;
import cn.hutool.core.lang.Filter;
import cn.hutool.core.lang.mutable.MutablePair;
import cn.hutool.core.map.CaseInsensitiveLinkedMap;
import cn.hutool.core.map.CaseInsensitiveTreeMap;
import cn.hutool.core.map.MapWrapper;
import cn.hutool.core.util.ArrayUtil;
import cn.hutool.core.util.NumberUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.json.JSONArray;
import cn.hutool.json.JSONConfig;
import cn.hutool.json.JSONException;
import cn.hutool.json.JSONNull;
import cn.hutool.json.JSONObject;
import cn.hutool.json.JSONString;
import cn.hutool.json.JSONTokener;
import cn.hutool.json.JSONUtil;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.TreeMap;

public final class InternalJSONUtil {
    private InternalJSONUtil() {
    }

    static Object testValidity(Object obj) throws JSONException {
        Object object;
        if (!ObjectUtil.isValidIfNumber(obj)) {
            throw new JSONException("JSON does not allow non-finite numbers.");
        }
        return object;
    }

    static String valueToString(Object value) throws JSONException {
        Object object;
        Object map;
        Object e2;
        if (value == null || value instanceof JSONNull) {
            return JSONNull.NULL.toString();
        }
        if (value instanceof JSONString) {
            try {
                return ((JSONString)value).toJSONString();
            }
            catch (Exception e2) {
                throw new JSONException(e2);
            }
        }
        if (e2 instanceof Number) {
            return NumberUtil.toStr((Number)e2);
        }
        if (e2 instanceof Boolean || e2 instanceof JSONObject || e2 instanceof JSONArray) {
            return e2.toString();
        }
        if (e2 instanceof Map) {
            map = (Map)e2;
            return ((MapWrapper)new JSONObject(map)).toString();
        }
        if (map instanceof Collection) {
            Object coll = (Collection)map;
            return new JSONArray(object).toString();
        }
        if (ArrayUtil.isArray(object)) {
            return new JSONArray(object).toString();
        }
        return JSONUtil.quote(object.toString());
    }

    /*
     * WARNING - void declaration
     */
    public static Object stringToValue(String string) {
        String string2;
        void var1_1;
        if (StrUtil.isEmpty(string) || "null".equalsIgnoreCase(string)) {
            return JSONNull.NULL;
        }
        if ("true".equalsIgnoreCase(string)) {
            return Boolean.TRUE;
        }
        if ("false".equalsIgnoreCase(string)) {
            return Boolean.FALSE;
        }
        char b = string.charAt(0);
        if (b >= '0' && b <= '9' || var1_1 == 45) {
            try {
                if (StrUtil.containsAnyIgnoreCase(string, ".", "e")) {
                    return new BigDecimal(string);
                }
                long myLong = Long.parseLong(string);
                if (string.equals(Long.toString(myLong))) {
                    void var2_2;
                    long l = myLong;
                    if (l == (long)((int)l)) {
                        return (int)myLong;
                    }
                    return (long)var2_2;
                }
            }
            catch (Exception exception) {}
        }
        return string2;
    }

    /*
     * WARNING - void declaration
     */
    static JSONObject propertyPut(JSONObject jsonObject, Object key, Object value, Filter<MutablePair<String, Object>> filter) {
        JSONObject jSONObject;
        void var3_3;
        void var2_2;
        void var1_1;
        String[] path = StrUtil.splitToArray((CharSequence)Convert.toStr(key), '.');
        int last = path.length - 1;
        JSONObject target = jsonObject;
        for (int i = 0; i < last; ++i) {
            String segment = path[i];
            JSONObject nextTarget = target.getJSONObject(segment);
            if (nextTarget == null) {
                nextTarget = new JSONObject(target.getConfig());
                target.set(segment, nextTarget, filter, target.getConfig().isCheckDuplicate());
            }
            target = nextTarget;
        }
        target.set((String)var1_1[last], var2_2, (Filter<MutablePair<String, Object>>)var3_3, target.getConfig().isCheckDuplicate());
        return jSONObject;
    }

    static boolean defaultIgnoreNullValue(Object obj) {
        Object object;
        return false == obj instanceof CharSequence && false == obj instanceof JSONTokener && false == object instanceof Map;
    }

    static CopyOptions toCopyOptions(JSONConfig config) {
        JSONConfig jSONConfig;
        return CopyOptions.create().setIgnoreCase(config.isIgnoreCase()).setIgnoreError(config.isIgnoreError()).setIgnoreNullValue(config.isIgnoreNullValue()).setTransientSupport(jSONConfig.isTransientSupport());
    }

    /*
     * WARNING - void declaration
     */
    static Map<String, Object> createRawMap(int capacity, JSONConfig config) {
        void var0_1;
        void var2_3;
        int rawHashMap22;
        void var1_2;
        if (config == null) {
            config = JSONConfig.create();
        }
        Comparator<String> keyComparator = config.getKeyComparator();
        Map rawHashMap22 = var1_2.isIgnoreCase() ? (keyComparator != null ? new CaseInsensitiveTreeMap(keyComparator) : new CaseInsensitiveLinkedMap(rawHashMap22)) : (keyComparator != null ? new TreeMap(var2_3) : new LinkedHashMap(rawHashMap22));
        return var0_1;
    }
}

