/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.http.webservice;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.io.IoUtil;
import cn.hutool.core.map.MapUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.core.util.XmlUtil;
import cn.hutool.http.HttpBase;
import cn.hutool.http.HttpGlobalConfig;
import cn.hutool.http.HttpRequest;
import cn.hutool.http.HttpResponse;
import cn.hutool.http.webservice.SoapProtocol;
import cn.hutool.http.webservice.SoapRuntimeException;
import cn.hutool.http.webservice.SoapUtil;
import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.soap.MessageFactory;
import javax.xml.soap.MimeHeaders;
import javax.xml.soap.Name;
import javax.xml.soap.SOAPBodyElement;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPHeaderElement;
import javax.xml.soap.SOAPMessage;

public class SoapClient
extends HttpBase<SoapClient> {
    private static final String CONTENT_TYPE_SOAP11_TEXT_XML = "text/xml;charset=";
    private static final String CONTENT_TYPE_SOAP12_SOAP_XML = "application/soap+xml;charset=";
    private String url;
    private int connectionTimeout = HttpGlobalConfig.getTimeout();
    private int readTimeout = HttpGlobalConfig.getTimeout();
    private MessageFactory factory;
    private SOAPMessage message;
    private SOAPBodyElement methodEle;
    private final String namespaceURI;
    private final SoapProtocol protocol;

    public static SoapClient create(String url) {
        String string;
        return new SoapClient(string);
    }

    /*
     * WARNING - void declaration
     */
    public static SoapClient create(String url, SoapProtocol protocol) {
        void var1_1;
        String string;
        return new SoapClient(string, (SoapProtocol)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static SoapClient create(String url, SoapProtocol protocol, String namespaceURI) {
        void var2_2;
        void var1_1;
        String string;
        return new SoapClient(string, (SoapProtocol)var1_1, (String)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public SoapClient(String url) {
        this((String)var1_1, SoapProtocol.SOAP_1_1);
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public SoapClient(String url, SoapProtocol protocol) {
        this((String)var1_1, (SoapProtocol)var2_2, null);
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public SoapClient(String url, SoapProtocol protocol, String namespaceURI) {
        void var2_2;
        void var3_3;
        void var1_1;
        this.url = var1_1;
        this.namespaceURI = var3_3;
        this.protocol = protocol;
        this.init((SoapProtocol)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public SoapClient init(SoapProtocol protocol) {
        try {
            this.factory = MessageFactory.newInstance((String)protocol.getValue());
            this.message = this.factory.createMessage();
        }
        catch (SOAPException e) {
            void var1_2;
            throw new SoapRuntimeException((Throwable)var1_2);
        }
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public SoapClient reset() {
        try {
            this.message = this.factory.createMessage();
        }
        catch (SOAPException e) {
            void var1_1;
            throw new SoapRuntimeException((Throwable)var1_1);
        }
        this.methodEle = null;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public SoapClient setCharset(Charset charset) {
        void var1_1;
        return this.charset((Charset)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public SoapClient charset(Charset charset) {
        void var1_1;
        super.charset((Charset)var1_1);
        try {
            this.message.setProperty("javax.xml.soap.character-set-encoding", (Object)this.charset());
            this.message.setProperty("javax.xml.soap.write-xml-declaration", (Object)"true");
        }
        catch (SOAPException sOAPException) {}
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public SoapClient setUrl(String url) {
        void var1_1;
        this.url = var1_1;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public SOAPHeaderElement addSOAPHeader(QName name, String actorURI, String roleUri, Boolean mustUnderstand, Boolean relay) {
        void var1_1;
        SOAPHeaderElement ele = this.addSOAPHeader(name);
        try {
            if (StrUtil.isNotBlank(roleUri)) {
                void var3_4;
                ele.setRole((String)var3_4);
            }
            if (relay != null) {
                ele.setRelay(relay.booleanValue());
            }
        }
        catch (SOAPException e) {
            void var1_2;
            throw new SoapRuntimeException((Throwable)var1_2);
        }
        if (StrUtil.isNotBlank(actorURI)) {
            void var2_3;
            var1_1.setActor((String)var2_3);
        }
        if (mustUnderstand != null) {
            var1_1.setMustUnderstand(mustUnderstand.booleanValue());
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public SOAPHeaderElement addSOAPHeader(String localName) {
        void var1_1;
        return this.addSOAPHeader(new QName((String)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public SOAPHeaderElement addSOAPHeader(String localName, String value) {
        void var1_1;
        void var2_2;
        SOAPHeaderElement soapHeaderElement = this.addSOAPHeader(localName);
        soapHeaderElement.setTextContent((String)var2_2);
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public SOAPHeaderElement addSOAPHeader(QName name) {
        void var1_1;
        try {
            SOAPHeaderElement ele = this.message.getSOAPHeader().addHeaderElement(name);
        }
        catch (SOAPException e) {
            throw new SoapRuntimeException(e);
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public SoapClient setMethod(Name name, Map<String, Object> params, boolean useMethodPrefix) {
        void var3_3;
        void var2_2;
        void var1_1;
        return this.setMethod(new QName(name.getURI(), name.getLocalName(), var1_1.getPrefix()), (Map<String, Object>)var2_2, (boolean)var3_3);
    }

    public SoapClient setMethod(QName name, Map<String, Object> params, boolean useMethodPrefix) {
        Iterator iterator;
        this.setMethod(name);
        String prefix = useMethodPrefix ? name.getPrefix() : null;
        SOAPBodyElement methodEle = this.methodEle;
        for (Map.Entry entry : MapUtil.wrap(iterator)) {
            SoapClient.setParam((SOAPElement)methodEle, (String)entry.getKey(), entry.getValue(), prefix);
        }
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public SoapClient setMethod(String methodName) {
        void var1_1;
        return this.setMethod((String)var1_1, ObjectUtil.defaultIfNull(this.namespaceURI, ""));
    }

    /*
     * WARNING - void declaration
     */
    public SoapClient setMethod(String methodName, String namespaceURI) {
        void var1_1;
        QName qName;
        void var2_2;
        void var3_3;
        List<String> methodNameList = StrUtil.split((CharSequence)methodName, ':');
        qName = 2 == methodNameList.size() ? new QName(namespaceURI, methodNameList.get(1), (String)var3_3.get(0)) : new QName((String)var2_2, (String)((Object)qName));
        return this.setMethod((QName)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public SoapClient setMethod(QName name) {
        try {
            this.methodEle = this.message.getSOAPBody().addBodyElement(name);
        }
        catch (SOAPException e) {
            void var1_2;
            throw new SoapRuntimeException((Throwable)var1_2);
        }
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public SoapClient setParam(String name, Object value) {
        void var2_2;
        void var1_1;
        return this.setParam((String)var1_1, var2_2, true);
    }

    /*
     * WARNING - void declaration
     */
    public SoapClient setParam(String name, Object value, boolean useMethodPrefix) {
        void var3_3;
        void var2_2;
        void var1_1;
        SoapClient.setParam((SOAPElement)this.methodEle, (String)var1_1, var2_2, var3_3 != false ? this.methodEle.getPrefix() : null);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public SoapClient setParams(Map<String, Object> params) {
        void var1_1;
        return this.setParams((Map<String, Object>)var1_1, true);
    }

    public SoapClient setParams(Map<String, Object> params, boolean useMethodPrefix) {
        for (Map.Entry<String, Object> entry : MapUtil.wrap(params)) {
            this.setParam(entry.getKey(), entry.getValue(), useMethodPrefix);
        }
        return this;
    }

    public SOAPBodyElement getMethodEle() {
        return this.methodEle;
    }

    public SOAPMessage getMessage() {
        return this.message;
    }

    /*
     * WARNING - void declaration
     */
    public String getMsgStr(boolean pretty) {
        void var1_1;
        return SoapUtil.toString(this.message, (boolean)var1_1, this.charset);
    }

    /*
     * WARNING - void declaration
     */
    public SoapClient write(OutputStream out) {
        try {
            this.message.writeTo(out);
        }
        catch (IOException | SOAPException e) {
            void var1_2;
            throw new SoapRuntimeException((Throwable)var1_2);
        }
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public SoapClient timeout(int milliseconds) {
        void var1_1;
        this.setConnectionTimeout(milliseconds);
        this.setReadTimeout((int)var1_1);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public SoapClient setConnectionTimeout(int milliseconds) {
        void var1_1;
        this.connectionTimeout = var1_1;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public SoapClient setReadTimeout(int milliseconds) {
        void var1_1;
        this.readTimeout = var1_1;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public SOAPMessage sendForMessage() {
        SOAPMessage sOAPMessage;
        HttpResponse res = this.sendForResponse();
        MimeHeaders headers = new MimeHeaders();
        for (Map.Entry<String, List<String>> entry : res.headers().entrySet()) {
            if (!StrUtil.isNotEmpty(entry.getKey())) continue;
            headers.setHeader(entry.getKey(), (String)CollUtil.get((Collection)entry.getValue(), 0));
        }
        try {
            void var2_2;
            sOAPMessage = this.factory.createMessage((MimeHeaders)var2_2, res.bodyStream());
        }
        catch (IOException | SOAPException e) {
            try {
                void var3_5;
                throw new SoapRuntimeException((Throwable)var3_5);
            }
            catch (Throwable throwable) {
                void var1_1;
                IoUtil.close((Closeable)var1_1);
                throw throwable;
            }
        }
        IoUtil.close(res);
        return sOAPMessage;
    }

    public String send() {
        return this.send(false);
    }

    /*
     * WARNING - void declaration
     */
    public String send(boolean pretty) {
        void var2_2;
        void var1_1;
        String body = this.sendForResponse().body();
        if (var1_1 != false) {
            return XmlUtil.format(body);
        }
        return var2_2;
    }

    public HttpResponse sendForResponse() {
        return ((HttpRequest)HttpRequest.post(this.url).setFollowRedirects(true).setConnectionTimeout(this.connectionTimeout).setReadTimeout(this.readTimeout).contentType(this.getXmlContentType()).header(this.headers())).body(this.getMsgStr(false)).executeAsync();
    }

    private String getXmlContentType() {
        switch (this.protocol) {
            case SOAP_1_1: {
                return CONTENT_TYPE_SOAP11_TEXT_XML.concat(this.charset.toString());
            }
            case SOAP_1_2: {
                return CONTENT_TYPE_SOAP12_SOAP_XML.concat(this.charset.toString());
            }
        }
        throw new SoapRuntimeException("Unsupported protocol: {}", new Object[]{this.protocol});
    }

    /*
     * WARNING - void declaration
     */
    private static SOAPElement setParam(SOAPElement ele, String name, Object value, String prefix) {
        void var1_3;
        SOAPElement childEle;
        try {
            childEle = StrUtil.isNotBlank(prefix) ? ele.addChildElement(name, prefix) : ele.addChildElement((String)childEle);
        }
        catch (SOAPException e) {
            throw new SoapRuntimeException(e);
        }
        if (value != null) {
            if (value instanceof SOAPElement) {
                try {
                    e.addChildElement((SOAPElement)value);
                }
                catch (SOAPException e) {
                    throw new SoapRuntimeException(e);
                }
            } else if (value instanceof Map) {
                value = ((Map)((Object)value)).entrySet().iterator();
                while (value.hasNext()) {
                    Object object;
                    Object entry = e = value.next();
                    SoapClient.setParam(childEle, entry.getKey().toString(), object.getValue(), prefix);
                }
            } else {
                void var2_4;
                childEle.setValue(var2_4.toString());
            }
        }
        return var1_3;
    }
}

