/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.http.server;

import cn.hutool.core.io.IORuntimeException;
import cn.hutool.core.lang.Console;
import cn.hutool.core.thread.GlobalThreadPool;
import cn.hutool.core.util.StrUtil;
import cn.hutool.http.server.HttpExchangeWrapper;
import cn.hutool.http.server.action.Action;
import cn.hutool.http.server.action.RootAction;
import cn.hutool.http.server.filter.HttpFilter;
import cn.hutool.http.server.filter.SimpleFilter;
import cn.hutool.http.server.handler.ActionHandler;
import com.sun.net.httpserver.Filter;
import com.sun.net.httpserver.HttpContext;
import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpHandler;
import com.sun.net.httpserver.HttpServer;
import com.sun.net.httpserver.HttpsConfigurator;
import com.sun.net.httpserver.HttpsServer;
import java.io.File;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executor;

public class SimpleServer {
    private final HttpServer server;
    private final List<Filter> filters;

    /*
     * WARNING - void declaration
     */
    public SimpleServer(int port) {
        this(new InetSocketAddress((int)var1_1));
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public SimpleServer(String hostname, int port) {
        this(new InetSocketAddress((String)var1_1, (int)var2_2));
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public SimpleServer(InetSocketAddress address) {
        this((InetSocketAddress)var1_1, null);
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public SimpleServer(InetSocketAddress address, HttpsConfigurator configurator) {
        try {
            HttpsServer server;
            if (configurator != null) {
                void var2_3;
                server = HttpsServer.create(address, 0);
                server.setHttpsConfigurator((HttpsConfigurator)var2_3);
                this.server = server;
            } else {
                this.server = HttpServer.create((InetSocketAddress)((Object)server), 0);
            }
        }
        catch (IOException e) {
            void var1_2;
            throw new IORuntimeException((Throwable)var1_2);
        }
        this.setExecutor(GlobalThreadPool.getExecutor());
        this.filters = new ArrayList<Filter>();
    }

    /*
     * WARNING - void declaration
     */
    public SimpleServer addFilter(Filter filter) {
        void var1_1;
        this.filters.add((Filter)var1_1);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public SimpleServer addFilter(HttpFilter filter) {
        void var1_1;
        return this.addFilter(new SimpleFilter(this, (HttpFilter)var1_1){
            final /* synthetic */ HttpFilter val$filter;
            final /* synthetic */ SimpleServer this$0;
            {
                void var1_1;
                this.this$0 = var1_1;
                this.val$filter = httpFilter;
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public void doFilter(HttpExchange httpExchange, Filter.Chain chain) throws IOException {
                void var2_2;
                void var1_1;
                HttpExchangeWrapper httpExchangeWrapper = new HttpExchangeWrapper(httpExchange);
                this.val$filter.doFilter(httpExchangeWrapper.getRequest(), var1_1.getResponse(), (Filter.Chain)var2_2);
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    public SimpleServer addHandler(String path, HttpHandler handler) {
        void var2_2;
        void var1_1;
        this.createContext((String)var1_1, (HttpHandler)var2_2);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public HttpContext createContext(String path, HttpHandler handler) {
        void var1_1;
        void var2_2;
        path = StrUtil.addPrefixIfNot(path, "/");
        HttpContext context = this.server.createContext(path, (HttpHandler)var2_2);
        context.getFilters().addAll(this.filters);
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public SimpleServer setRoot(String root) {
        void var1_1;
        return this.setRoot(new File((String)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public SimpleServer setRoot(File root) {
        void var1_1;
        return this.addAction("/", new RootAction((File)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public SimpleServer addAction(String path, Action action) {
        void var2_2;
        void var1_1;
        return this.addHandler((String)var1_1, new ActionHandler((Action)var2_2));
    }

    /*
     * WARNING - void declaration
     */
    public SimpleServer setExecutor(Executor executor) {
        void var1_1;
        this.server.setExecutor((Executor)var1_1);
        return this;
    }

    public HttpServer getRawServer() {
        return this.server;
    }

    public InetSocketAddress getAddress() {
        return this.server.getAddress();
    }

    /*
     * WARNING - void declaration
     */
    public void start() {
        void var1_1;
        InetSocketAddress address = this.getAddress();
        Console.log("Hutool Simple Http Server listen on \u3010{}:{}\u3011", address.getHostName(), var1_1.getPort());
        this.server.start();
    }
}

