/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.http.server;

import cn.hutool.core.io.FileUtil;
import cn.hutool.core.io.IORuntimeException;
import cn.hutool.core.io.IoUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.core.util.URLUtil;
import cn.hutool.http.ContentType;
import cn.hutool.http.Header;
import cn.hutool.http.HttpUtil;
import cn.hutool.http.server.HttpServerBase;
import com.sun.net.httpserver.Headers;
import com.sun.net.httpserver.HttpExchange;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Map;

public class HttpServerResponse
extends HttpServerBase {
    private Charset charset;
    private boolean isSendCode;

    /*
     * WARNING - void declaration
     */
    public HttpServerResponse(HttpExchange httpExchange) {
        super((HttpExchange)var1_1);
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public HttpServerResponse send(int httpStatusCode) {
        void var1_1;
        return this.send((int)var1_1, 0L);
    }

    public HttpServerResponse sendOk() {
        return this.send(200);
    }

    /*
     * WARNING - void declaration
     */
    public HttpServerResponse sendOk(int bodyLength) {
        void var1_1;
        return this.send(200, (long)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public HttpServerResponse send404(String content) {
        void var1_1;
        return this.sendError(404, (String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public HttpServerResponse sendError(int errorCode, String content) {
        void var2_2;
        void var1_1;
        this.send((int)var1_1);
        this.setContentType(ContentType.TEXT_HTML.toString());
        return this.write((String)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public HttpServerResponse send(int httpStatusCode, long bodyLength) {
        if (this.isSendCode) {
            throw new IORuntimeException("Http status code has been send!");
        }
        try {
            void var2_3;
            this.httpExchange.sendResponseHeaders(httpStatusCode, (long)var2_3);
        }
        catch (IOException e) {
            void var1_2;
            throw new IORuntimeException((Throwable)var1_2);
        }
        this.isSendCode = true;
        return this;
    }

    public Headers getHeaders() {
        return this.httpExchange.getResponseHeaders();
    }

    /*
     * WARNING - void declaration
     */
    public HttpServerResponse addHeader(String header, String value) {
        void var2_2;
        void var1_1;
        this.getHeaders().add((String)var1_1, (String)var2_2);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public HttpServerResponse setHeader(Header header, String value) {
        void var2_2;
        void var1_1;
        return this.setHeader(var1_1.getValue(), (String)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public HttpServerResponse setHeader(String header, String value) {
        void var2_2;
        void var1_1;
        this.getHeaders().set((String)var1_1, (String)var2_2);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public HttpServerResponse setHeader(String header, List<String> value) {
        void var2_2;
        void var1_1;
        this.getHeaders().put((String)var1_1, (List<String>)var2_2);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public HttpServerResponse setHeaders(Map<String, List<String>> headers) {
        void var1_1;
        this.getHeaders().putAll((Map<? extends String, ? extends List<String>>)var1_1);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public HttpServerResponse setContentType(String contentType) {
        void var1_1;
        if (contentType != null && this.charset != null && !contentType.contains(";charset=")) {
            contentType = ContentType.build(contentType, this.charset);
        }
        return this.setHeader(Header.CONTENT_TYPE, (String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public HttpServerResponse setContentLength(long contentLength) {
        void var1_1;
        return this.setHeader(Header.CONTENT_LENGTH, String.valueOf((long)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public HttpServerResponse setCharset(Charset charset) {
        void var1_1;
        this.charset = var1_1;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public HttpServerResponse setAttr(String name, Object value) {
        void var2_2;
        void var1_1;
        this.httpExchange.setAttribute((String)var1_1, var2_2);
        return this;
    }

    public OutputStream getOut() {
        if (!this.isSendCode) {
            this.sendOk();
        }
        return this.httpExchange.getResponseBody();
    }

    /*
     * WARNING - void declaration
     */
    public PrintWriter getWriter() {
        void var1_1;
        Charset charset = ObjectUtil.defaultIfNull(this.charset, DEFAULT_CHARSET);
        return new PrintWriter(new OutputStreamWriter(this.getOut(), (Charset)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public HttpServerResponse write(String data, String contentType) {
        void var1_1;
        void var2_2;
        this.setContentType((String)var2_2);
        return this.write((String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public HttpServerResponse write(String data) {
        void var2_2;
        void var1_1;
        Charset charset = ObjectUtil.defaultIfNull(this.charset, DEFAULT_CHARSET);
        return this.write(StrUtil.bytes((CharSequence)var1_1, (Charset)var2_2));
    }

    /*
     * WARNING - void declaration
     */
    public HttpServerResponse write(byte[] data, String contentType) {
        void var1_1;
        void var2_2;
        this.setContentType((String)var2_2);
        return this.write((byte[])var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public HttpServerResponse write(byte[] data) {
        void var1_1;
        ByteArrayInputStream in = new ByteArrayInputStream(data);
        void v0 = var1_1;
        return this.write((InputStream)v0, v0.available());
    }

    /*
     * WARNING - void declaration
     */
    public HttpServerResponse write(InputStream in, String contentType) {
        void var2_2;
        void var1_1;
        return this.write((InputStream)var1_1, 0, (String)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public HttpServerResponse write(InputStream in, int length, String contentType) {
        void var2_2;
        void var1_1;
        void var3_3;
        this.setContentType((String)var3_3);
        return this.write((InputStream)var1_1, (int)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public HttpServerResponse write(InputStream in) {
        void var1_1;
        return this.write((InputStream)var1_1, 0);
    }

    /*
     * WARNING - void declaration
     */
    public HttpServerResponse write(InputStream in, int length) {
        if (!this.isSendCode) {
            this.sendOk(Math.max(0, length));
        }
        OutputStream out = null;
        try {
            out = this.httpExchange.getResponseBody();
            IoUtil.copy(in, out);
        }
        catch (Throwable throwable) {
            void var1_1;
            void var2_3;
            IoUtil.close((Closeable)var2_3);
            IoUtil.close((Closeable)var1_1);
            throw throwable;
        }
        IoUtil.close(out);
        IoUtil.close(in);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public HttpServerResponse write(File file) {
        void var1_1;
        return this.write((File)var1_1, null);
    }

    /*
     * WARNING - void declaration
     */
    public HttpServerResponse write(File file, String fileName) {
        long fileSize = file.length();
        if (fileSize > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("File size is too bigger than 2147483647");
        }
        if (StrUtil.isBlank(fileName)) {
            fileName = file.getName();
        }
        String contentType = ObjectUtil.defaultIfNull(HttpUtil.getMimeType(fileName), "application/octet-stream");
        BufferedInputStream in = null;
        try {
            void var2_3;
            void var3_4;
            void var1_1;
            in = FileUtil.getInputStream((File)var1_1);
            this.write(in, (int)var3_4, contentType, (String)var2_3);
        }
        finally {
            IoUtil.close(in);
        }
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public void write(InputStream in, String contentType, String fileName) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.write((InputStream)var1_1, 0, (String)var2_2, (String)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    public HttpServerResponse write(InputStream in, int length, String contentType, String fileName) {
        void var3_3;
        void var2_2;
        void var1_1;
        Charset charset = ObjectUtil.defaultIfNull(this.charset, DEFAULT_CHARSET);
        if (!contentType.startsWith("text/")) {
            this.setHeader(Header.CONTENT_DISPOSITION, StrUtil.format("attachment;filename={}", URLUtil.encode(fileName, charset)));
        }
        return this.write((InputStream)var1_1, (int)var2_2, (String)var3_3);
    }
}

