/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.http.server;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.io.IORuntimeException;
import cn.hutool.core.io.IoUtil;
import cn.hutool.core.io.LimitedInputStream;
import cn.hutool.core.map.CaseInsensitiveMap;
import cn.hutool.core.map.multi.ListValueMap;
import cn.hutool.core.net.NetUtil;
import cn.hutool.core.net.multipart.MultipartFormData;
import cn.hutool.core.net.multipart.UploadSetting;
import cn.hutool.core.util.ArrayUtil;
import cn.hutool.core.util.CharsetUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.http.Header;
import cn.hutool.http.HttpUtil;
import cn.hutool.http.Method;
import cn.hutool.http.server.HttpServerBase;
import cn.hutool.http.useragent.UserAgent;
import cn.hutool.http.useragent.UserAgentUtil;
import com.sun.net.httpserver.Headers;
import com.sun.net.httpserver.HttpExchange;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpCookie;
import java.net.URI;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class HttpServerRequest
extends HttpServerBase {
    private Map<String, HttpCookie> cookieCache;
    private ListValueMap<String, String> paramsCache;
    private MultipartFormData multipartFormDataCache;
    private Charset charsetCache;
    private byte[] bodyCache;

    /*
     * WARNING - void declaration
     */
    public HttpServerRequest(HttpExchange httpExchange) {
        super((HttpExchange)var1_1);
        void var1_1;
    }

    public String getMethod() {
        return this.httpExchange.getRequestMethod();
    }

    public boolean isGetMethod() {
        return Method.GET.name().equalsIgnoreCase(this.getMethod());
    }

    public boolean isPostMethod() {
        return Method.POST.name().equalsIgnoreCase(this.getMethod());
    }

    public URI getURI() {
        return this.httpExchange.getRequestURI();
    }

    public String getPath() {
        return this.getURI().getPath();
    }

    public String getQuery() {
        return this.getURI().getQuery();
    }

    public Headers getHeaders() {
        return this.httpExchange.getRequestHeaders();
    }

    /*
     * WARNING - void declaration
     */
    public String getHeader(Header headerKey) {
        void var1_1;
        return this.getHeader(var1_1.toString());
    }

    /*
     * WARNING - void declaration
     */
    public String getHeader(String headerKey) {
        void var1_1;
        return this.getHeaders().getFirst((String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public String getHeader(String headerKey, Charset charset) {
        String header = this.getHeader(headerKey);
        if (header != null) {
            void var2_2;
            void var1_1;
            return CharsetUtil.convert((String)var1_1, CharsetUtil.CHARSET_ISO_8859_1, (Charset)var2_2);
        }
        return null;
    }

    public String getContentType() {
        return this.getHeader(Header.CONTENT_TYPE);
    }

    public Charset getCharset() {
        if (this.charsetCache == null) {
            String string = this.getContentType();
            String charsetStr = HttpUtil.getCharset(string);
            this.charsetCache = CharsetUtil.parse(string, DEFAULT_CHARSET);
        }
        return this.charsetCache;
    }

    public String getUserAgentStr() {
        return this.getHeader(Header.USER_AGENT);
    }

    public UserAgent getUserAgent() {
        return UserAgentUtil.parse(this.getUserAgentStr());
    }

    public String getCookiesStr() {
        return this.getHeader(Header.COOKIE);
    }

    public Collection<HttpCookie> getCookies() {
        return this.getCookieMap().values();
    }

    public Map<String, HttpCookie> getCookieMap() {
        if (this.cookieCache == null) {
            this.cookieCache = Collections.unmodifiableMap(CollUtil.toMap(NetUtil.parseCookies(this.getCookiesStr()), new CaseInsensitiveMap(), HttpCookie::getName));
        }
        return this.cookieCache;
    }

    /*
     * WARNING - void declaration
     */
    public HttpCookie getCookie(String cookieName) {
        void var1_1;
        return this.getCookieMap().get(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public boolean isMultipart() {
        void var1_1;
        if (!this.isPostMethod()) {
            return false;
        }
        String contentType = this.getContentType();
        if (StrUtil.isBlank(contentType)) {
            return false;
        }
        return var1_1.toLowerCase().startsWith("multipart/");
    }

    public String getBody() {
        HttpServerRequest httpServerRequest = this;
        return httpServerRequest.getBody(httpServerRequest.getCharset());
    }

    /*
     * WARNING - void declaration
     */
    public String getBody(Charset charset) {
        void var1_1;
        return StrUtil.str(this.getBodyBytes(), (Charset)var1_1);
    }

    public byte[] getBodyBytes() {
        if (this.bodyCache == null) {
            this.bodyCache = IoUtil.readBytes(this.getBodyStream(), true);
        }
        return this.bodyCache;
    }

    /*
     * WARNING - void declaration
     */
    public InputStream getBodyStream() {
        void var1_1;
        InputStream bodyStream = this.httpExchange.getRequestBody();
        String contentLengthStr = this.getHeader(Header.CONTENT_LENGTH);
        long contentLength = 0L;
        if (StrUtil.isNotBlank(contentLengthStr)) {
            try {
                void var2_2;
                contentLength = Long.parseLong((String)var2_2);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        if (contentLength > 0L) {
            void var3_3;
            bodyStream = new LimitedInputStream(bodyStream, (long)var3_3);
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public String getParam(String name) {
        void var1_1;
        return (String)this.getParams().get((String)var1_1, 0);
    }

    /*
     * WARNING - void declaration
     */
    public List<String> getParams(String name) {
        void var1_1;
        return (List)this.getParams().get(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public ListValueMap<String, String> getParams() {
        if (this.paramsCache == null) {
            this.paramsCache = new ListValueMap();
            Charset charset = this.getCharset();
            String query = this.getQuery();
            if (StrUtil.isNotBlank(query)) {
                this.paramsCache.putAll(HttpUtil.decodeParams(query, charset, false));
            }
            if (this.isMultipart()) {
                this.paramsCache.putAll(this.getMultipart().getParamListMap());
            } else {
                String body = this.getBody();
                if (StrUtil.isNotBlank(body)) {
                    void var1_1;
                    void var2_2;
                    this.paramsCache.putAll(HttpUtil.decodeParams((String)var2_2, (Charset)var1_1, true));
                }
            }
        }
        return this.paramsCache;
    }

    /*
     * WARNING - void declaration
     */
    public String getClientIP(String ... otherHeaderNames) {
        void var2_2;
        String[] headers = new String[]{"X-Forwarded-For", "X-Real-IP", "Proxy-Client-IP", "WL-Proxy-Client-IP", "HTTP_CLIENT_IP", "HTTP_X_FORWARDED_FOR"};
        if (ArrayUtil.isNotEmpty(otherHeaderNames)) {
            void var1_1;
            headers = ArrayUtil.addAll(new String[][]{headers, var1_1});
        }
        return this.getClientIPByHeader((String[])var2_2);
    }

    public String getClientIPByHeader(String ... headerNames) {
        String string;
        String[] stringArray = headerNames;
        int n = headerNames.length;
        for (int i = 0; i < n; ++i) {
            String header = stringArray[i];
            String ip = this.getHeader(header);
            if (NetUtil.isUnknown(ip)) continue;
            return NetUtil.getMultistageReverseProxyIp(string);
        }
        string = this.httpExchange.getRemoteAddress().getHostName();
        return NetUtil.getMultistageReverseProxyIp(string);
    }

    public MultipartFormData getMultipart() throws IORuntimeException {
        if (this.multipartFormDataCache == null) {
            this.multipartFormDataCache = this.parseMultipart(new UploadSetting());
        }
        return this.multipartFormDataCache;
    }

    /*
     * WARNING - void declaration
     */
    public MultipartFormData parseMultipart(UploadSetting uploadSetting) throws IORuntimeException {
        void var1_1;
        MultipartFormData formData = new MultipartFormData(uploadSetting);
        try {
            formData.parseRequestStream(this.getBodyStream(), this.getCharset());
        }
        catch (IOException e) {
            void var1_2;
            throw new IORuntimeException((Throwable)var1_2);
        }
        return var1_1;
    }
}

