/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.http.cookie;

import cn.hutool.core.io.IORuntimeException;
import cn.hutool.core.util.URLUtil;
import cn.hutool.http.HttpConnection;
import cn.hutool.http.cookie.ThreadLocalCookieStore;
import java.io.IOException;
import java.net.CookieManager;
import java.net.CookiePolicy;
import java.net.HttpCookie;
import java.net.URI;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class GlobalCookieManager {
    private static CookieManager cookieManager = new CookieManager(new ThreadLocalCookieStore(), CookiePolicy.ACCEPT_ALL);

    public static void setCookieManager(CookieManager customCookieManager) {
        cookieManager = customCookieManager;
    }

    public static CookieManager getCookieManager() {
        return cookieManager;
    }

    public static List<HttpCookie> getCookies(HttpConnection conn) {
        HttpConnection httpConnection;
        return cookieManager.getCookieStore().get(GlobalCookieManager.getURI(httpConnection));
    }

    /*
     * WARNING - void declaration
     */
    public static void add(HttpConnection conn) {
        void var1_2;
        HttpConnection httpConnection;
        if (cookieManager == null) {
            return;
        }
        try {
            Map<String, List<String>> cookieHeader = cookieManager.get(GlobalCookieManager.getURI(conn), new HashMap<String, List<String>>(0));
        }
        catch (IOException e) {
            void var0_1;
            throw new IORuntimeException((Throwable)var0_1);
        }
        httpConnection.header((Map<String, List<String>>)var1_2, false);
    }

    /*
     * WARNING - void declaration
     */
    public static void store(HttpConnection conn) {
        if (cookieManager == null) {
            return;
        }
        try {
            cookieManager.put(GlobalCookieManager.getURI(conn), conn.headers());
            return;
        }
        catch (IOException e) {
            void var0_1;
            throw new IORuntimeException((Throwable)var0_1);
        }
    }

    private static URI getURI(HttpConnection conn) {
        return URLUtil.toURI(conn.getUrl());
    }
}

