/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.http;

import cn.hutool.core.convert.Convert;
import cn.hutool.core.io.IORuntimeException;
import cn.hutool.core.io.IoUtil;
import cn.hutool.core.io.resource.MultiResource;
import cn.hutool.core.io.resource.Resource;
import cn.hutool.core.io.resource.StringResource;
import cn.hutool.core.util.StrUtil;
import cn.hutool.http.ContentType;
import cn.hutool.http.HttpGlobalConfig;
import cn.hutool.http.HttpResource;
import cn.hutool.http.HttpUtil;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;

public class MultipartOutputStream
extends OutputStream {
    private static final String CONTENT_DISPOSITION_TEMPLATE = "Content-Disposition: form-data; name=\"{}\"\r\n";
    private static final String CONTENT_DISPOSITION_FILE_TEMPLATE = "Content-Disposition: form-data; name=\"{}\"; filename=\"{}\"\r\n";
    private static final String CONTENT_TYPE_FILE_TEMPLATE = "Content-Type: {}\r\n";
    private final OutputStream out;
    private final Charset charset;
    private final String boundary;
    private boolean isFinish;

    /*
     * WARNING - void declaration
     */
    public MultipartOutputStream(OutputStream out, Charset charset) {
        this((OutputStream)var1_1, (Charset)var2_2, HttpGlobalConfig.getBoundary());
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public MultipartOutputStream(OutputStream out, Charset charset, String boundary) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.out = var1_1;
        this.charset = var2_2;
        this.boundary = var3_3;
    }

    /*
     * WARNING - void declaration
     */
    public MultipartOutputStream write(String formFieldName, Object value) throws IORuntimeException {
        if (value instanceof MultiResource) {
            for (Resource subResource : (MultiResource)value) {
                void var3_3;
                this.write(formFieldName, (Object)var3_3);
            }
            return this;
        }
        this.beginPart();
        if (value instanceof Resource) {
            this.appendResource(formFieldName, (Resource)((Object)value));
        } else {
            void var2_2;
            void var1_1;
            this.appendResource((String)var1_1, new StringResource(Convert.toStr(var2_2), null, this.charset));
        }
        this.write("\r\n");
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void write(int b) throws IOException {
        void var1_1;
        this.out.write((int)var1_1);
    }

    public void finish() throws IORuntimeException {
        if (!this.isFinish) {
            this.write(StrUtil.format("--{}--\r\n", this.boundary));
            this.isFinish = true;
        }
    }

    @Override
    public void close() {
        this.finish();
        IoUtil.close(this.out);
    }

    /*
     * WARNING - void declaration
     */
    private void appendResource(String formFieldName, Resource resource) throws IORuntimeException {
        void var2_2;
        String fileName = resource.getName();
        if (fileName == null) {
            this.write(StrUtil.format(CONTENT_DISPOSITION_TEMPLATE, formFieldName));
        } else {
            this.write(StrUtil.format(CONTENT_DISPOSITION_FILE_TEMPLATE, formFieldName, fileName));
        }
        if (resource instanceof HttpResource) {
            String contentType = ((HttpResource)resource).getContentType();
            if (StrUtil.isNotBlank(contentType)) {
                void var1_1;
                this.write(StrUtil.format(CONTENT_TYPE_FILE_TEMPLATE, var1_1));
            }
        } else if (StrUtil.isNotEmpty(fileName)) {
            void var3_3;
            this.write(StrUtil.format(CONTENT_TYPE_FILE_TEMPLATE, HttpUtil.getMimeType((String)var3_3, ContentType.OCTET_STREAM.getValue())));
        }
        this.write("\r\n");
        var2_2.writeTo(this);
    }

    private void beginPart() {
        this.write("--", this.boundary, "\r\n");
    }

    /*
     * WARNING - void declaration
     */
    private void write(Object ... objs) {
        void var1_1;
        MultipartOutputStream multipartOutputStream = this;
        IoUtil.write((OutputStream)multipartOutputStream, multipartOutputStream.charset, false, (Object[])var1_1);
    }
}

