/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.http;

import cn.hutool.core.codec.Base64;
import cn.hutool.core.convert.Convert;
import cn.hutool.core.io.FileUtil;
import cn.hutool.core.io.IoUtil;
import cn.hutool.core.io.StreamProgress;
import cn.hutool.core.map.MapUtil;
import cn.hutool.core.net.RFC3986;
import cn.hutool.core.net.url.UrlQuery;
import cn.hutool.core.text.StrBuilder;
import cn.hutool.core.util.CharsetUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.ReUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.core.util.URLUtil;
import cn.hutool.http.ContentType;
import cn.hutool.http.HttpDownloader;
import cn.hutool.http.HttpGlobalConfig;
import cn.hutool.http.HttpRequest;
import cn.hutool.http.Method;
import cn.hutool.http.cookie.GlobalCookieManager;
import cn.hutool.http.server.SimpleServer;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;

public class HttpUtil {
    public static final Pattern CHARSET_PATTERN = Pattern.compile("charset\\s*=\\s*([a-z0-9-]*)", 2);
    public static final Pattern META_CHARSET_PATTERN = Pattern.compile("<meta[^>]*?charset\\s*=\\s*['\"]?([a-z0-9-]*)", 2);

    public static boolean isHttps(String url) {
        return StrUtil.startWithIgnoreCase(url, "https:");
    }

    public static boolean isHttp(String url) {
        return StrUtil.startWithIgnoreCase(url, "http:");
    }

    public static HttpRequest createRequest(Method method, String url) {
        Method method2;
        return HttpRequest.of(url).method(method2);
    }

    public static HttpRequest createGet(String url) {
        return HttpUtil.createGet(url, false);
    }

    /*
     * WARNING - void declaration
     */
    public static HttpRequest createGet(String url, boolean isFollowRedirects) {
        void var1_1;
        return HttpRequest.get(url).setFollowRedirects((boolean)var1_1);
    }

    public static HttpRequest createPost(String url) {
        return HttpRequest.post(url);
    }

    /*
     * WARNING - void declaration
     */
    public static String get(String urlString, Charset customCharset) {
        void var1_1;
        return ((HttpRequest)HttpRequest.get(urlString).charset((Charset)var1_1)).execute().body();
    }

    public static String get(String urlString) {
        return HttpUtil.get(urlString, HttpGlobalConfig.getTimeout());
    }

    /*
     * WARNING - void declaration
     */
    public static String get(String urlString, int timeout) {
        void var1_1;
        return HttpRequest.get(urlString).timeout((int)var1_1).execute().body();
    }

    /*
     * WARNING - void declaration
     */
    public static String get(String urlString, Map<String, Object> paramMap) {
        void var1_1;
        return HttpRequest.get(urlString).form((Map<String, Object>)var1_1).execute().body();
    }

    /*
     * WARNING - void declaration
     */
    public static String get(String urlString, Map<String, Object> paramMap, int timeout) {
        void var2_2;
        void var1_1;
        return HttpRequest.get(urlString).form((Map<String, Object>)var1_1).timeout((int)var2_2).execute().body();
    }

    /*
     * WARNING - void declaration
     */
    public static String post(String urlString, Map<String, Object> paramMap) {
        void var1_1;
        return HttpUtil.post(urlString, (Map<String, Object>)var1_1, HttpGlobalConfig.getTimeout());
    }

    /*
     * WARNING - void declaration
     */
    public static String post(String urlString, Map<String, Object> paramMap, int timeout) {
        void var2_2;
        void var1_1;
        return HttpRequest.post(urlString).form((Map<String, Object>)var1_1).timeout((int)var2_2).execute().body();
    }

    /*
     * WARNING - void declaration
     */
    public static String post(String urlString, String body) {
        void var1_1;
        return HttpUtil.post(urlString, (String)var1_1, HttpGlobalConfig.getTimeout());
    }

    /*
     * WARNING - void declaration
     */
    public static String post(String urlString, String body, int timeout) {
        void var1_1;
        void var2_2;
        return HttpRequest.post(urlString).timeout((int)var2_2).body((String)var1_1).execute().body();
    }

    /*
     * WARNING - void declaration
     */
    public static String downloadString(String url, String customCharsetName) {
        void var1_1;
        return HttpUtil.downloadString(url, CharsetUtil.charset((String)var1_1), null);
    }

    /*
     * WARNING - void declaration
     */
    public static String downloadString(String url, Charset customCharset) {
        void var1_1;
        return HttpUtil.downloadString(url, (Charset)var1_1, null);
    }

    /*
     * WARNING - void declaration
     */
    public static String downloadString(String url, Charset customCharset, StreamProgress streamPress) {
        void var2_2;
        void var1_1;
        return HttpDownloader.downloadString(url, (Charset)var1_1, (StreamProgress)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public static long downloadFile(String url, String dest) {
        void var1_1;
        return HttpUtil.downloadFile(url, FileUtil.file((String)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public static long downloadFile(String url, File destFile) {
        void var1_1;
        return HttpUtil.downloadFile(url, (File)var1_1, null);
    }

    /*
     * WARNING - void declaration
     */
    public static long downloadFile(String url, File destFile, int timeout) {
        void var2_2;
        void var1_1;
        return HttpUtil.downloadFile(url, (File)var1_1, (int)var2_2, null);
    }

    /*
     * WARNING - void declaration
     */
    public static long downloadFile(String url, File destFile, StreamProgress streamProgress) {
        void var2_2;
        void var1_1;
        return HttpUtil.downloadFile(url, (File)var1_1, -1, (StreamProgress)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public static long downloadFile(String url, File destFile, int timeout, StreamProgress streamProgress) {
        void var3_3;
        void var2_2;
        void var1_1;
        return HttpDownloader.downloadFile(url, (File)var1_1, (int)var2_2, (StreamProgress)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    public static File downloadFileFromUrl(String url, String dest) {
        void var1_1;
        return HttpUtil.downloadFileFromUrl(url, FileUtil.file((String)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public static File downloadFileFromUrl(String url, File destFile) {
        void var1_1;
        return HttpUtil.downloadFileFromUrl(url, (File)var1_1, null);
    }

    /*
     * WARNING - void declaration
     */
    public static File downloadFileFromUrl(String url, File destFile, int timeout) {
        void var2_2;
        void var1_1;
        return HttpUtil.downloadFileFromUrl(url, (File)var1_1, (int)var2_2, null);
    }

    /*
     * WARNING - void declaration
     */
    public static File downloadFileFromUrl(String url, File destFile, StreamProgress streamProgress) {
        void var2_2;
        void var1_1;
        return HttpUtil.downloadFileFromUrl(url, (File)var1_1, -1, (StreamProgress)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public static File downloadFileFromUrl(String url, File destFile, int timeout, StreamProgress streamProgress) {
        void var3_3;
        void var2_2;
        void var1_1;
        return HttpDownloader.downloadForFile(url, (File)var1_1, (int)var2_2, (StreamProgress)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    public static long download(String url, OutputStream out, boolean isCloseOut) {
        void var2_2;
        void var1_1;
        return HttpUtil.download(url, (OutputStream)var1_1, (boolean)var2_2, null);
    }

    /*
     * WARNING - void declaration
     */
    public static long download(String url, OutputStream out, boolean isCloseOut, StreamProgress streamProgress) {
        void var3_3;
        void var2_2;
        void var1_1;
        return HttpDownloader.download(url, (OutputStream)var1_1, (boolean)var2_2, (StreamProgress)var3_3);
    }

    public static byte[] downloadBytes(String url) {
        return HttpDownloader.downloadBytes(url);
    }

    public static String toParams(Map<String, ?> paramMap) {
        return HttpUtil.toParams(paramMap, CharsetUtil.CHARSET_UTF_8);
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public static String toParams(Map<String, Object> paramMap, String charsetName) {
        void var1_1;
        return HttpUtil.toParams(paramMap, CharsetUtil.charset((String)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public static String toParams(Map<String, ?> paramMap, Charset charset) {
        void var1_1;
        return HttpUtil.toParams(paramMap, (Charset)var1_1, false);
    }

    /*
     * WARNING - void declaration
     */
    public static String toParams(Map<String, ?> paramMap, Charset charset, boolean isFormUrlEncoded) {
        void var1_1;
        void var2_2;
        return UrlQuery.of(paramMap, (boolean)var2_2).build((Charset)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static String encodeParams(String urlWithParams, Charset charset) {
        String string;
        void var2_2;
        void var1_1;
        String paramPart;
        if (StrUtil.isBlank(urlWithParams)) {
            return "";
        }
        String urlPart = null;
        int pathEndPos = urlWithParams.indexOf(63);
        if (pathEndPos >= 0) {
            void var3_3;
            urlPart = StrUtil.subPre(urlWithParams, pathEndPos);
            paramPart = StrUtil.subSuf(urlWithParams, (int)(var3_3 + true));
            if (StrUtil.isBlank(paramPart)) {
                return urlPart;
            }
        } else if (!StrUtil.contains((CharSequence)paramPart, '=')) {
            return paramPart;
        }
        paramPart = HttpUtil.normalizeParams(paramPart, (Charset)var1_1);
        if (StrUtil.isBlank(urlPart)) {
            return paramPart;
        }
        return (String)var2_2 + "?" + string;
    }

    /*
     * WARNING - void declaration
     */
    public static String normalizeParams(String paramPart, Charset charset) {
        void var2_3;
        int lastIndex;
        int i;
        if (StrUtil.isEmpty(paramPart)) {
            return paramPart;
        }
        StrBuilder builder = StrBuilder.create(paramPart.length() + 16);
        int len = paramPart.length();
        String name = null;
        int pos = 0;
        for (i = 0; i < len; ++i) {
            char c = paramPart.charAt(i);
            if (c == '=') {
                if (name != null) continue;
                name = pos == i ? "" : paramPart.substring(pos, i);
            } else {
                if (c != '&') continue;
                if (pos != i) {
                    if (name == null) {
                        name = paramPart.substring(pos, i);
                        builder.append(RFC3986.QUERY_PARAM_NAME.encode(name, charset, new char[0])).append('=');
                    } else {
                        builder.append(RFC3986.QUERY_PARAM_NAME.encode(name, charset, new char[0])).append('=').append(RFC3986.QUERY_PARAM_VALUE.encode(paramPart.substring(pos, i), charset, new char[0])).append('&');
                    }
                    name = null;
                }
            }
            pos = i + 1;
        }
        if (name != null) {
            builder.append(URLUtil.encodeQuery(name, charset)).append('=');
        }
        if (pos != i) {
            void var1_2;
            if (name == null && pos > 0) {
                builder.append('=');
            }
            builder.append(URLUtil.encodeQuery(paramPart.substring(pos, i), (Charset)var1_2));
        }
        if ('&' == builder.charAt(lastIndex = builder.length() - 1)) {
            void var0_1;
            builder.delTo((int)var0_1);
        }
        return var2_3.toString();
    }

    /*
     * WARNING - void declaration
     */
    public static Map<String, String> decodeParamMap(String paramsStr, Charset charset) {
        Map<CharSequence, CharSequence> map;
        void var1_1;
        Map<CharSequence, CharSequence> queryMap = UrlQuery.of(paramsStr, (Charset)var1_1).getQueryMap();
        if (MapUtil.isEmpty(queryMap)) {
            return MapUtil.empty();
        }
        return Convert.toMap(String.class, String.class, map);
    }

    /*
     * WARNING - void declaration
     */
    public static Map<String, List<String>> decodeParams(String paramsStr, String charset) {
        void var1_1;
        return HttpUtil.decodeParams(paramsStr, (String)var1_1, false);
    }

    /*
     * WARNING - void declaration
     */
    public static Map<String, List<String>> decodeParams(String paramsStr, String charset, boolean isFormUrlEncoded) {
        void var2_2;
        void var1_1;
        return HttpUtil.decodeParams(paramsStr, CharsetUtil.charset((String)var1_1), (boolean)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public static Map<String, List<String>> decodeParams(String paramsStr, Charset charset) {
        void var1_1;
        return HttpUtil.decodeParams(paramsStr, (Charset)var1_1, false);
    }

    /*
     * WARNING - void declaration
     */
    public static Map<String, List<String>> decodeParams(String paramsStr, Charset charset, boolean isFormUrlEncoded) {
        void var1_1;
        Map<CharSequence, CharSequence> map;
        void var2_2;
        Map<CharSequence, CharSequence> queryMap = UrlQuery.of(paramsStr, charset, true, (boolean)var2_2).getQueryMap();
        if (MapUtil.isEmpty(queryMap)) {
            return MapUtil.empty();
        }
        LinkedHashMap params = new LinkedHashMap();
        map.forEach((key, value) -> {
            void var2_2;
            void var1_1;
            List list = params.computeIfAbsent(StrUtil.str((CharSequence)var1_1), k -> new ArrayList(1));
            list.add(StrUtil.str((CharSequence)var2_2));
        });
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public static String urlWithForm(String url, Map<String, Object> form, Charset charset, boolean isEncodeParams) {
        void var3_3;
        void var2_2;
        void var1_1;
        return HttpUtil.urlWithForm(url, HttpUtil.toParams(var1_1, charset), (Charset)var2_2, (boolean)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    public static String urlWithFormUrlEncoded(String url, Map<String, Object> form, Charset charset) {
        void var2_2;
        void var1_1;
        return HttpUtil.urlWithForm(url, HttpUtil.toParams(var1_1, charset, true), (Charset)var2_2, true);
    }

    /*
     * WARNING - void declaration
     */
    public static String urlWithForm(String url, String queryString, Charset charset, boolean isEncode) {
        void var1_1;
        void var2_2;
        void var3_3;
        if (StrUtil.isBlank(queryString)) {
            if (StrUtil.contains((CharSequence)url, '?')) {
                if (isEncode) {
                    return HttpUtil.encodeParams(url, charset);
                }
                return url;
            }
            return url;
        }
        StrBuilder urlBuilder = StrBuilder.create(url.length() + queryString.length() + 16);
        int qmIndex = url.indexOf(63);
        if (qmIndex > 0) {
            urlBuilder.append(isEncode ? HttpUtil.encodeParams(url, charset) : url);
            if (!StrUtil.endWith((CharSequence)url, '&')) {
                urlBuilder.append('&');
            }
        } else {
            String string;
            urlBuilder.append(string);
            if (qmIndex < 0) {
                urlBuilder.append('?');
            }
        }
        urlBuilder.append((CharSequence)(var3_3 != false ? HttpUtil.encodeParams(queryString, (Charset)var2_2) : var1_1));
        return urlBuilder.toString();
    }

    public static String getCharset(HttpURLConnection conn) {
        HttpURLConnection httpURLConnection;
        if (conn == null) {
            return null;
        }
        return HttpUtil.getCharset(httpURLConnection.getContentType());
    }

    public static String getCharset(String contentType) {
        String string;
        if (StrUtil.isBlank(contentType)) {
            return null;
        }
        return ReUtil.get(CHARSET_PATTERN, (CharSequence)string, 1);
    }

    /*
     * WARNING - void declaration
     */
    public static String getString(InputStream in, Charset charset, boolean isGetCharsetFromContent) {
        void var2_2;
        void var1_1;
        byte[] byArray = IoUtil.readBytes(in);
        Object object = byArray;
        return HttpUtil.getString(byArray, (Charset)var1_1, (boolean)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public static String getString(byte[] contentBytes, Charset charset, boolean isGetCharsetFromContent) {
        void var3_4;
        String charsetInContentStr;
        if (contentBytes == null) {
            return null;
        }
        if (charset == null) {
            charset = CharsetUtil.CHARSET_UTF_8;
        }
        String content = new String(contentBytes, charset);
        if (isGetCharsetFromContent && StrUtil.isNotBlank(charsetInContentStr = ReUtil.get(META_CHARSET_PATTERN, (CharSequence)content, 1))) {
            void var1_1;
            Charset charsetInContent;
            block7: {
                charsetInContent = null;
                try {
                    charsetInContent = Charset.forName(charsetInContentStr);
                }
                catch (Exception exception) {
                    void var2_3;
                    if (StrUtil.containsIgnoreCase(charsetInContentStr, "utf-8") || StrUtil.containsIgnoreCase(charsetInContentStr, "utf8")) {
                        charsetInContent = CharsetUtil.CHARSET_UTF_8;
                    }
                    if (!StrUtil.containsIgnoreCase((CharSequence)var2_3, "gbk")) break block7;
                    charsetInContent = CharsetUtil.CHARSET_GBK;
                }
            }
            if (charsetInContent != null && !var1_1.equals(charsetInContent)) {
                byte[] byArray;
                content = new String(byArray, charsetInContent);
            }
        }
        return var3_4;
    }

    /*
     * WARNING - void declaration
     */
    public static String getMimeType(String filePath, String defaultValue) {
        void var1_1;
        return (String)ObjectUtil.defaultIfNull(HttpUtil.getMimeType(filePath), var1_1);
    }

    public static String getMimeType(String filePath) {
        return FileUtil.getMimeType(filePath);
    }

    public static String getContentTypeByRequestBody(String body) {
        Object object;
        Object contentType = ContentType.get(body);
        if (contentType == null) {
            return null;
        }
        return ((ContentType)((Object)object)).toString();
    }

    public static SimpleServer createServer(int port) {
        int n;
        return new SimpleServer(n);
    }

    /*
     * WARNING - void declaration
     */
    public static String buildBasicAuth(String username, String password, Charset charset) {
        void var2_2;
        String string;
        void var1_1;
        String data = username.concat(":").concat((String)var1_1);
        return "Basic " + Base64.encode((CharSequence)string, (Charset)var2_2);
    }

    public static void closeCookie() {
        GlobalCookieManager.setCookieManager(null);
    }
}

