/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.http;

import cn.hutool.core.convert.Convert;
import cn.hutool.core.io.FastByteArrayOutputStream;
import cn.hutool.core.io.FileUtil;
import cn.hutool.core.io.IORuntimeException;
import cn.hutool.core.io.IoUtil;
import cn.hutool.core.io.StreamProgress;
import cn.hutool.core.io.resource.BytesResource;
import cn.hutool.core.lang.Assert;
import cn.hutool.core.util.ObjUtil;
import cn.hutool.core.util.ReUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.core.util.URLUtil;
import cn.hutool.http.Header;
import cn.hutool.http.HttpBase;
import cn.hutool.http.HttpConfig;
import cn.hutool.http.HttpConnection;
import cn.hutool.http.HttpException;
import cn.hutool.http.HttpInputStream;
import cn.hutool.http.HttpUtil;
import cn.hutool.http.cookie.GlobalCookieManager;
import java.io.Closeable;
import java.io.EOFException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpCookie;
import java.nio.charset.Charset;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class HttpResponse
extends HttpBase<HttpResponse>
implements Closeable {
    protected HttpConfig config;
    protected HttpConnection httpConnection;
    protected InputStream in;
    private volatile boolean isAsync;
    protected int status;
    private final boolean ignoreBody;
    private Charset charsetFromResponse;

    /*
     * WARNING - void declaration
     */
    protected HttpResponse(HttpConnection httpConnection, HttpConfig config, Charset charset, boolean isAsync, boolean isIgnoreBody) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.httpConnection = var1_1;
        this.config = var2_2;
        this.charset = var3_3;
        this.isAsync = isAsync;
        this.ignoreBody = isIgnoreBody;
        this.initWithDisconnect();
    }

    public int getStatus() {
        return this.status;
    }

    public boolean isOk() {
        return this.status >= 200 && this.status < 300;
    }

    public HttpResponse sync() {
        if (this.isAsync) {
            return this.forceSync();
        }
        return this;
    }

    public String contentEncoding() {
        return this.header(Header.CONTENT_ENCODING);
    }

    /*
     * WARNING - void declaration
     */
    public long contentLength() {
        void var1_1;
        long contentLength = Convert.toLong(this.header(Header.CONTENT_LENGTH), -1L);
        if (contentLength > 0L && (this.isChunked() || StrUtil.isNotBlank(this.contentEncoding()))) {
            contentLength = -1L;
        }
        return (long)var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public boolean isGzip() {
        void var1_1;
        String contentEncoding = this.contentEncoding();
        return "gzip".equalsIgnoreCase((String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public boolean isDeflate() {
        void var1_1;
        String contentEncoding = this.contentEncoding();
        return "deflate".equalsIgnoreCase((String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public boolean isChunked() {
        void var1_1;
        String transferEncoding = this.header(Header.TRANSFER_ENCODING);
        return "Chunked".equalsIgnoreCase((String)var1_1);
    }

    public String getCookieStr() {
        return this.header(Header.SET_COOKIE);
    }

    public List<HttpCookie> getCookies() {
        return GlobalCookieManager.getCookies(this.httpConnection);
    }

    /*
     * WARNING - void declaration
     */
    public HttpCookie getCookie(String name) {
        List<HttpCookie> cookie = this.getCookies();
        if (cookie != null) {
            Iterator iterator;
            iterator = iterator.iterator();
            while (iterator.hasNext()) {
                void var3_3;
                HttpCookie httpCookie = (HttpCookie)iterator.next();
                if (!httpCookie.getName().equals(name)) continue;
                return var3_3;
            }
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public String getCookieValue(String name) {
        void var1_1;
        HttpCookie cookie = this.getCookie(name);
        if (cookie == null) {
            return null;
        }
        return var1_1.getValue();
    }

    public InputStream bodyStream() {
        if (this.isAsync) {
            return this.in;
        }
        if (null == this.body) {
            return null;
        }
        return this.body.getStream();
    }

    @Override
    public byte[] bodyBytes() {
        this.sync();
        return super.bodyBytes();
    }

    /*
     * WARNING - void declaration
     */
    public HttpResponse body(byte[] bodyBytes) {
        this.sync();
        if (bodyBytes != null) {
            void var1_1;
            this.body = new BytesResource((byte[])var1_1);
        }
        return this;
    }

    public String body() throws HttpException {
        return HttpUtil.getString(((HttpBase)this).bodyBytes(), this.charset, this.charsetFromResponse == null);
    }

    /*
     * WARNING - void declaration
     */
    public long writeBody(OutputStream out, boolean isCloseOut, StreamProgress streamProgress) {
        long l;
        Assert.notNull(out, "[out] must be not null!", new Object[0]);
        long contentLength = this.contentLength();
        try {
            void var3_3;
            l = HttpResponse.copyBody(this.bodyStream(), out, contentLength, (StreamProgress)var3_3, this.config.ignoreEOFError);
        }
        catch (Throwable throwable) {
            void var2_2;
            IoUtil.close(this);
            if (var2_2 != false) {
                void var1_1;
                IoUtil.close((Closeable)var1_1);
            }
            throw throwable;
        }
        IoUtil.close(this);
        if (isCloseOut) {
            IoUtil.close(out);
        }
        return l;
    }

    /*
     * WARNING - void declaration
     */
    public long writeBody(File targetFileOrDir, StreamProgress streamProgress) {
        void var2_2;
        void var1_1;
        Assert.notNull(targetFileOrDir, "[targetFileOrDir] must be not null!", new Object[0]);
        File outFile = this.completeFileNameFromHeader(targetFileOrDir);
        return this.writeBody(FileUtil.getOutputStream((File)var1_1), true, (StreamProgress)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public long writeBody(File targetFileOrDir, String tempFileSuffix, StreamProgress streamProgress) {
        long length;
        Assert.notNull(targetFileOrDir, "[targetFileOrDir] must be not null!", new Object[0]);
        File outFile = this.completeFileNameFromHeader(targetFileOrDir);
        tempFileSuffix = StrUtil.isBlank(tempFileSuffix) ? ".temp" : StrUtil.addPrefixIfNot(tempFileSuffix, ".");
        String fileName = outFile.getName();
        String tempFileName = fileName + tempFileSuffix;
        outFile = new File(outFile.getParentFile(), tempFileName);
        try {
            void var3_4;
            length = this.writeBody(outFile, (StreamProgress)var3_4);
            FileUtil.rename(outFile, fileName, true);
        }
        catch (Throwable e) {
            void var2_3;
            void var1_1;
            FileUtil.del((File)var1_1);
            throw new HttpException((Throwable)var2_3);
        }
        return length;
    }

    /*
     * WARNING - void declaration
     */
    public File writeBodyForFile(File targetFileOrDir, StreamProgress streamProgress) {
        void var1_1;
        void var2_2;
        Assert.notNull(targetFileOrDir, "[targetFileOrDir] must be not null!", new Object[0]);
        File outFile = this.completeFileNameFromHeader(targetFileOrDir);
        this.writeBody(FileUtil.getOutputStream(outFile), true, (StreamProgress)var2_2);
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public long writeBody(File targetFileOrDir) {
        void var1_1;
        return this.writeBody((File)var1_1, null);
    }

    /*
     * WARNING - void declaration
     */
    public long writeBody(String targetFileOrDir) {
        void var1_1;
        return this.writeBody(FileUtil.file((String)var1_1));
    }

    @Override
    public void close() {
        IoUtil.close(this.in);
        this.in = null;
        this.httpConnection.disconnectQuietly();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public String toString() {
        void var1_1;
        StringBuilder sb = StrUtil.builder();
        sb.append("Response Headers: \r\n");
        for (Map.Entry<String, List<String>> entry : this.headers.entrySet()) {
            void var3_3;
            sb.append("    ").append(var3_3).append("\r\n");
        }
        sb.append("Response Body: \r\n");
        sb.append("    ").append(this.body()).append("\r\n");
        return var1_1.toString();
    }

    /*
     * WARNING - void declaration
     */
    public File completeFileNameFromHeader(File targetFileOrDir) {
        void var2_2;
        void var1_1;
        if (!targetFileOrDir.isDirectory()) {
            return targetFileOrDir;
        }
        String fileName = this.getFileNameFromDisposition(null);
        if (StrUtil.isBlank(fileName)) {
            void var3_3;
            String path = this.httpConnection.getUrl().getPath();
            fileName = StrUtil.subSuf(path, path.lastIndexOf(47) + 1);
            fileName = StrUtil.isBlank(fileName) ? URLUtil.encodeQuery((String)var3_3, this.charset) : URLUtil.decode(fileName, this.charset);
        }
        return FileUtil.file((File)var1_1, (String)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public String getFileNameFromDisposition(String paramName) {
        void var2_2;
        paramName = ObjUtil.defaultIfNull(paramName, "filename");
        String fileName = null;
        String disposition = this.header(Header.CONTENT_DISPOSITION);
        if (StrUtil.isNotBlank(disposition) && StrUtil.isBlank(fileName = ReUtil.get(paramName + "=\"(.*?)\"", (CharSequence)disposition, 1))) {
            void var1_1;
            void var3_3;
            fileName = StrUtil.subAfter((CharSequence)var3_3, (String)var1_1 + "=", true);
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    private HttpResponse initWithDisconnect() throws HttpException {
        try {
            this.init();
        }
        catch (HttpException e) {
            void var1_1;
            this.httpConnection.disconnectQuietly();
            throw var1_1;
        }
        return this;
    }

    /*
     * WARNING - void declaration
     */
    private HttpResponse init() throws HttpException {
        Charset charset;
        block6: {
            try {
                this.status = this.httpConnection.responseCode();
            }
            catch (IOException e) {
                if (e instanceof FileNotFoundException) break block6;
                throw new HttpException(e);
            }
        }
        try {
            this.headers = this.httpConnection.headers();
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        GlobalCookieManager.store(this.httpConnection);
        this.charsetFromResponse = charset = this.httpConnection.getCharset();
        if (charset != null) {
            void var1_2;
            this.charset = var1_2;
        }
        this.in = new HttpInputStream(this);
        if (this.isAsync) {
            return this;
        }
        return this.forceSync();
    }

    /*
     * WARNING - void declaration
     */
    private HttpResponse forceSync() {
        try {
            HttpResponse httpResponse = this;
            httpResponse.readBody(httpResponse.in);
        }
        catch (IORuntimeException iORuntimeException) {
            IORuntimeException e = iORuntimeException;
            if (!(iORuntimeException.getCause() instanceof FileNotFoundException)) {
                void var1_1;
                throw new HttpException((Throwable)var1_1);
            }
        }
        finally {
            if (this.isAsync) {
                this.isAsync = false;
            }
            this.close();
        }
        return this;
    }

    /*
     * WARNING - void declaration
     */
    private void readBody(InputStream in) throws IORuntimeException {
        void var2_2;
        void var1_1;
        if (this.ignoreBody) {
            return;
        }
        long contentLength = this.contentLength();
        FastByteArrayOutputStream out = new FastByteArrayOutputStream((int)contentLength);
        HttpResponse.copyBody((InputStream)var1_1, out, (long)var2_2, null, this.config.ignoreEOFError);
        this.body = new BytesResource(out.toByteArray());
    }

    /*
     * WARNING - void declaration
     */
    private static long copyBody(InputStream in, OutputStream out, long contentLength, StreamProgress streamProgress, boolean isIgnoreEOFError) {
        long copyLength;
        block3: {
            if (out == null) {
                throw new NullPointerException("[out] is null!");
            }
            copyLength = -1L;
            try {
                void var2_3;
                void var1_2;
                copyLength = IoUtil.copy(in, (OutputStream)var1_2, 8192, (long)var2_3, streamProgress);
            }
            catch (IORuntimeException e) {
                void var0_1;
                if (isIgnoreEOFError && (e.getCause() instanceof EOFException || StrUtil.containsIgnoreCase(e.getMessage(), "Premature EOF"))) break block3;
                throw var0_1;
            }
        }
        return copyLength;
    }
}

