/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.http;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.convert.Convert;
import cn.hutool.core.io.IORuntimeException;
import cn.hutool.core.io.resource.BytesResource;
import cn.hutool.core.io.resource.FileResource;
import cn.hutool.core.io.resource.MultiFileResource;
import cn.hutool.core.io.resource.Resource;
import cn.hutool.core.lang.Assert;
import cn.hutool.core.map.MapUtil;
import cn.hutool.core.map.TableMap;
import cn.hutool.core.net.url.UrlBuilder;
import cn.hutool.core.net.url.UrlQuery;
import cn.hutool.core.util.ArrayUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.http.ContentType;
import cn.hutool.http.GlobalHeaders;
import cn.hutool.http.Header;
import cn.hutool.http.HttpBase;
import cn.hutool.http.HttpConfig;
import cn.hutool.http.HttpConnection;
import cn.hutool.http.HttpException;
import cn.hutool.http.HttpGlobalConfig;
import cn.hutool.http.HttpInterceptor;
import cn.hutool.http.HttpResponse;
import cn.hutool.http.HttpStatus;
import cn.hutool.http.HttpUtil;
import cn.hutool.http.Method;
import cn.hutool.http.body.FormUrlEncodedBody;
import cn.hutool.http.body.MultipartBody;
import cn.hutool.http.body.RequestBody;
import cn.hutool.http.body.ResourceBody;
import cn.hutool.http.cookie.GlobalCookieManager;
import java.io.File;
import java.io.IOException;
import java.net.CookieManager;
import java.net.HttpCookie;
import java.net.Proxy;
import java.net.URLStreamHandler;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLSocketFactory;

public class HttpRequest
extends HttpBase<HttpRequest> {
    private HttpConfig config = HttpConfig.create();
    private UrlBuilder url;
    private URLStreamHandler urlHandler;
    private Method method = Method.GET;
    private HttpConnection httpConnection;
    private Map<String, Object> form;
    private String cookie;
    private boolean isMultiPart;
    private boolean isRest;
    private int redirectCount;

    public static HttpRequest post(String url) {
        return HttpRequest.of(url).method(Method.POST);
    }

    public static HttpRequest get(String url) {
        return HttpRequest.of(url).method(Method.GET);
    }

    public static HttpRequest head(String url) {
        return HttpRequest.of(url).method(Method.HEAD);
    }

    public static HttpRequest options(String url) {
        return HttpRequest.of(url).method(Method.OPTIONS);
    }

    public static HttpRequest put(String url) {
        return HttpRequest.of(url).method(Method.PUT);
    }

    public static HttpRequest patch(String url) {
        return HttpRequest.of(url).method(Method.PATCH);
    }

    public static HttpRequest delete(String url) {
        return HttpRequest.of(url).method(Method.DELETE);
    }

    public static HttpRequest trace(String url) {
        return HttpRequest.of(url).method(Method.TRACE);
    }

    public static HttpRequest of(String url) {
        return HttpRequest.of(url, HttpGlobalConfig.isDecodeUrl() ? DEFAULT_CHARSET : null);
    }

    /*
     * WARNING - void declaration
     */
    public static HttpRequest of(String url, Charset charset) {
        void var1_1;
        return HttpRequest.of(UrlBuilder.ofHttp(url, (Charset)var1_1));
    }

    public static HttpRequest of(UrlBuilder url) {
        UrlBuilder urlBuilder;
        return new HttpRequest(urlBuilder);
    }

    public static void setGlobalTimeout(int customTimeout) {
        HttpGlobalConfig.setTimeout(customTimeout);
    }

    public static CookieManager getCookieManager() {
        return GlobalCookieManager.getCookieManager();
    }

    public static void setCookieManager(CookieManager customCookieManager) {
        GlobalCookieManager.setCookieManager(customCookieManager);
    }

    public static void closeCookie() {
        GlobalCookieManager.setCookieManager(null);
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public HttpRequest(String url) {
        this(UrlBuilder.ofHttp((String)var1_1));
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public HttpRequest(UrlBuilder url) {
        this.url = Assert.notNull(url, "URL must be not null!", new Object[0]);
        Charset charset = url.getCharset();
        if (charset != null) {
            void var1_1;
            this.charset((Charset)var1_1);
        }
        this.header(GlobalHeaders.INSTANCE.headers);
    }

    public String getUrl() {
        return this.url.toString();
    }

    /*
     * WARNING - void declaration
     */
    public HttpRequest setUrl(String url) {
        void var1_1;
        return this.setUrl(UrlBuilder.ofHttp((String)var1_1, this.charset));
    }

    /*
     * WARNING - void declaration
     */
    public HttpRequest setUrl(UrlBuilder urlBuilder) {
        void var1_1;
        this.url = var1_1;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public HttpRequest setUrlHandler(URLStreamHandler urlHandler) {
        void var1_1;
        this.urlHandler = var1_1;
        return this;
    }

    public Method getMethod() {
        return this.method;
    }

    /*
     * WARNING - void declaration
     */
    public HttpRequest setMethod(Method method) {
        void var1_1;
        return this.method((Method)var1_1);
    }

    public HttpConnection getConnection() {
        return this.httpConnection;
    }

    /*
     * WARNING - void declaration
     */
    public HttpRequest method(Method method) {
        void var1_1;
        this.method = var1_1;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public HttpRequest contentType(String contentType) {
        void var1_1;
        this.header(Header.CONTENT_TYPE, (String)var1_1);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public HttpRequest keepAlive(boolean isKeepAlive) {
        void var1_1;
        this.header(Header.CONNECTION, var1_1 != false ? "Keep-Alive" : "Close");
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public boolean isKeepAlive() {
        void var1_1;
        String connection = this.header(Header.CONNECTION);
        if (connection == null) {
            return false == "HTTP/1.0".equalsIgnoreCase(this.httpVersion);
        }
        return false == "close".equalsIgnoreCase((String)var1_1);
    }

    public String contentLength() {
        return this.header(Header.CONTENT_LENGTH);
    }

    /*
     * WARNING - void declaration
     */
    public HttpRequest contentLength(int value) {
        void var1_1;
        this.header(Header.CONTENT_LENGTH, String.valueOf((int)var1_1));
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public HttpRequest cookie(Collection<HttpCookie> cookies) {
        void var1_1;
        return this.cookie(CollUtil.isEmpty(cookies) ? null : var1_1.toArray(new HttpCookie[0]));
    }

    /*
     * WARNING - void declaration
     */
    public HttpRequest cookie(HttpCookie ... cookies) {
        void var1_1;
        if (ArrayUtil.isEmpty(cookies)) {
            return this.disableCookie();
        }
        return this.cookie(ArrayUtil.join(var1_1, (CharSequence)"; "));
    }

    /*
     * WARNING - void declaration
     */
    public HttpRequest cookie(String cookie) {
        void var1_1;
        this.cookie = var1_1;
        return this;
    }

    public HttpRequest disableCookie() {
        return this.cookie("");
    }

    public HttpRequest enableDefaultCookie() {
        return this.cookie((String)null);
    }

    /*
     * WARNING - void declaration
     */
    public HttpRequest form(String name, Object value) {
        void var2_2;
        void var1_1;
        String strValue;
        if (StrUtil.isBlank(name) || ObjectUtil.isNull(value)) {
            return this;
        }
        this.body = null;
        if (value instanceof File) {
            return this.form(name, (File)value);
        }
        if (value instanceof Resource) {
            return this.form(name, (Resource)value);
        }
        if (value instanceof Iterable) {
            strValue = CollUtil.join((Iterable)value, (CharSequence)",");
        } else if (ArrayUtil.isArray(strValue)) {
            if (File.class == ArrayUtil.getComponentType(strValue)) {
                return this.form(name, (File[])strValue);
            }
            strValue = ArrayUtil.join((Object[])strValue, (CharSequence)",");
        } else {
            strValue = Convert.toStr(strValue, null);
        }
        return this.putToForm((String)var1_1, var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public HttpRequest form(String name, Object value, Object ... parameters) {
        void var2_3;
        this.form(name, var2_3);
        for (int i = 0; i < parameters.length; i += 2) {
            this.form(parameters[i].toString(), parameters[i + 1]);
        }
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public HttpRequest form(Map<String, Object> formMap) {
        if (MapUtil.isNotEmpty(formMap)) {
            void var1_1;
            var1_1.forEach(this::form);
        }
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public HttpRequest formStr(Map<String, String> formMapStr) {
        if (MapUtil.isNotEmpty(formMapStr)) {
            void var1_1;
            var1_1.forEach(this::form);
        }
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public HttpRequest form(String name, File ... files) {
        void var1_1;
        void var2_2;
        if (ArrayUtil.isEmpty(files)) {
            return this;
        }
        if (1 == files.length) {
            File file = files[0];
            void v0 = var2_2;
            return this.form(name, (File)v0, v0.getName());
        }
        return this.form((String)var1_1, new MultiFileResource((File[])var2_2));
    }

    /*
     * WARNING - void declaration
     */
    public HttpRequest form(String name, File file) {
        void var1_1;
        void var2_2;
        void v0 = var2_2;
        return this.form((String)var1_1, (File)v0, v0.getName());
    }

    /*
     * WARNING - void declaration
     */
    public HttpRequest form(String name, File file, String fileName) {
        if (file != null) {
            void var3_3;
            void var2_2;
            void var1_1;
            this.form((String)var1_1, new FileResource((File)var2_2, (String)var3_3));
        }
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public HttpRequest form(String name, byte[] fileBytes, String fileName) {
        if (fileBytes != null) {
            void var3_3;
            void var2_2;
            void var1_1;
            this.form((String)var1_1, new BytesResource((byte[])var2_2, (String)var3_3));
        }
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public HttpRequest form(String name, Resource resource) {
        if (resource != null) {
            void var2_2;
            void var1_1;
            if (!this.isKeepAlive()) {
                this.keepAlive(true);
            }
            this.isMultiPart = true;
            return this.putToForm((String)var1_1, var2_2);
        }
        return this;
    }

    public Map<String, Object> form() {
        return this.form;
    }

    /*
     * WARNING - void declaration
     */
    public Map<String, Resource> fileForm() {
        void var1_1;
        HashMap result = MapUtil.newHashMap();
        this.form.forEach((key, value) -> {
            if (value instanceof Resource) {
                void var2_2;
                void var1_1;
                Map map;
                map.put(var1_1, (Resource)var2_2);
            }
        });
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public HttpRequest body(String body) {
        void var1_1;
        return this.body((String)var1_1, null);
    }

    /*
     * WARNING - void declaration
     */
    public HttpRequest body(String body, String contentType) {
        void var2_2;
        byte[] bytes = StrUtil.bytes((CharSequence)body, this.charset);
        this.body(bytes);
        this.form = null;
        if (contentType != null) {
            this.contentType(contentType);
        } else {
            void var1_1;
            contentType = HttpUtil.getContentTypeByRequestBody((String)var1_1);
            if (contentType != null && ContentType.isDefault(this.header(Header.CONTENT_TYPE))) {
                if (null != this.charset) {
                    contentType = ContentType.build(contentType, this.charset);
                }
                this.contentType(contentType);
            }
        }
        if (StrUtil.containsAnyIgnoreCase((CharSequence)var2_2, "json", "xml")) {
            void var3_3;
            this.isRest = true;
            this.contentLength(((void)var3_3).length);
        }
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public HttpRequest body(byte[] bodyBytes) {
        if (ArrayUtil.isNotEmpty(bodyBytes)) {
            void var1_1;
            return this.body(new BytesResource((byte[])var1_1));
        }
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public HttpRequest body(Resource resource) {
        if (resource != null) {
            void var1_1;
            this.body = var1_1;
        }
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public HttpRequest setConfig(HttpConfig config) {
        void var1_1;
        this.config = var1_1;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public HttpRequest timeout(int milliseconds) {
        void var1_1;
        this.config.timeout((int)var1_1);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public HttpRequest setConnectionTimeout(int milliseconds) {
        void var1_1;
        this.config.setConnectionTimeout((int)var1_1);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public HttpRequest setReadTimeout(int milliseconds) {
        void var1_1;
        this.config.setReadTimeout((int)var1_1);
        return this;
    }

    public HttpRequest disableCache() {
        this.config.disableCache();
        return this;
    }

    public HttpRequest setFollowRedirects(boolean isFollowRedirects) {
        if (isFollowRedirects) {
            if (this.config.maxRedirectCount <= 0) {
                return this.setMaxRedirectCount(2);
            }
        } else if (this.config.maxRedirectCount < 0) {
            return this.setMaxRedirectCount(0);
        }
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public HttpRequest setFollowRedirectsCookie(boolean followRedirectsCookie) {
        void var1_1;
        this.config.setFollowRedirectsCookie((boolean)var1_1);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public HttpRequest setMaxRedirectCount(int maxRedirectCount) {
        void var1_1;
        this.config.setMaxRedirectCount((int)var1_1);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public HttpRequest setHostnameVerifier(HostnameVerifier hostnameVerifier) {
        void var1_1;
        this.config.setHostnameVerifier((HostnameVerifier)var1_1);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public HttpRequest setHttpProxy(String host, int port) {
        void var2_2;
        void var1_1;
        this.config.setHttpProxy((String)var1_1, (int)var2_2);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public HttpRequest setProxy(Proxy proxy) {
        void var1_1;
        this.config.setProxy((Proxy)var1_1);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public HttpRequest setSSLSocketFactory(SSLSocketFactory ssf) {
        void var1_1;
        this.config.setSSLSocketFactory((SSLSocketFactory)var1_1);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public HttpRequest setSSLProtocol(String protocol) {
        void var1_1;
        this.config.setSSLProtocol((String)var1_1);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public HttpRequest setRest(boolean isRest) {
        void var1_1;
        this.isRest = var1_1;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public HttpRequest setChunkedStreamingMode(int blockSize) {
        void var1_1;
        this.config.setBlockSize((int)var1_1);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public HttpRequest addInterceptor(HttpInterceptor<HttpRequest> interceptor) {
        void var1_1;
        return this.addRequestInterceptor((HttpInterceptor<HttpRequest>)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public HttpRequest addRequestInterceptor(HttpInterceptor<HttpRequest> interceptor) {
        void var1_1;
        this.config.addRequestInterceptor((HttpInterceptor<HttpRequest>)var1_1);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public HttpRequest addResponseInterceptor(HttpInterceptor<HttpResponse> interceptor) {
        void var1_1;
        this.config.addResponseInterceptor((HttpInterceptor<HttpResponse>)var1_1);
        return this;
    }

    public HttpResponse execute() {
        return this.execute(false);
    }

    public HttpResponse executeAsync() {
        return this.execute(true);
    }

    /*
     * WARNING - void declaration
     */
    public HttpResponse execute(boolean isAsync) {
        void var1_1;
        return this.doExecute((boolean)var1_1, this.config.requestInterceptors, this.config.responseInterceptors);
    }

    /*
     * WARNING - void declaration
     */
    public void then(Consumer<HttpResponse> consumer) {
        Throwable throwable;
        HttpResponse response2 = this.execute(true);
        Throwable throwable2 = null;
        try {
            throwable.accept(response2);
            if (response2 != null) {
                response2.close();
                return;
            }
        }
        catch (Throwable throwable3) {
            try {
                throwable = throwable3;
                throwable2 = throwable3;
                throw throwable;
            }
            catch (Throwable throwable4) {
                if (response2 != null) {
                    if (throwable2 != null) {
                        try {
                            response2.close();
                        }
                        catch (Throwable response2) {
                            throwable2.addSuppressed(response2);
                        }
                    } else {
                        void var2_3;
                        var2_3.close();
                    }
                }
                throw throwable4;
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public <T> T thenFunction(Function<HttpResponse, T> function) {
        Object object;
        block9: {
            HttpResponse response2 = this.execute(true);
            Throwable throwable = null;
            try {
                object = object.apply(response2);
                if (response2 == null) break block9;
                response2.close();
            }
            catch (Throwable throwable2) {
                try {
                    object = throwable2;
                    throwable = throwable2;
                    throw object;
                }
                catch (Throwable throwable3) {
                    if (response2 != null) {
                        if (throwable != null) {
                            try {
                                response2.close();
                            }
                            catch (Throwable response2) {
                                throwable.addSuppressed(response2);
                            }
                        } else {
                            void var2_3;
                            var2_3.close();
                        }
                    }
                    throw throwable3;
                }
            }
        }
        return (T)object;
    }

    /*
     * WARNING - void declaration
     */
    public HttpRequest basicAuth(String username, String password) {
        void var2_2;
        void var1_1;
        return this.auth(HttpUtil.buildBasicAuth((String)var1_1, (String)var2_2, this.charset));
    }

    /*
     * WARNING - void declaration
     */
    public HttpRequest basicProxyAuth(String username, String password) {
        void var2_2;
        void var1_1;
        return this.proxyAuth(HttpUtil.buildBasicAuth((String)var1_1, (String)var2_2, this.charset));
    }

    /*
     * WARNING - void declaration
     */
    public HttpRequest bearerAuth(String token) {
        void var1_1;
        return this.auth("Bearer " + (String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public HttpRequest auth(String content) {
        void var1_1;
        this.header(Header.AUTHORIZATION, (String)var1_1, true);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public HttpRequest proxyAuth(String content) {
        void var1_1;
        this.header(Header.PROXY_AUTHORIZATION, (String)var1_1, true);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public String toString() {
        void var1_1;
        StringBuilder sb = StrUtil.builder();
        sb.append("Request Url: ").append(this.url.setCharset(this.charset)).append("\r\n");
        sb.append("Request Headers: \r\n");
        for (Map.Entry<String, List<String>> entry : this.headers.entrySet()) {
            void var3_3;
            sb.append("    ").append(entry.getKey()).append(": ").append(CollUtil.join((Iterable)var3_3.getValue(), (CharSequence)",")).append("\r\n");
        }
        sb.append("Request Body: \r\n");
        sb.append("    ").append(this.createBody()).append("\r\n");
        return var1_1.toString();
    }

    /*
     * WARNING - void declaration
     */
    private HttpResponse doExecute(boolean isAsync, HttpInterceptor.Chain<HttpRequest> requestInterceptors, HttpInterceptor.Chain<HttpResponse> responseInterceptors) {
        void var2_3;
        if (requestInterceptors != null) {
            requestInterceptors = ((HttpInterceptor.Chain)requestInterceptors).iterator();
            while (requestInterceptors.hasNext()) {
                HttpInterceptor httpInterceptor = (HttpInterceptor)requestInterceptors.next();
                httpInterceptor.process(this);
            }
        }
        this.urlWithParamIfGet();
        this.initConnection();
        this.send();
        HttpResponse httpResponse = this.sendRedirectIfPossible(isAsync);
        if (httpResponse == null) {
            void var1_1;
            httpResponse = new HttpResponse(this.httpConnection, this.config, this.charset, (boolean)var1_1, this.isIgnoreResponseBody());
        }
        if (responseInterceptors != null) {
            void var3_4;
            for (HttpInterceptor httpInterceptor : var3_4) {
                httpInterceptor.process(httpResponse);
            }
        }
        return var2_3;
    }

    private void initConnection() {
        if (this.httpConnection != null) {
            this.httpConnection.disconnectQuietly();
        }
        this.httpConnection = HttpConnection.create(this.url.setCharset(this.charset).toURL(this.urlHandler), this.config.proxy).setConnectTimeout(this.config.connectionTimeout).setReadTimeout(this.config.readTimeout).setMethod(this.method).setHttpsInfo(this.config.hostnameVerifier, this.config.ssf).setInstanceFollowRedirects(false).setChunkedStreamingMode(this.config.blockSize).header(this.headers, true);
        if (this.cookie != null) {
            this.httpConnection.setCookie(this.cookie);
        } else {
            GlobalCookieManager.add(this.httpConnection);
        }
        if (this.config.isDisableCache) {
            this.httpConnection.disableCache();
        }
    }

    /*
     * WARNING - void declaration
     */
    private void urlWithParamIfGet() {
        if (Method.GET.equals((Object)this.method) && !this.isRest && this.redirectCount <= 0) {
            void var1_1;
            UrlQuery query = this.url.getQuery();
            if (query == null) {
                query = new UrlQuery();
                this.url.setQuery(query);
            }
            if (null != this.body) {
                query.parse(StrUtil.str(this.body.readBytes(), this.charset), this.charset);
                return;
            }
            var1_1.addAll(this.form);
        }
    }

    /*
     * WARNING - void declaration
     */
    private HttpResponse sendRedirectIfPossible(boolean isAsync) {
        if (this.config.maxRedirectCount > 0) {
            int responseCode;
            try {
                responseCode = this.httpConnection.responseCode();
            }
            catch (IOException e) {
                this.httpConnection.disconnectQuietly();
                throw new HttpException(e);
            }
            if (this.config.followRedirectsCookie) {
                GlobalCookieManager.store(this.httpConnection);
            }
            if (responseCode != 200 && HttpStatus.isRedirected(responseCode)) {
                void var2_4;
                UrlBuilder redirectUrl;
                String location = this.httpConnection.header(Header.LOCATION);
                if (!HttpUtil.isHttp(location) && !HttpUtil.isHttps(location)) {
                    void var3_5;
                    String query;
                    List<String> split;
                    if (!location.startsWith("/")) {
                        location = StrUtil.addSuffixIfNot(this.url.getPathStr(), "/") + location;
                    }
                    if ((split = StrUtil.split(location, '?', 2)).size() == 2) {
                        location = split.get(0);
                        query = split.get(1);
                    } else {
                        query = null;
                    }
                    redirectUrl = UrlBuilder.of(this.url.getScheme(), this.url.getHost(), this.url.getPort(), location, (String)var3_5, null, this.charset);
                } else {
                    redirectUrl = UrlBuilder.ofHttpWithoutEncode((String)((Object)redirectUrl));
                }
                this.setUrl((UrlBuilder)var2_4);
                if (this.redirectCount < this.config.maxRedirectCount) {
                    void var1_1;
                    ++this.redirectCount;
                    return this.doExecute((boolean)var1_1, this.config.interceptorOnRedirect ? this.config.requestInterceptors : null, this.config.interceptorOnRedirect ? this.config.responseInterceptors : null);
                }
            }
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private void send() throws IORuntimeException {
        block5: {
            try {
                if (Method.POST.equals((Object)this.method) || Method.PUT.equals((Object)this.method) || Method.DELETE.equals((Object)this.method) || this.isRest) {
                    if (this.isMultipart()) {
                        this.sendMultipart();
                    } else {
                        this.sendFormUrlEncoded();
                    }
                    break block5;
                }
                this.httpConnection.connect();
                return;
            }
            catch (IOException e) {
                void var1_1;
                this.httpConnection.disconnectQuietly();
                throw new IORuntimeException((Throwable)var1_1);
            }
        }
    }

    private void sendFormUrlEncoded() throws IOException {
        if (StrUtil.isBlank(this.header(Header.CONTENT_TYPE))) {
            this.httpConnection.header(Header.CONTENT_TYPE, ContentType.FORM_URLENCODED.toString(this.charset), true);
        }
        this.createBody().writeClose(this.httpConnection.getOutputStream());
    }

    private RequestBody createBody() {
        if (null != this.body) {
            return ResourceBody.create(this.body);
        }
        return FormUrlEncodedBody.create(this.form, this.charset);
    }

    /*
     * WARNING - void declaration
     */
    private void sendMultipart() throws IOException {
        void var1_1;
        if (this.form == null && null != this.body) {
            ResourceBody body = ResourceBody.create(this.body);
        } else {
            MultipartBody multipartBody = MultipartBody.create(this.form, this.charset);
            this.httpConnection.header(Header.CONTENT_TYPE, multipartBody.getContentType(), true);
        }
        var1_1.writeClose(this.httpConnection.getOutputStream());
    }

    private boolean isIgnoreResponseBody() {
        return Method.HEAD == this.method || Method.CONNECT == this.method || Method.TRACE == this.method;
    }

    /*
     * WARNING - void declaration
     */
    private boolean isMultipart() {
        void var1_1;
        if (this.isMultiPart) {
            return true;
        }
        String contentType = this.header(Header.CONTENT_TYPE);
        return StrUtil.isNotEmpty(contentType) && var1_1.startsWith(ContentType.MULTIPART.getValue());
    }

    /*
     * WARNING - void declaration
     */
    private HttpRequest putToForm(String name, Object value) {
        void var2_2;
        void var1_1;
        if (name == null || value == null) {
            return this;
        }
        if (this.form == null) {
            this.form = new TableMap<String, Object>(16);
        }
        this.form.put((String)var1_1, var2_2);
        return this;
    }
}

