/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.http;

import cn.hutool.core.util.StrUtil;
import cn.hutool.http.HttpException;
import cn.hutool.http.HttpResponse;
import java.io.ByteArrayInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;

public class HttpInputStream
extends InputStream {
    private InputStream in;

    /*
     * WARNING - void declaration
     */
    public HttpInputStream(HttpResponse response) {
        void var1_1;
        this.init((HttpResponse)var1_1);
    }

    @Override
    public int read() throws IOException {
        return this.in.read();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        void var3_3;
        void var2_2;
        void var1_1;
        return this.in.read((byte[])var1_1, (int)var2_2, (int)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public long skip(long n) throws IOException {
        void var1_1;
        return this.in.skip((long)var1_1);
    }

    @Override
    public int available() throws IOException {
        return this.in.available();
    }

    @Override
    public void close() throws IOException {
        this.in.close();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public synchronized void mark(int readlimit) {
        void var1_1;
        this.in.mark((int)var1_1);
    }

    @Override
    public synchronized void reset() throws IOException {
        this.in.reset();
    }

    @Override
    public boolean markSupported() {
        return this.in.markSupported();
    }

    /*
     * WARNING - void declaration
     */
    private void init(HttpResponse response) {
        void var1_1;
        block7: {
            try {
                this.in = response.status < 400 ? response.httpConnection.getInputStream() : response.httpConnection.getErrorStream();
            }
            catch (IOException e) {
                void var2_2;
                if (e instanceof FileNotFoundException) break block7;
                throw new HttpException((Throwable)var2_2);
            }
        }
        if (this.in == null) {
            this.in = new ByteArrayInputStream(StrUtil.format("Error request, response status: {}", response.status).getBytes());
            return;
        }
        if (response.isGzip() && !(response.in instanceof GZIPInputStream)) {
            try {
                this.in = new GZIPInputStream(this.in);
                return;
            }
            catch (IOException iOException) {
                return;
            }
        }
        if (var1_1.isDeflate() && !(this.in instanceof InflaterInputStream)) {
            this.in = new InflaterInputStream(this.in, new Inflater(true));
        }
    }
}

