/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.http;

import cn.hutool.core.map.MapUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.ReflectUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.core.util.URLUtil;
import cn.hutool.http.Header;
import cn.hutool.http.HttpException;
import cn.hutool.http.HttpGlobalConfig;
import cn.hutool.http.HttpUtil;
import cn.hutool.http.Method;
import cn.hutool.http.ssl.DefaultSSLInfo;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.ProtocolException;
import java.net.Proxy;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.Charset;
import java.nio.charset.UnsupportedCharsetException;
import java.util.List;
import java.util.Map;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLSocketFactory;

public class HttpConnection {
    private final URL url;
    private final Proxy proxy;
    private HttpURLConnection conn;

    /*
     * WARNING - void declaration
     */
    public static HttpConnection create(String urlStr, Proxy proxy) {
        void var1_1;
        return HttpConnection.create(URLUtil.toUrlForHttp(urlStr), (Proxy)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static HttpConnection create(URL url, Proxy proxy) {
        void var1_1;
        URL uRL;
        return new HttpConnection(uRL, (Proxy)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public HttpConnection(URL url, Proxy proxy) {
        void var2_2;
        void var1_1;
        this.url = var1_1;
        this.proxy = var2_2;
        this.initConn();
    }

    /*
     * WARNING - void declaration
     */
    public HttpConnection initConn() {
        try {
            this.conn = this.openHttp();
        }
        catch (IOException e) {
            void var1_1;
            throw new HttpException((Throwable)var1_1);
        }
        this.conn.setDoInput(true);
        return this;
    }

    public Method getMethod() {
        return Method.valueOf(this.conn.getRequestMethod());
    }

    /*
     * WARNING - void declaration
     */
    public HttpConnection setMethod(Method method) {
        if (Method.POST.equals((Object)method) || Method.PUT.equals((Object)method) || Method.PATCH.equals((Object)method) || Method.DELETE.equals((Object)method)) {
            this.conn.setUseCaches(false);
            if (Method.PATCH.equals((Object)method)) {
                try {
                    HttpGlobalConfig.allowPatch();
                }
                catch (Exception exception) {}
            }
        }
        try {
            this.conn.setRequestMethod(method.toString());
        }
        catch (ProtocolException e) {
            void var2_2;
            if (Method.PATCH.equals((Object)method)) {
                void var1_1;
                this.reflectSetMethod((Method)var1_1);
            }
            throw new HttpException((Throwable)var2_2);
        }
        return this;
    }

    public URL getUrl() {
        return this.url;
    }

    public Proxy getProxy() {
        return this.proxy;
    }

    public HttpURLConnection getHttpURLConnection() {
        return this.conn;
    }

    /*
     * WARNING - void declaration
     */
    public HttpConnection header(String header, String value, boolean isOverride) {
        if (this.conn != null) {
            void var3_3;
            if (var3_3 != false) {
                this.conn.setRequestProperty(header, value);
            } else {
                void var2_2;
                void var1_1;
                this.conn.addRequestProperty((String)var1_1, (String)var2_2);
            }
        }
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public HttpConnection header(Header header, String value, boolean isOverride) {
        void var3_3;
        void var2_2;
        void var1_1;
        return this.header(var1_1.toString(), (String)var2_2, (boolean)var3_3);
    }

    public HttpConnection header(Map<String, List<String>> headerMap, boolean isOverride) {
        if (MapUtil.isNotEmpty(headerMap)) {
            for (Map.Entry<String, List<String>> entry : headerMap.entrySet()) {
                String name = entry.getKey();
                for (String value : entry.getValue()) {
                    this.header(name, StrUtil.nullToEmpty(value), isOverride);
                }
            }
        }
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public String header(String name) {
        void var1_1;
        return this.conn.getHeaderField((String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public String header(Header name) {
        void var1_1;
        return this.header(var1_1.toString());
    }

    public Map<String, List<String>> headers() {
        return this.conn.getHeaderFields();
    }

    /*
     * WARNING - void declaration
     */
    public HttpConnection setHttpsInfo(HostnameVerifier hostnameVerifier, SSLSocketFactory ssf) throws HttpException {
        HttpURLConnection conn = this.conn;
        if (conn instanceof HttpsURLConnection) {
            void var2_2;
            void var3_3;
            void var1_1;
            HttpsURLConnection httpsConn = (HttpsURLConnection)conn;
            httpsConn.setHostnameVerifier(ObjectUtil.defaultIfNull(var1_1, HttpGlobalConfig.isTrustAnyHost() ? DefaultSSLInfo.TRUST_ANY_HOSTNAME_VERIFIER : HttpsURLConnection.getDefaultHostnameVerifier()));
            var3_3.setSSLSocketFactory(ObjectUtil.defaultIfNull(var2_2, DefaultSSLInfo.DEFAULT_SSF));
        }
        return this;
    }

    public HttpConnection disableCache() {
        this.conn.setUseCaches(false);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public HttpConnection setConnectTimeout(int timeout) {
        if (timeout > 0 && this.conn != null) {
            void var1_1;
            this.conn.setConnectTimeout((int)var1_1);
        }
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public HttpConnection setReadTimeout(int timeout) {
        if (timeout > 0 && this.conn != null) {
            void var1_1;
            this.conn.setReadTimeout((int)var1_1);
        }
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public HttpConnection setConnectionAndReadTimeout(int timeout) {
        void var1_1;
        this.setConnectTimeout(timeout);
        this.setReadTimeout((int)var1_1);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public HttpConnection setCookie(String cookie) {
        if (cookie != null) {
            void var1_1;
            this.header(Header.COOKIE, (String)var1_1, true);
        }
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public HttpConnection setChunkedStreamingMode(int blockSize) {
        if (blockSize > 0) {
            void var1_1;
            this.conn.setChunkedStreamingMode((int)var1_1);
        }
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public HttpConnection setInstanceFollowRedirects(boolean isInstanceFollowRedirects) {
        void var1_1;
        this.conn.setInstanceFollowRedirects((boolean)var1_1);
        return this;
    }

    public HttpConnection connect() throws IOException {
        if (this.conn != null) {
            this.conn.connect();
        }
        return this;
    }

    public HttpConnection disconnectQuietly() {
        try {
            this.disconnect();
        }
        catch (Throwable throwable) {}
        return this;
    }

    public HttpConnection disconnect() {
        if (this.conn != null) {
            this.conn.disconnect();
        }
        return this;
    }

    public InputStream getInputStream() throws IOException {
        if (this.conn != null) {
            return this.conn.getInputStream();
        }
        return null;
    }

    public InputStream getErrorStream() {
        if (this.conn != null) {
            return this.conn.getErrorStream();
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public OutputStream getOutputStream() throws IOException {
        void var2_2;
        if (this.conn == null) {
            throw new IOException("HttpURLConnection has not been initialized.");
        }
        Method method = this.getMethod();
        this.conn.setDoOutput(true);
        OutputStream out = this.conn.getOutputStream();
        if (method == Method.GET && method != this.getMethod()) {
            void var1_1;
            this.reflectSetMethod((Method)var1_1);
        }
        return var2_2;
    }

    public int responseCode() throws IOException {
        if (this.conn != null) {
            return this.conn.getResponseCode();
        }
        return 0;
    }

    public String getCharsetName() {
        return HttpUtil.getCharset(this.conn);
    }

    /*
     * WARNING - void declaration
     */
    public Charset getCharset() {
        void var1_1;
        Charset charset = null;
        String charsetName = this.getCharsetName();
        if (StrUtil.isNotBlank(charsetName)) {
            try {
                void var2_2;
                charset = Charset.forName((String)var2_2);
            }
            catch (UnsupportedCharsetException unsupportedCharsetException) {}
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public String toString() {
        void var1_1;
        StringBuilder sb = StrUtil.builder();
        sb.append("Request URL: ").append(this.url).append("\r\n");
        sb.append("Request Method: ").append((Object)this.getMethod()).append("\r\n");
        return var1_1.toString();
    }

    /*
     * WARNING - void declaration
     */
    private HttpURLConnection openHttp() throws IOException {
        void var1_1;
        URLConnection conn = this.openConnection();
        if (!(conn instanceof HttpURLConnection)) {
            throw new HttpException("'{}' of URL [{}] is not a http connection, make sure URL is format for http.", conn.getClass().getName(), this.url);
        }
        return (HttpURLConnection)var1_1;
    }

    private URLConnection openConnection() throws IOException {
        if (this.proxy == null) {
            return this.url.openConnection();
        }
        return this.url.openConnection(this.proxy);
    }

    /*
     * WARNING - void declaration
     */
    private void reflectSetMethod(Method method) {
        ReflectUtil.setFieldValue((Object)this.conn, "method", (Object)method.name());
        Object delegate = ReflectUtil.getFieldValue((Object)this.conn, "delegate");
        if (delegate != null) {
            void var1_1;
            void var2_2;
            ReflectUtil.setFieldValue((Object)var2_2, "method", (Object)var1_1.name());
        }
    }
}

