/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.http;

import cn.hutool.core.lang.Assert;
import cn.hutool.core.net.SSLUtil;
import cn.hutool.http.GlobalInterceptor;
import cn.hutool.http.HttpGlobalConfig;
import cn.hutool.http.HttpInterceptor;
import cn.hutool.http.HttpRequest;
import cn.hutool.http.HttpResponse;
import java.net.InetSocketAddress;
import java.net.Proxy;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLSocketFactory;

public class HttpConfig {
    int connectionTimeout = HttpGlobalConfig.getTimeout();
    int readTimeout = HttpGlobalConfig.getTimeout();
    boolean isDisableCache;
    int maxRedirectCount = HttpGlobalConfig.getMaxRedirectCount();
    Proxy proxy;
    HostnameVerifier hostnameVerifier;
    SSLSocketFactory ssf;
    int blockSize;
    boolean ignoreEOFError = HttpGlobalConfig.isIgnoreEOFError();
    boolean decodeUrl = HttpGlobalConfig.isDecodeUrl();
    final HttpInterceptor.Chain<HttpRequest> requestInterceptors = GlobalInterceptor.INSTANCE.getCopiedRequestInterceptor();
    final HttpInterceptor.Chain<HttpResponse> responseInterceptors = GlobalInterceptor.INSTANCE.getCopiedResponseInterceptor();
    boolean interceptorOnRedirect;
    boolean followRedirectsCookie;

    public static HttpConfig create() {
        return new HttpConfig();
    }

    /*
     * WARNING - void declaration
     */
    public HttpConfig timeout(int milliseconds) {
        void var1_1;
        this.setConnectionTimeout(milliseconds);
        this.setReadTimeout((int)var1_1);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public HttpConfig setConnectionTimeout(int milliseconds) {
        void var1_1;
        this.connectionTimeout = var1_1;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public HttpConfig setReadTimeout(int milliseconds) {
        void var1_1;
        this.readTimeout = var1_1;
        return this;
    }

    public HttpConfig disableCache() {
        this.isDisableCache = true;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public HttpConfig setMaxRedirectCount(int maxRedirectCount) {
        void var1_1;
        this.maxRedirectCount = Math.max((int)var1_1, 0);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public HttpConfig setHostnameVerifier(HostnameVerifier hostnameVerifier) {
        void var1_1;
        this.hostnameVerifier = var1_1;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public HttpConfig setHttpProxy(String host, int port) {
        void var1_1;
        void var2_2;
        Proxy proxy = new Proxy(Proxy.Type.HTTP, new InetSocketAddress(host, (int)var2_2));
        return this.setProxy((Proxy)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public HttpConfig setProxy(Proxy proxy) {
        void var1_1;
        this.proxy = var1_1;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public HttpConfig setSSLSocketFactory(SSLSocketFactory ssf) {
        void var1_1;
        this.ssf = var1_1;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public HttpConfig setSSLProtocol(String protocol) {
        void var1_1;
        Assert.notBlank(protocol, "protocol must be not blank!", new Object[0]);
        this.setSSLSocketFactory(SSLUtil.createSSLContext((String)var1_1).getSocketFactory());
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public HttpConfig setBlockSize(int blockSize) {
        void var1_1;
        this.blockSize = var1_1;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public HttpConfig setIgnoreEOFError(boolean ignoreEOFError) {
        void var1_1;
        this.ignoreEOFError = var1_1;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public HttpConfig setDecodeUrl(boolean decodeUrl) {
        void var1_1;
        this.decodeUrl = var1_1;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public HttpConfig addRequestInterceptor(HttpInterceptor<HttpRequest> interceptor) {
        void var1_1;
        this.requestInterceptors.addChain((HttpInterceptor<HttpRequest>)var1_1);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public HttpConfig addResponseInterceptor(HttpInterceptor<HttpResponse> interceptor) {
        void var1_1;
        this.responseInterceptors.addChain((HttpInterceptor<HttpResponse>)var1_1);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public HttpConfig setInterceptorOnRedirect(boolean interceptorOnRedirect) {
        void var1_1;
        this.interceptorOnRedirect = var1_1;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public HttpConfig setFollowRedirectsCookie(boolean followRedirectsCookie) {
        void var1_1;
        this.followRedirectsCookie = var1_1;
        return this;
    }
}

