/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.http;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.io.resource.Resource;
import cn.hutool.core.map.CaseInsensitiveMap;
import cn.hutool.core.map.MapUtil;
import cn.hutool.core.map.MapWrapper;
import cn.hutool.core.util.CharsetUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.http.Header;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public abstract class HttpBase<T> {
    protected static final Charset DEFAULT_CHARSET = CharsetUtil.CHARSET_UTF_8;
    public static final String HTTP_1_0 = "HTTP/1.0";
    public static final String HTTP_1_1 = "HTTP/1.1";
    protected Map<String, List<String>> headers = new HashMap<String, List<String>>();
    protected Charset charset = DEFAULT_CHARSET;
    protected String httpVersion = "HTTP/1.1";
    protected Resource body;

    /*
     * WARNING - void declaration
     */
    public String header(String name) {
        void var1_1;
        List<String> values = this.headerList(name);
        if (CollectionUtil.isEmpty(values)) {
            return null;
        }
        return (String)var1_1.get(0);
    }

    /*
     * WARNING - void declaration
     */
    public List<String> headerList(String name) {
        void var1_1;
        if (StrUtil.isBlank(name)) {
            return null;
        }
        CaseInsensitiveMap<String, List<String>> caseInsensitiveMap = new CaseInsensitiveMap<String, List<String>>(this.headers);
        return (List)((MapWrapper)caseInsensitiveMap).get(var1_1.trim());
    }

    /*
     * WARNING - void declaration
     */
    public String header(Header name) {
        void var1_1;
        if (name == null) {
            return null;
        }
        return this.header(var1_1.toString());
    }

    /*
     * WARNING - void declaration
     */
    public T header(String name, String value, boolean isOverride) {
        if (name != null && value != null) {
            List<String> values = this.headers.get(name.trim());
            if (isOverride || CollectionUtil.isEmpty(values)) {
                void var3_4;
                void var1_1;
                ArrayList<String> valueList = new ArrayList<String>();
                valueList.add(value);
                this.headers.put(var1_1.trim(), (List<String>)var3_4);
            } else {
                void var2_2;
                values.add(var2_2.trim());
            }
        }
        return (T)this;
    }

    /*
     * WARNING - void declaration
     */
    public T header(Header name, String value, boolean isOverride) {
        void var3_3;
        void var2_2;
        void var1_1;
        return this.header(var1_1.toString(), (String)var2_2, (boolean)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    public T header(Header name, String value) {
        void var2_2;
        void var1_1;
        return this.header(var1_1.toString(), (String)var2_2, true);
    }

    /*
     * WARNING - void declaration
     */
    public T header(String name, String value) {
        void var2_2;
        void var1_1;
        return this.header((String)var1_1, (String)var2_2, true);
    }

    /*
     * WARNING - void declaration
     */
    public T headerMap(Map<String, String> headers, boolean isOverride) {
        Iterator iterator;
        if (MapUtil.isEmpty(headers)) {
            return (T)this;
        }
        for (Map.Entry entry : iterator.entrySet()) {
            void var3_3;
            this.header((String)entry.getKey(), StrUtil.nullToEmpty((CharSequence)var3_3.getValue()), isOverride);
        }
        return (T)this;
    }

    /*
     * WARNING - void declaration
     */
    public T header(Map<String, List<String>> headers) {
        void var1_1;
        return this.header((Map<String, List<String>>)var1_1, false);
    }

    public T header(Map<String, List<String>> headers, boolean isOverride) {
        if (MapUtil.isEmpty(headers)) {
            return (T)this;
        }
        for (Map.Entry<String, List<String>> entry : headers.entrySet()) {
            String name = entry.getKey();
            for (String value : entry.getValue()) {
                this.header(name, StrUtil.nullToEmpty(value), isOverride);
            }
        }
        return (T)this;
    }

    /*
     * WARNING - void declaration
     */
    public T addHeaders(Map<String, String> headers) {
        Iterator iterator;
        if (MapUtil.isEmpty(headers)) {
            return (T)this;
        }
        for (Map.Entry entry : iterator.entrySet()) {
            void var2_2;
            this.header((String)entry.getKey(), StrUtil.nullToEmpty((CharSequence)var2_2.getValue()), false);
        }
        return (T)this;
    }

    /*
     * WARNING - void declaration
     */
    public T removeHeader(String name) {
        if (name != null) {
            void var1_1;
            this.headers.remove(var1_1.trim());
        }
        return (T)this;
    }

    /*
     * WARNING - void declaration
     */
    public T removeHeader(Header name) {
        void var1_1;
        return this.removeHeader(var1_1.toString());
    }

    public Map<String, List<String>> headers() {
        return Collections.unmodifiableMap(this.headers);
    }

    public T clearHeaders() {
        this.headers.clear();
        return (T)this;
    }

    public String httpVersion() {
        return this.httpVersion;
    }

    /*
     * WARNING - void declaration
     */
    public T httpVersion(String httpVersion) {
        void var1_1;
        this.httpVersion = var1_1;
        return (T)this;
    }

    public byte[] bodyBytes() {
        if (this.body == null) {
            return null;
        }
        return this.body.readBytes();
    }

    public String charset() {
        return this.charset.name();
    }

    /*
     * WARNING - void declaration
     */
    public T charset(String charset) {
        if (StrUtil.isNotBlank(charset)) {
            void var1_1;
            this.charset(Charset.forName((String)var1_1));
        }
        return (T)this;
    }

    /*
     * WARNING - void declaration
     */
    public T charset(Charset charset) {
        if (charset != null) {
            void var1_1;
            this.charset = var1_1;
        }
        return (T)this;
    }

    /*
     * WARNING - void declaration
     */
    public String toString() {
        void var1_1;
        StringBuilder sb = StrUtil.builder();
        sb.append("Headers: \r\n");
        for (Map.Entry<String, List<String>> entry : this.headers.entrySet()) {
            void var3_3;
            sb.append("    ").append(entry.getKey()).append(": ").append(CollUtil.join((Iterable)var3_3.getValue(), (CharSequence)",")).append("\r\n");
        }
        sb.append("Body: \r\n");
        sb.append("    ").append(StrUtil.str(this.bodyBytes(), this.charset)).append("\r\n");
        return var1_1.toString();
    }
}

