/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.http;

import cn.hutool.core.util.EscapeUtil;
import cn.hutool.core.util.ReUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.http.HTMLFilter;

public class HtmlUtil {
    public static final String NBSP = "&nbsp;";
    public static final String AMP = "&amp;";
    public static final String QUOTE = "&quot;";
    public static final String APOS = "&apos;";
    public static final String LT = "&lt;";
    public static final String GT = "&gt;";
    public static final String RE_HTML_MARK = "(<[^<]*?>)|(<[\\s]*?/[^<]*?>)|(<[^<]*?/[\\s]*?>)";
    public static final String RE_SCRIPT = "<[\\s]*?script[^>]*?>.*?<[\\s]*?\\/[\\s]*?script[\\s]*?>";
    private static final char[][] TEXT = new char[256][];

    public static String escape(String text) {
        return HtmlUtil.encode(text);
    }

    public static String unescape(String htmlStr) {
        String string;
        if (StrUtil.isBlank(htmlStr)) {
            return htmlStr;
        }
        return EscapeUtil.unescapeHtml4(string);
    }

    public static String cleanHtmlTag(String content) {
        return content.replaceAll(RE_HTML_MARK, "");
    }

    /*
     * WARNING - void declaration
     */
    public static String removeHtmlTag(String content, String ... tagNames) {
        void var1_1;
        return HtmlUtil.removeHtmlTag(content, true, (String[])var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static String unwrapHtmlTag(String content, String ... tagNames) {
        void var1_1;
        return HtmlUtil.removeHtmlTag(content, false, (String[])var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static String removeHtmlTag(String content, boolean withTagContent, String ... tagNames) {
        String string;
        String[] stringArray = tagNames;
        int n = tagNames.length;
        for (int i = 0; i < n; ++i) {
            void var2_2;
            String regex;
            String tagName = stringArray[i];
            if (StrUtil.isBlank(tagName)) continue;
            tagName = tagName.trim();
            regex = withTagContent ? StrUtil.format("(?i)<{}(\\s+[^>]*?)?/?>(.*?</{}>)?", tagName, tagName) : StrUtil.format("(?i)<{}(\\s+[^>]*?)?/?>|</?{}>", regex, regex);
            content = ReUtil.delAll((String)var2_2, (CharSequence)content);
        }
        return string;
    }

    /*
     * WARNING - void declaration
     */
    public static String removeHtmlAttr(String content, String ... attrs) {
        String string;
        String[] stringArray = attrs;
        int n = attrs.length;
        for (int i = 0; i < n; ++i) {
            void var1_1;
            String attr = stringArray[i];
            String regex = StrUtil.format("(?i)(\\s*{}\\s*=\\s*)(([\"][^\"]+?[\"])|([^>]+?\\s*(?=\\s|>)))", attr);
            content = content.replaceAll((String)var1_1, "");
        }
        string = ReUtil.replaceAll((CharSequence)string, "\\s+(>|/>)", "$1");
        return string;
    }

    /*
     * WARNING - void declaration
     */
    public static String removeAllHtmlAttr(String content, String ... tagNames) {
        String string;
        String[] stringArray = tagNames;
        int n = tagNames.length;
        for (int i = 0; i < n; ++i) {
            void var1_1;
            String tagName = stringArray[i];
            String regex = StrUtil.format("(?i)<{}[^>]*?>", tagName);
            content = content.replaceAll((String)var1_1, StrUtil.format("<{}>", tagName));
        }
        return string;
    }

    /*
     * WARNING - void declaration
     */
    private static String encode(String text) {
        void var2_2;
        int len;
        if (text == null || (len = text.length()) == 0) {
            return "";
        }
        int n = len;
        StringBuilder buffer = new StringBuilder(n + (n >> 2));
        for (int i = 0; i < len; ++i) {
            void var3_4;
            char c = text.charAt(i);
            if (c < '\u0100') {
                buffer.append(TEXT[c]);
                continue;
            }
            buffer.append((char)var3_4);
        }
        return var2_2.toString();
    }

    public static String filter(String htmlContent) {
        String string;
        return new HTMLFilter().filter(string);
    }

    static {
        for (int i = 0; i < 256; ++i) {
            HtmlUtil.TEXT[i] = new char[]{(char)i};
        }
        HtmlUtil.TEXT[39] = "&#039;".toCharArray();
        HtmlUtil.TEXT[34] = QUOTE.toCharArray();
        HtmlUtil.TEXT[38] = AMP.toCharArray();
        HtmlUtil.TEXT[60] = LT.toCharArray();
        HtmlUtil.TEXT[62] = GT.toCharArray();
        HtmlUtil.TEXT[160] = NBSP.toCharArray();
    }
}

