/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.http;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.map.MapUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.http.Header;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public enum GlobalHeaders {
    INSTANCE;

    final Map<String, List<String>> headers = new HashMap<String, List<String>>();

    private GlobalHeaders() {
        this.putDefault(false);
    }

    /*
     * WARNING - void declaration
     */
    public final GlobalHeaders putDefault(boolean isReset) {
        void var1_1;
        System.setProperty("sun.net.http.allowRestrictedHeaders", "true");
        System.setProperty("jdk.tls.allowUnsafeServerCertChange", "true");
        System.setProperty("sun.security.ssl.allowUnsafeRenegotiation", "true");
        if (var1_1 != false) {
            this.headers.clear();
        }
        this.header(Header.ACCEPT, "text/html,application/json,application/xhtml+xml,application/xml;q=0.9,*/*;q=0.8", true);
        this.header(Header.ACCEPT_ENCODING, "gzip, deflate", true);
        this.header(Header.USER_AGENT, "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/75.0.3770.142 Safari/537.36 Hutool", true);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public final String header(String name) {
        void var1_1;
        List<String> values = this.headerList(name);
        if (CollectionUtil.isEmpty(values)) {
            return null;
        }
        return (String)var1_1.get(0);
    }

    /*
     * WARNING - void declaration
     */
    public final List<String> headerList(String name) {
        void var1_1;
        if (StrUtil.isBlank(name)) {
            return null;
        }
        return this.headers.get(var1_1.trim());
    }

    /*
     * WARNING - void declaration
     */
    public final String header(Header name) {
        void var1_1;
        if (name == null) {
            return null;
        }
        return this.header(var1_1.toString());
    }

    /*
     * WARNING - void declaration
     */
    public final synchronized GlobalHeaders header(String name, String value, boolean isOverride) {
        if (name != null && value != null) {
            List<String> values = this.headers.get(name.trim());
            if (isOverride || CollectionUtil.isEmpty(values)) {
                void var3_4;
                void var1_1;
                ArrayList<String> valueList = new ArrayList<String>();
                valueList.add(value);
                this.headers.put(var1_1.trim(), (List<String>)var3_4);
            } else {
                void var2_2;
                values.add(var2_2.trim());
            }
        }
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public final GlobalHeaders header(Header name, String value, boolean isOverride) {
        void var3_3;
        void var2_2;
        void var1_1;
        return this.header(var1_1.toString(), (String)var2_2, (boolean)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    public final GlobalHeaders header(Header name, String value) {
        void var2_2;
        void var1_1;
        return this.header(var1_1.toString(), (String)var2_2, true);
    }

    /*
     * WARNING - void declaration
     */
    public final GlobalHeaders header(String name, String value) {
        void var2_2;
        void var1_1;
        return this.header((String)var1_1, (String)var2_2, true);
    }

    public final GlobalHeaders header(Map<String, List<String>> headers) {
        if (MapUtil.isEmpty(headers)) {
            return this;
        }
        for (Map.Entry<String, List<String>> entry : headers.entrySet()) {
            Iterator iterator;
            String name = entry.getKey();
            for (String value : (List)iterator.getValue()) {
                this.header(name, StrUtil.nullToEmpty(value), false);
            }
        }
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public final synchronized GlobalHeaders removeHeader(String name) {
        if (name != null) {
            void var1_1;
            this.headers.remove(var1_1.trim());
        }
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public final GlobalHeaders removeHeader(Header name) {
        void var1_1;
        return this.removeHeader(var1_1.toString());
    }

    public final Map<String, List<String>> headers() {
        return Collections.unmodifiableMap(this.headers);
    }

    public final synchronized GlobalHeaders clearHeaders() {
        this.headers.clear();
        return this;
    }
}

