/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.http;

import cn.hutool.core.util.StrUtil;
import java.nio.charset.Charset;

public enum ContentType {
    FORM_URLENCODED("application/x-www-form-urlencoded"),
    MULTIPART("multipart/form-data"),
    JSON("application/json"),
    XML("application/xml"),
    TEXT_PLAIN("text/plain"),
    TEXT_XML("text/xml"),
    TEXT_HTML("text/html"),
    OCTET_STREAM("application/octet-stream"),
    EVENT_STREAM("text/event-stream");

    private final String value;

    /*
     * WARNING - void declaration
     */
    private ContentType(String value) {
        void var3_3;
        this.value = var3_3;
    }

    public final String getValue() {
        return this.value;
    }

    public final String toString() {
        return this.getValue();
    }

    /*
     * WARNING - void declaration
     */
    public final String toString(Charset charset) {
        void var1_1;
        return ContentType.build(this.value, (Charset)var1_1);
    }

    public static boolean isDefault(String contentType) {
        String string;
        return contentType == null || ContentType.isFormUrlEncode(string);
    }

    public static boolean isFormUrlEncode(String contentType) {
        return StrUtil.startWithIgnoreCase(contentType, FORM_URLENCODED.toString());
    }

    /*
     * WARNING - void declaration
     */
    public static ContentType get(String body) {
        void var1_2;
        ContentType contentType = null;
        if (StrUtil.isNotBlank(body)) {
            String string;
            char c = string.charAt(0);
            switch (c) {
                case '[': 
                case '{': {
                    contentType = JSON;
                    break;
                }
                case '<': {
                    contentType = XML;
                }
            }
        }
        return var1_2;
    }

    /*
     * WARNING - void declaration
     */
    public static String build(String contentType, Charset charset) {
        void var1_1;
        String string;
        return StrUtil.format("{};charset={}", string, var1_1.name());
    }

    /*
     * WARNING - void declaration
     */
    public static String build(ContentType contentType, Charset charset) {
        void var1_1;
        return ContentType.build(contentType.getValue(), (Charset)var1_1);
    }
}

