/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.extra.template.engine.wit;

import cn.hutool.core.io.FileUtil;
import cn.hutool.core.lang.Dict;
import cn.hutool.extra.template.Template;
import cn.hutool.extra.template.TemplateConfig;
import cn.hutool.extra.template.TemplateEngine;
import cn.hutool.extra.template.TemplateException;
import cn.hutool.extra.template.engine.wit.WitTemplate;
import java.io.File;
import java.io.Serializable;
import java.util.Map;
import org.febit.wit.Engine;
import org.febit.wit.exceptions.ResourceNotFoundException;
import org.febit.wit.util.Props;

public class WitEngine
implements TemplateEngine {
    private Engine engine;

    public WitEngine() {
    }

    /*
     * WARNING - void declaration
     */
    public WitEngine(TemplateConfig config) {
        void var1_1;
        this.init((TemplateConfig)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public WitEngine(Engine engine) {
        void var1_1;
        this.init((Engine)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public TemplateEngine init(TemplateConfig config) {
        void var1_1;
        this.init(WitEngine.createEngine((TemplateConfig)var1_1));
        return this;
    }

    /*
     * WARNING - void declaration
     */
    private void init(Engine engine) {
        void var1_1;
        this.engine = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Template getTemplate(String resource) {
        if (this.engine == null) {
            this.init(TemplateConfig.DEFAULT);
        }
        try {
            return WitTemplate.wrap(this.engine.getTemplate(resource));
        }
        catch (ResourceNotFoundException e) {
            void var1_2;
            throw new TemplateException((Throwable)var1_2);
        }
    }

    public Engine getRawEngine() {
        return this.engine;
    }

    /*
     * WARNING - void declaration
     */
    private static Engine createEngine(TemplateConfig config) {
        void var2_2;
        void var1_1;
        Props configProps = Engine.createConfigProps((String)"");
        Dict dict = null;
        if (config != null) {
            dict = Dict.create();
            dict.set("DEFAULT_ENCODING", config.getCharset());
            switch (config.getResourceMode()) {
                case CLASSPATH: {
                    configProps.set("pathLoader.root", config.getPath());
                    configProps.set("routeLoader.defaultLoader", "classpathLoader");
                    break;
                }
                case STRING: {
                    configProps.set("routeLoader.defaultLoader", "stringLoader");
                    break;
                }
                case FILE: {
                    configProps.set("pathLoader.root", config.getPath());
                    configProps.set("routeLoader.defaultLoader", "fileLoader");
                    break;
                }
                case WEB_ROOT: {
                    Serializable serializable;
                    Serializable root = FileUtil.file(FileUtil.getWebRoot(), config.getPath());
                    configProps.set("pathLoader.root", FileUtil.getAbsolutePath((File)serializable));
                    configProps.set("routeLoader.defaultLoader", "fileLoader");
                }
            }
        }
        return Engine.create((Props)var1_1, (Map)var2_2);
    }
}

