/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.extra.template.engine.thymeleaf;

import cn.hutool.core.io.FileUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.extra.template.Template;
import cn.hutool.extra.template.TemplateConfig;
import cn.hutool.extra.template.TemplateEngine;
import cn.hutool.extra.template.engine.thymeleaf.ThymeleafTemplate;
import org.thymeleaf.templatemode.TemplateMode;
import org.thymeleaf.templateresolver.ClassLoaderTemplateResolver;
import org.thymeleaf.templateresolver.DefaultTemplateResolver;
import org.thymeleaf.templateresolver.FileTemplateResolver;
import org.thymeleaf.templateresolver.ITemplateResolver;
import org.thymeleaf.templateresolver.StringTemplateResolver;

public class ThymeleafEngine
implements TemplateEngine {
    org.thymeleaf.TemplateEngine engine;
    TemplateConfig config;

    public ThymeleafEngine() {
    }

    /*
     * WARNING - void declaration
     */
    public ThymeleafEngine(TemplateConfig config) {
        void var1_1;
        this.init((TemplateConfig)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public ThymeleafEngine(org.thymeleaf.TemplateEngine engine) {
        void var1_1;
        this.init((org.thymeleaf.TemplateEngine)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public TemplateEngine init(TemplateConfig config) {
        void var1_1;
        if (config == null) {
            config = TemplateConfig.DEFAULT;
        }
        this.config = config;
        this.init(ThymeleafEngine.createEngine((TemplateConfig)var1_1));
        return this;
    }

    /*
     * WARNING - void declaration
     */
    private void init(org.thymeleaf.TemplateEngine engine) {
        void var1_1;
        this.engine = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Template getTemplate(String resource) {
        void var1_1;
        if (this.engine == null) {
            this.init(TemplateConfig.DEFAULT);
        }
        return ThymeleafTemplate.wrap(this.engine, (String)var1_1, this.config == null ? null : this.config.getCharset());
    }

    public org.thymeleaf.TemplateEngine getRawEngine() {
        return this.engine;
    }

    /*
     * WARNING - void declaration
     */
    private static org.thymeleaf.TemplateEngine createEngine(TemplateConfig config) {
        void var1_1;
        TemplateConfig templateConfig;
        if (config == null) {
            config = new TemplateConfig();
        }
        switch (config.getResourceMode()) {
            case CLASSPATH: {
                ClassLoaderTemplateResolver classLoaderResolver = new ClassLoaderTemplateResolver();
                classLoaderResolver.setCharacterEncoding(config.getCharsetStr());
                classLoaderResolver.setTemplateMode(TemplateMode.HTML);
                classLoaderResolver.setPrefix(StrUtil.addSuffixIfNot(config.getPath(), "/"));
                TemplateConfig resolver = classLoaderResolver;
                break;
            }
            case FILE: {
                TemplateConfig resolver;
                FileTemplateResolver fileResolver = new FileTemplateResolver();
                fileResolver.setCharacterEncoding(resolver.getCharsetStr());
                fileResolver.setTemplateMode(TemplateMode.HTML);
                fileResolver.setPrefix(StrUtil.addSuffixIfNot(resolver.getPath(), "/"));
                resolver = fileResolver;
                break;
            }
            case WEB_ROOT: {
                TemplateConfig resolver;
                FileTemplateResolver webRootResolver = new FileTemplateResolver();
                webRootResolver.setCharacterEncoding(resolver.getCharsetStr());
                webRootResolver.setTemplateMode(TemplateMode.HTML);
                webRootResolver.setPrefix(StrUtil.addSuffixIfNot(FileUtil.getAbsolutePath(FileUtil.file(FileUtil.getWebRoot(), resolver.getPath())), "/"));
                resolver = webRootResolver;
                break;
            }
            case STRING: {
                TemplateConfig resolver = new StringTemplateResolver();
                break;
            }
            default: {
                TemplateConfig resolver = new DefaultTemplateResolver();
            }
        }
        org.thymeleaf.TemplateEngine engine = new org.thymeleaf.TemplateEngine();
        engine.setTemplateResolver((ITemplateResolver)templateConfig);
        return var1_1;
    }
}

