/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.extra.template.engine.freemarker;

import cn.hutool.core.io.FileUtil;
import cn.hutool.core.io.IORuntimeException;
import cn.hutool.core.util.ClassUtil;
import cn.hutool.extra.template.Template;
import cn.hutool.extra.template.TemplateConfig;
import cn.hutool.extra.template.TemplateEngine;
import cn.hutool.extra.template.TemplateException;
import cn.hutool.extra.template.engine.freemarker.FreemarkerTemplate;
import cn.hutool.extra.template.engine.freemarker.SimpleStringTemplateLoader;
import freemarker.cache.ClassTemplateLoader;
import freemarker.cache.FileTemplateLoader;
import freemarker.cache.TemplateLoader;
import freemarker.template.Configuration;
import java.io.IOException;

public class FreemarkerEngine
implements TemplateEngine {
    private Configuration cfg;

    public FreemarkerEngine() {
    }

    /*
     * WARNING - void declaration
     */
    public FreemarkerEngine(TemplateConfig config) {
        void var1_1;
        this.init((TemplateConfig)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public FreemarkerEngine(Configuration freemarkerCfg) {
        void var1_1;
        this.init((Configuration)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public TemplateEngine init(TemplateConfig config) {
        void var1_1;
        if (config == null) {
            config = TemplateConfig.DEFAULT;
        }
        this.init(FreemarkerEngine.createCfg((TemplateConfig)var1_1));
        return this;
    }

    /*
     * WARNING - void declaration
     */
    private void init(Configuration freemarkerCfg) {
        void var1_1;
        this.cfg = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Template getTemplate(String resource) {
        if (this.cfg == null) {
            this.init(TemplateConfig.DEFAULT);
        }
        try {
            return FreemarkerTemplate.wrap(this.cfg.getTemplate(resource));
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
        catch (Exception e) {
            void var1_3;
            throw new TemplateException((Throwable)var1_3);
        }
    }

    public Configuration getConfiguration() {
        return this.cfg;
    }

    /*
     * WARNING - void declaration
     */
    private static Configuration createCfg(TemplateConfig config) {
        void var1_3;
        if (config == null) {
            config = new TemplateConfig();
        }
        Configuration cfg = new Configuration(Configuration.DEFAULT_INCOMPATIBLE_IMPROVEMENTS);
        cfg.setLocalizedLookup(false);
        cfg.setDefaultEncoding(config.getCharset().toString());
        switch (config.getResourceMode()) {
            case CLASSPATH: {
                cfg.setTemplateLoader((TemplateLoader)new ClassTemplateLoader(ClassUtil.getClassLoader(), config.getPath()));
                break;
            }
            case FILE: {
                try {
                    cfg.setTemplateLoader((TemplateLoader)new FileTemplateLoader(FileUtil.file(config.getPath())));
                    break;
                }
                catch (IOException e) {
                    throw new IORuntimeException(e);
                }
            }
            case WEB_ROOT: {
                try {
                    TemplateConfig e;
                    cfg.setTemplateLoader((TemplateLoader)new FileTemplateLoader(FileUtil.file(FileUtil.getWebRoot(), e.getPath())));
                    break;
                }
                catch (IOException e) {
                    void var0_2;
                    throw new IORuntimeException((Throwable)var0_2);
                }
            }
            case STRING: {
                cfg.setTemplateLoader((TemplateLoader)new SimpleStringTemplateLoader());
            }
        }
        return var1_3;
    }
}

