/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.extra.template.engine.enjoy;

import cn.hutool.core.io.FileUtil;
import cn.hutool.core.util.IdUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.extra.template.Template;
import cn.hutool.extra.template.TemplateConfig;
import cn.hutool.extra.template.TemplateEngine;
import cn.hutool.extra.template.engine.enjoy.EnjoyTemplate;
import com.jfinal.template.Engine;
import com.jfinal.template.source.FileSourceFactory;
import com.jfinal.template.source.ISourceFactory;
import java.io.File;
import java.io.Serializable;

public class EnjoyEngine
implements TemplateEngine {
    private Engine engine;
    private TemplateConfig.ResourceMode resourceMode;

    public EnjoyEngine() {
    }

    /*
     * WARNING - void declaration
     */
    public EnjoyEngine(TemplateConfig config) {
        void var1_1;
        this.init((TemplateConfig)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public EnjoyEngine(Engine engine) {
        void var1_1;
        this.init((Engine)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public TemplateEngine init(TemplateConfig config) {
        void var1_1;
        if (config == null) {
            config = TemplateConfig.DEFAULT;
        }
        this.resourceMode = config.getResourceMode();
        this.init(EnjoyEngine.createEngine((TemplateConfig)var1_1));
        return this;
    }

    /*
     * WARNING - void declaration
     */
    private void init(Engine engine) {
        void var1_1;
        this.engine = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Template getTemplate(String resource) {
        void var1_1;
        if (this.engine == null) {
            this.init(TemplateConfig.DEFAULT);
        }
        if (ObjectUtil.equal((Object)TemplateConfig.ResourceMode.STRING, (Object)this.resourceMode)) {
            return EnjoyTemplate.wrap(this.engine.getTemplateByString(resource));
        }
        return EnjoyTemplate.wrap(this.engine.getTemplate((String)var1_1));
    }

    public Engine getRawEngine() {
        return this.engine;
    }

    /*
     * WARNING - void declaration
     */
    private static Engine createEngine(TemplateConfig config) {
        void var1_1;
        Engine engine = Engine.create((String)("Hutool-Enjoy-Engine-" + IdUtil.fastSimpleUUID()));
        engine.setEncoding(config.getCharsetStr());
        switch (config.getResourceMode()) {
            case STRING: {
                break;
            }
            case CLASSPATH: {
                engine.setToClassPathSourceFactory();
                engine.setBaseTemplatePath(config.getPath());
                break;
            }
            case FILE: {
                engine.setSourceFactory((ISourceFactory)new FileSourceFactory());
                engine.setBaseTemplatePath(config.getPath());
                break;
            }
            case WEB_ROOT: {
                Serializable serializable;
                engine.setSourceFactory((ISourceFactory)new FileSourceFactory());
                Serializable root = FileUtil.file(FileUtil.getWebRoot(), config.getPath());
                engine.setBaseTemplatePath(FileUtil.getAbsolutePath((File)serializable));
            }
        }
        return var1_1;
    }
}

