/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.extra.ssh;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.io.IoUtil;
import cn.hutool.core.util.CharsetUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.extra.ftp.AbstractFtp;
import cn.hutool.extra.ftp.FtpConfig;
import cn.hutool.extra.ftp.FtpException;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.List;
import net.schmizz.sshj.SSHClient;
import net.schmizz.sshj.connection.channel.direct.Session;
import net.schmizz.sshj.sftp.RemoteResourceInfo;
import net.schmizz.sshj.sftp.SFTPClient;
import net.schmizz.sshj.transport.verification.HostKeyVerifier;
import net.schmizz.sshj.transport.verification.PromiscuousVerifier;
import net.schmizz.sshj.xfer.FileSystemFile;
import net.schmizz.sshj.xfer.LocalDestFile;
import net.schmizz.sshj.xfer.LocalSourceFile;

public class SshjSftp
extends AbstractFtp {
    private SSHClient ssh;
    private SFTPClient sftp;
    private Session session;

    /*
     * WARNING - void declaration
     */
    public SshjSftp(String sshHost) {
        this(new FtpConfig((String)var1_1, 22, null, null, DEFAULT_CHARSET));
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public SshjSftp(String sshHost, String sshUser, String sshPass) {
        this(new FtpConfig((String)var1_1, 22, (String)var2_2, (String)var3_3, CharsetUtil.CHARSET_UTF_8));
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public SshjSftp(String sshHost, int sshPort, String sshUser, String sshPass) {
        this(new FtpConfig((String)var1_1, (int)var2_2, (String)var3_3, sshPass, CharsetUtil.CHARSET_UTF_8));
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public SshjSftp(String sshHost, int sshPort, String sshUser, String sshPass, Charset charset) {
        this(new FtpConfig((String)var1_1, (int)var2_2, (String)var3_3, sshPass, charset));
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    protected SshjSftp(FtpConfig config) {
        super((FtpConfig)var1_1);
        void var1_1;
        this.init();
    }

    /*
     * WARNING - void declaration
     */
    public void init() {
        this.ssh = new SSHClient();
        this.ssh.addHostKeyVerifier((HostKeyVerifier)new PromiscuousVerifier());
        try {
            this.ssh.connect(this.ftpConfig.getHost(), this.ftpConfig.getPort());
            this.ssh.authPassword(this.ftpConfig.getUser(), this.ftpConfig.getPassword());
            this.ssh.setRemoteCharset(this.ftpConfig.getCharset());
            this.sftp = this.ssh.newSFTPClient();
            return;
        }
        catch (IOException e) {
            void var1_1;
            throw new FtpException("sftp \u521d\u59cb\u5316\u5931\u8d25.", (Throwable)var1_1);
        }
    }

    @Override
    public AbstractFtp reconnectIfTimeout() {
        if (StrUtil.isBlank(this.ftpConfig.getHost())) {
            throw new FtpException("Host is blank!");
        }
        try {
            ((AbstractFtp)this).cd("/");
        }
        catch (FtpException ftpException) {
            this.close();
            this.init();
        }
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean cd(String directory) {
        void var1_1;
        String string;
        String exec = String.format("cd %s", directory);
        this.command(string);
        string = ((AbstractFtp)this).pwd();
        return string.equals(var1_1);
    }

    @Override
    public String pwd() {
        return this.command("pwd");
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean mkdir(String dir) {
        void var1_1;
        try {
            this.sftp.mkdir(dir);
        }
        catch (IOException e) {
            void var1_2;
            throw new FtpException((Throwable)var1_2);
        }
        return this.containsFile((String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public List<String> ls(String path) {
        List infoList;
        try {
            infoList = this.sftp.ls(path);
        }
        catch (IOException e) {
            throw new FtpException(e);
        }
        if (CollUtil.isNotEmpty(infoList)) {
            void var1_1;
            return CollUtil.map(var1_1, RemoteResourceInfo::getName, true);
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean delFile(String path) {
        try {
            this.sftp.rm(path);
            return !this.containsFile(path);
        }
        catch (IOException e) {
            void var1_2;
            throw new FtpException((Throwable)var1_2);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean delDir(String dirPath) {
        try {
            this.sftp.rmdir(dirPath);
            return !this.containsFile(dirPath);
        }
        catch (IOException e) {
            void var1_2;
            throw new FtpException((Throwable)var1_2);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean upload(String destPath, File file) {
        try {
            void var2_3;
            this.sftp.put((LocalSourceFile)new FileSystemFile((File)var2_3), destPath);
            return this.containsFile(destPath);
        }
        catch (IOException e) {
            void var1_2;
            throw new FtpException((Throwable)var1_2);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void download(String path, File outFile) {
        try {
            void var2_3;
            this.sftp.get(path, (LocalDestFile)new FileSystemFile((File)var2_3));
            return;
        }
        catch (IOException e) {
            void var1_2;
            throw new FtpException((Throwable)var1_2);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void recursiveDownloadFolder(String sourcePath, File destDir) {
        List<String> files = ((AbstractFtp)this).ls(sourcePath);
        if (files != null && !files.isEmpty()) {
            void var2_2;
            void var1_1;
            void var3_3;
            var3_3.forEach(arg_0 -> this.lambda$recursiveDownloadFolder$0((String)var1_1, (File)var2_2, arg_0));
        }
    }

    @Override
    public void close() {
        IoUtil.close((Closeable)this.session);
        IoUtil.close((Closeable)this.sftp);
        IoUtil.close((Closeable)this.ssh);
    }

    /*
     * WARNING - void declaration
     */
    public boolean containsFile(String fileDir) {
        try {
            void var1_1;
            this.sftp.lstat((String)var1_1);
            return true;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    /*
     * WARNING - void declaration
     */
    public String command(String exec) {
        Session session = this.initSession();
        Session.Command command = null;
        try {
            void var2_4;
            command = var2_4.exec((String)exec);
            exec = command.getInputStream();
            exec = IoUtil.read((InputStream)exec, this.ftpConfig.getCharset());
        }
        catch (Exception e) {
            try {
                void var1_2;
                throw new FtpException((Throwable)var1_2);
            }
            catch (Throwable throwable) {
                void var3_5;
                IoUtil.close((Closeable)var3_5);
                throw throwable;
            }
        }
        IoUtil.close((Closeable)command);
        return exec;
    }

    /*
     * WARNING - void declaration
     */
    private Session initSession() {
        void var1_1;
        Session session = this.session;
        if (session == null || !session.isOpen()) {
            IoUtil.close((Closeable)session);
            try {
                session = this.ssh.startSession();
            }
            catch (Exception e) {
                void var1_2;
                throw new FtpException((Throwable)var1_2);
            }
            this.session = var1_1;
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void lambda$recursiveDownloadFolder$0(String sourcePath, File destDir, String path) {
        void var2_2;
        void var3_3;
        void var1_1;
        ((AbstractFtp)this).download((String)var1_1 + "/" + (String)var3_3, (File)var2_2);
    }
}

