/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.extra.ssh;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.collection.ListUtil;
import cn.hutool.core.io.FileUtil;
import cn.hutool.core.lang.Filter;
import cn.hutool.core.util.StrUtil;
import cn.hutool.extra.ftp.AbstractFtp;
import cn.hutool.extra.ftp.FtpConfig;
import cn.hutool.extra.ftp.FtpException;
import cn.hutool.extra.ssh.JschRuntimeException;
import cn.hutool.extra.ssh.JschUtil;
import com.jcraft.jsch.Channel;
import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.SftpATTRS;
import com.jcraft.jsch.SftpException;
import com.jcraft.jsch.SftpProgressMonitor;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;

public class Sftp
extends AbstractFtp {
    private Session session;
    private ChannelSftp channel;

    /*
     * WARNING - void declaration
     */
    public Sftp(String sshHost, int sshPort, String sshUser, String sshPass) {
        this((String)var1_1, (int)var2_2, (String)var3_3, sshPass, DEFAULT_CHARSET);
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public Sftp(String sshHost, int sshPort, String sshUser, String sshPass, Charset charset) {
        this(new FtpConfig((String)var1_1, (int)var2_2, (String)var3_3, sshPass, charset));
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public Sftp(FtpConfig config) {
        this((FtpConfig)var1_1, true);
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public Sftp(FtpConfig config, boolean init) {
        super(config);
        void var2_2;
        if (var2_2 != false) {
            void var1_1;
            this.init((FtpConfig)var1_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    public Sftp(Session session) {
        this((Session)var1_1, DEFAULT_CHARSET);
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public Sftp(Session session, Charset charset) {
        super(FtpConfig.create().setCharset(charset));
        void var2_2;
        void var1_1;
        this.init((Session)var1_1, (Charset)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public Sftp(Session session, Charset charset, long timeOut) {
        super(FtpConfig.create().setCharset(charset).setConnectionTimeout((long)var3_3));
        void var2_2;
        void var1_1;
        void var3_3;
        this.init((Session)var1_1, (Charset)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public Sftp(ChannelSftp channel, Charset charset, long timeOut) {
        super(FtpConfig.create().setCharset(charset).setConnectionTimeout((long)var3_3));
        void var2_2;
        void var1_1;
        void var3_3;
        this.init((ChannelSftp)var1_1, (Charset)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public Sftp(ChannelSftp channel, Charset charset) {
        super(FtpConfig.create().setCharset(charset));
        void var2_2;
        void var1_1;
        this.init((ChannelSftp)var1_1, (Charset)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public void init(String sshHost, int sshPort, String sshUser, String sshPass, Charset charset) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.init(JschUtil.getSession((String)var1_1, (int)var2_2, (String)var3_3, sshPass), charset);
    }

    public void init() {
        Sftp sftp = this;
        sftp.init(sftp.ftpConfig);
    }

    /*
     * WARNING - void declaration
     */
    public void init(FtpConfig config) {
        void var1_1;
        this.init(config.getHost(), config.getPort(), config.getUser(), config.getPassword(), var1_1.getCharset());
    }

    /*
     * WARNING - void declaration
     */
    public void init(Session session, Charset charset) {
        void var2_2;
        void var1_1;
        this.session = session;
        this.init(JschUtil.openSftp((Session)var1_1, (int)this.ftpConfig.getConnectionTimeout()), (Charset)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public void init(ChannelSftp channel, Charset charset) {
        void var1_1;
        this.ftpConfig.setCharset(charset);
        try {
            void var2_3;
            channel.setFilenameEncoding(var2_3.toString());
        }
        catch (SftpException e) {
            void var1_2;
            throw new JschRuntimeException((Throwable)var1_2);
        }
        this.channel = var1_1;
    }

    @Override
    public Sftp reconnectIfTimeout() {
        if (StrUtil.isBlank(this.ftpConfig.getHost())) {
            throw new FtpException("Host is blank!");
        }
        try {
            ((AbstractFtp)this).cd("/");
        }
        catch (FtpException ftpException) {
            this.close();
            this.init();
        }
        return this;
    }

    public ChannelSftp getClient() {
        if (!this.channel.isConnected()) {
            this.init();
        }
        return this.channel;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public String pwd() {
        try {
            return this.getClient().pwd();
        }
        catch (SftpException e) {
            void var1_1;
            throw new JschRuntimeException((Throwable)var1_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    public String home() {
        try {
            return this.getClient().getHome();
        }
        catch (SftpException e) {
            void var1_1;
            throw new JschRuntimeException((Throwable)var1_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public List<String> ls(String path) {
        void var1_1;
        return this.ls((String)var1_1, null);
    }

    /*
     * WARNING - void declaration
     */
    public List<String> lsDirs(String path) {
        void var1_1;
        return this.ls((String)var1_1, t -> t.getAttrs().isDir());
    }

    /*
     * WARNING - void declaration
     */
    public List<String> lsFiles(String path) {
        void var1_1;
        return this.ls((String)var1_1, t -> {
            ChannelSftp.LsEntry lsEntry;
            return false == lsEntry.getAttrs().isDir();
        });
    }

    /*
     * WARNING - void declaration
     */
    public List<String> ls(String path, Filter<ChannelSftp.LsEntry> filter) {
        void var1_1;
        void var2_2;
        List<ChannelSftp.LsEntry> entries = this.lsEntries(path, (Filter<ChannelSftp.LsEntry>)var2_2);
        if (CollUtil.isEmpty(entries)) {
            return ListUtil.empty();
        }
        return CollUtil.map(var1_1, ChannelSftp.LsEntry::getFilename, true);
    }

    /*
     * WARNING - void declaration
     */
    public List<ChannelSftp.LsEntry> lsEntries(String path) {
        void var1_1;
        return this.lsEntries((String)var1_1, null);
    }

    /*
     * WARNING - void declaration
     */
    public List<ChannelSftp.LsEntry> lsEntries(String path, Filter<ChannelSftp.LsEntry> filter) {
        void var3_4;
        block2: {
            ArrayList entryList = new ArrayList();
            try {
                void var2_3;
                this.getClient().ls(path, arg_0 -> Sftp.lambda$lsEntries$2((Filter)var2_3, entryList, arg_0));
            }
            catch (SftpException e) {
                void var1_2;
                if (StrUtil.startWithIgnoreCase(e.getMessage(), "No such file")) break block2;
                throw new JschRuntimeException((Throwable)var1_2);
            }
        }
        return var3_4;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean mkdir(String dir) {
        if (((AbstractFtp)this).isDir(dir)) {
            return true;
        }
        try {
            this.getClient().mkdir(dir);
            return true;
        }
        catch (SftpException e) {
            void var1_2;
            throw new JschRuntimeException((Throwable)var1_2);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean isDir(String dir) {
        void var1_1;
        try {
            SftpATTRS sftpATTRS = this.getClient().stat(dir);
        }
        catch (SftpException sftpException) {
            SftpException e = sftpException;
            String string = sftpException.getMessage();
            if (StrUtil.containsAnyIgnoreCase(string, "No such file", "does not exist")) {
                return false;
            }
            throw new FtpException(e);
        }
        return var1_1.isDir();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public synchronized boolean cd(String directory) throws FtpException {
        if (StrUtil.isBlank(directory)) {
            return true;
        }
        try {
            this.getClient().cd(directory.replace('\\', '/'));
            return true;
        }
        catch (SftpException e) {
            void var1_2;
            throw new FtpException((Throwable)var1_2);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean delFile(String filePath) {
        try {
            this.getClient().rm(filePath);
        }
        catch (SftpException e) {
            void var1_2;
            throw new JschRuntimeException((Throwable)var1_2);
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean delDir(String dirPath) {
        Vector list;
        if (!((AbstractFtp)this).cd(dirPath)) {
            return false;
        }
        ChannelSftp channel = this.getClient();
        try {
            ChannelSftp channelSftp = channel;
            list = channelSftp.ls(channelSftp.pwd());
        }
        catch (SftpException e) {
            throw new JschRuntimeException(e);
        }
        for (ChannelSftp.LsEntry entry : list) {
            void var3_3;
            String fileName = entry.getFilename();
            if (".".equals(fileName) || "..".equals(fileName)) continue;
            if (entry.getAttrs().isDir()) {
                ((AbstractFtp)this).delDir(fileName);
                continue;
            }
            ((AbstractFtp)this).delFile((String)var3_3);
        }
        if (!((AbstractFtp)this).cd("..")) {
            return false;
        }
        try {
            void var1_1;
            void var2_2;
            var2_2.rmdir((String)var1_1);
            return true;
        }
        catch (SftpException e) {
            throw new JschRuntimeException(e);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void syncUpload(File file, String remotePath) {
        void var2_2;
        void var1_1;
        if (!FileUtil.exist(file)) {
            return;
        }
        if (file.isDirectory()) {
            File[] files = file.listFiles();
            if (files == null) {
                return;
            }
            for (void fileItem : var1_1) {
                if (fileItem.isDirectory()) {
                    String mkdir = FileUtil.normalize(remotePath + "/" + fileItem.getName());
                    this.syncUpload((File)fileItem, mkdir);
                    continue;
                }
                this.syncUpload((File)fileItem, remotePath);
            }
            return;
        }
        this.mkDirs(remotePath);
        ((AbstractFtp)this).upload((String)var2_2, (File)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean upload(String destPath, File file) {
        void var1_1;
        void var2_2;
        this.put(FileUtil.getAbsolutePath((File)var2_2), (String)var1_1);
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public boolean upload(String destPath, String fileName, InputStream fileStream) {
        void var1_1;
        void var3_3;
        void var2_2;
        destPath = StrUtil.addSuffixIfNot(destPath, "/") + StrUtil.removePrefix((CharSequence)var2_2, "/");
        this.put((InputStream)var3_3, (String)var1_1, null, Mode.OVERWRITE);
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public Sftp put(String srcFilePath, String destPath) {
        void var2_2;
        void var1_1;
        return this.put((String)var1_1, (String)var2_2, Mode.OVERWRITE);
    }

    /*
     * WARNING - void declaration
     */
    public Sftp put(String srcFilePath, String destPath, Mode mode) {
        void var3_3;
        void var2_2;
        void var1_1;
        return this.put((String)var1_1, (String)var2_2, null, (Mode)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    public Sftp put(String srcFilePath, String destPath, SftpProgressMonitor monitor, Mode mode) {
        try {
            void var3_4;
            void var2_3;
            this.getClient().put(srcFilePath, (String)var2_3, (SftpProgressMonitor)var3_4, mode.ordinal());
        }
        catch (SftpException e) {
            void var1_2;
            throw new JschRuntimeException((Throwable)var1_2);
        }
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public Sftp put(InputStream srcStream, String destPath, SftpProgressMonitor monitor, Mode mode) {
        try {
            void var3_4;
            void var2_3;
            this.getClient().put(srcStream, (String)var2_3, (SftpProgressMonitor)var3_4, mode.ordinal());
        }
        catch (SftpException e) {
            void var1_2;
            throw new JschRuntimeException((Throwable)var1_2);
        }
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void download(String src, File destFile) {
        void var2_2;
        void var1_1;
        this.get((String)var1_1, FileUtil.getAbsolutePath((File)var2_2));
    }

    /*
     * WARNING - void declaration
     */
    public void download(String src, OutputStream out) {
        void var2_2;
        void var1_1;
        this.get((String)var1_1, (OutputStream)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void recursiveDownloadFolder(String sourcePath, File destDir) throws JschRuntimeException {
        for (ChannelSftp.LsEntry item : this.lsEntries(sourcePath)) {
            void var3_4;
            String fileName = item.getFilename();
            String srcFile = StrUtil.format("{}/{}", sourcePath, fileName);
            File destFile = FileUtil.file(destDir, fileName);
            if (!item.getAttrs().isDir()) {
                if (FileUtil.exist(destFile) && (long)item.getAttrs().getMTime() <= destFile.lastModified() / 1000L) continue;
                ((AbstractFtp)this).download(srcFile, destFile);
                continue;
            }
            FileUtil.mkdir(destFile);
            ((AbstractFtp)this).recursiveDownloadFolder(srcFile, (File)var3_4);
        }
    }

    /*
     * WARNING - void declaration
     */
    public Sftp get(String src, String dest) {
        try {
            void var2_3;
            this.getClient().get(src, (String)var2_3);
        }
        catch (SftpException e) {
            void var1_2;
            throw new JschRuntimeException((Throwable)var1_2);
        }
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public Sftp get(String src, OutputStream out) {
        try {
            void var2_3;
            this.getClient().get(src, (OutputStream)var2_3);
        }
        catch (SftpException e) {
            void var1_2;
            throw new JschRuntimeException((Throwable)var1_2);
        }
        return this;
    }

    @Override
    public void close() {
        JschUtil.close((Channel)this.channel);
        JschUtil.close(this.session);
    }

    public String toString() {
        return "Sftp{host='" + this.ftpConfig.getHost() + '\'' + ", port=" + this.ftpConfig.getPort() + ", user='" + this.ftpConfig.getUser() + '\'' + '}';
    }

    /*
     * WARNING - void declaration
     */
    private static /* synthetic */ int lambda$lsEntries$2(Filter filter, List entryList, ChannelSftp.LsEntry entry) {
        Filter filter2;
        void var3_3;
        String fileName = entry.getFilename();
        if (!(StrUtil.equals(".", fileName) || StrUtil.equals("..", (CharSequence)var3_3) || filter != null && !filter2.accept(entry))) {
            void var2_2;
            void var1_1;
            var1_1.add(var2_2);
        }
        return 0;
    }

    public static enum Mode {
        OVERWRITE,
        RESUME,
        APPEND;

    }
}

