/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.extra.ssh;

import cn.hutool.core.io.IORuntimeException;
import cn.hutool.core.io.IoUtil;
import cn.hutool.core.lang.Assert;
import cn.hutool.core.net.LocalPortGenerater;
import cn.hutool.core.util.CharsetUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.extra.ssh.ChannelType;
import cn.hutool.extra.ssh.Connector;
import cn.hutool.extra.ssh.JschRuntimeException;
import cn.hutool.extra.ssh.JschSessionPool;
import cn.hutool.extra.ssh.Sftp;
import com.jcraft.jsch.Channel;
import com.jcraft.jsch.ChannelExec;
import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.ChannelShell;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;

public class JschUtil {
    public static final String SSH_NONE = "none";
    private static final LocalPortGenerater portGenerater = new LocalPortGenerater(10000);

    public static int generateLocalPort() {
        return portGenerater.generate();
    }

    /*
     * WARNING - void declaration
     */
    public static Session getSession(String sshHost, int sshPort, String sshUser, String sshPass) {
        void var3_3;
        void var2_2;
        void var1_1;
        String string;
        return JschSessionPool.INSTANCE.getSession(string, (int)var1_1, (String)var2_2, (String)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    public static Session getSession(String sshHost, int sshPort, String sshUser, String privateKeyPath, byte[] passphrase) {
        void var3_3;
        void var2_2;
        void var1_1;
        String string;
        return JschSessionPool.INSTANCE.getSession(string, (int)var1_1, (String)var2_2, (String)var3_3, passphrase);
    }

    /*
     * WARNING - void declaration
     */
    public static Session getSession(String sshHost, int sshPort, String sshUser, byte[] privateKey, byte[] passphrase) {
        void var3_3;
        void var2_2;
        void var1_1;
        String string;
        return JschSessionPool.INSTANCE.getSession(string, (int)var1_1, (String)var2_2, (byte[])var3_3, passphrase);
    }

    /*
     * WARNING - void declaration
     */
    public static Session openSession(String sshHost, int sshPort, String sshUser, String sshPass) {
        void var3_3;
        void var2_2;
        void var1_1;
        return JschUtil.openSession(sshHost, (int)var1_1, (String)var2_2, (String)var3_3, 0);
    }

    /*
     * WARNING - void declaration
     */
    public static Session openSession(String sshHost, int sshPort, String sshUser, String sshPass, int timeout) {
        String string;
        void var3_4;
        void var2_3;
        void var1_2;
        String session = JschUtil.createSession(sshHost, (int)var1_2, (String)var2_3, (String)var3_4);
        try {
            session.connect(timeout);
        }
        catch (JSchException e) {
            void var0_1;
            throw new JschRuntimeException((Throwable)var0_1);
        }
        return string;
    }

    /*
     * WARNING - void declaration
     */
    public static Session openSession(String sshHost, int sshPort, String sshUser, String privateKeyPath, byte[] passphrase) {
        void var3_3;
        void var2_2;
        void var1_1;
        return JschUtil.openSession(sshHost, (int)var1_1, (String)var2_2, (String)var3_3, passphrase, 0);
    }

    /*
     * WARNING - void declaration
     */
    public static Session openSession(String sshHost, int sshPort, String sshUser, byte[] privateKey, byte[] passphrase) {
        void var3_3;
        void var2_2;
        void var1_1;
        return JschUtil.openSession(sshHost, (int)var1_1, (String)var2_2, (byte[])var3_3, passphrase, 0);
    }

    /*
     * WARNING - void declaration
     */
    public static Session openSession(String sshHost, int sshPort, String sshUser, byte[] privateKey, byte[] passphrase, int timeOut) {
        String string;
        void var3_4;
        void var2_3;
        void var1_2;
        String session = JschUtil.createSession(sshHost, (int)var1_2, (String)var2_3, (byte[])var3_4, passphrase);
        try {
            session.connect(timeOut);
        }
        catch (JSchException e) {
            void var0_1;
            throw new JschRuntimeException((Throwable)var0_1);
        }
        return string;
    }

    /*
     * WARNING - void declaration
     */
    public static Session openSession(String sshHost, int sshPort, String sshUser, String privateKeyPath, byte[] passphrase, int timeOut) {
        String string;
        void var3_4;
        void var2_3;
        void var1_2;
        String session = JschUtil.createSession(sshHost, (int)var1_2, (String)var2_3, (String)var3_4, passphrase);
        try {
            session.connect(timeOut);
        }
        catch (JSchException e) {
            void var0_1;
            throw new JschRuntimeException((Throwable)var0_1);
        }
        return string;
    }

    /*
     * WARNING - void declaration
     */
    public static Session createSession(String sshHost, int sshPort, String sshUser, String sshPass) {
        String string;
        void var2_2;
        void var1_1;
        JSch jSch = new JSch();
        String session = JschUtil.createSession(jSch, sshHost, (int)var1_1, (String)var2_2);
        if (StrUtil.isNotEmpty(sshPass)) {
            void var3_3;
            session.setPassword((String)var3_3);
        }
        return string;
    }

    /*
     * WARNING - void declaration
     */
    public static Session createSession(String sshHost, int sshPort, String sshUser, String privateKeyPath, byte[] passphrase) {
        void var2_3;
        void var1_2;
        String string;
        Assert.notEmpty(privateKeyPath, "PrivateKey Path must be not empty!", new Object[0]);
        JSch jsch = new JSch();
        try {
            void var3_4;
            jsch.addIdentity((String)var3_4, passphrase);
        }
        catch (JSchException e) {
            void var0_1;
            throw new JschRuntimeException((Throwable)var0_1);
        }
        return JschUtil.createSession(jsch, string, (int)var1_2, (String)var2_3);
    }

    /*
     * WARNING - void declaration
     */
    public static Session createSession(String sshHost, int sshPort, String sshUser, byte[] privateKey, byte[] passphrase) {
        void var2_3;
        void var1_2;
        String string;
        Assert.isTrue(privateKey != null && privateKey.length > 0, "PrivateKey must be not empty!", new Object[0]);
        JSch jsch = new JSch();
        String identityName = StrUtil.format("{}@{}:{}", sshUser, sshHost, sshPort);
        try {
            void var3_4;
            jsch.addIdentity(identityName, (byte[])var3_4, null, passphrase);
        }
        catch (JSchException e) {
            void var0_1;
            throw new JschRuntimeException((Throwable)var0_1);
        }
        return JschUtil.createSession(jsch, string, (int)var1_2, (String)var2_3);
    }

    /*
     * WARNING - void declaration
     */
    public static Session createSession(JSch jsch, String sshHost, int sshPort, String sshUser) {
        JSch jSch;
        JSch session;
        Assert.notEmpty(sshHost, "SSH Host must be not empty!", new Object[0]);
        Assert.isTrue(sshPort > 0, "SSH port must be > 0", new Object[0]);
        if (StrUtil.isEmpty(sshUser)) {
            sshUser = "root";
        }
        if (jsch == null) {
            jsch = new JSch();
        }
        try {
            void var2_3;
            void var1_2;
            void var3_4;
            session = jsch.getSession((String)var3_4, (String)var1_2, (int)var2_3);
        }
        catch (JSchException e) {
            throw new JschRuntimeException(e);
        }
        session.setConfig("StrictHostKeyChecking", "no");
        return jSch;
    }

    /*
     * WARNING - void declaration
     */
    public static boolean bindPort(Session session, String remoteHost, int remotePort, int localPort) throws JschRuntimeException {
        void var3_3;
        void var2_2;
        void var1_1;
        return JschUtil.bindPort(session, (String)var1_1, (int)var2_2, "127.0.0.1", (int)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    public static boolean bindPort(Session session, String remoteHost, int remotePort, String localHost, int localPort) throws JschRuntimeException {
        if (session != null && session.isConnected()) {
            try {
                session.setPortForwardingL(localHost, localPort, remoteHost, remotePort);
            }
            catch (JSchException e) {
                void var3_4;
                void var2_3;
                void var1_2;
                void var0_1;
                throw new JschRuntimeException((Throwable)var0_1, "From [{}:{}] mapping to [{}:{}] error\uff01", var1_2, (int)var2_3, var3_4, localPort);
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public static boolean bindRemotePort(Session session, int bindPort, String host, int port) throws JschRuntimeException {
        if (session != null && session.isConnected()) {
            try {
                void var2_3;
                session.setPortForwardingR(bindPort, (String)var2_3, port);
            }
            catch (JSchException e) {
                void var3_4;
                void var1_2;
                void var0_1;
                throw new JschRuntimeException((Throwable)var0_1, "From [{}] mapping to [{}] error\uff01", (int)var1_2, (int)var3_4);
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public static boolean unBindPort(Session session, int localPort) {
        try {
            void var1_2;
            session.delPortForwardingL((int)var1_2);
        }
        catch (JSchException e) {
            void var0_1;
            throw new JschRuntimeException((Throwable)var0_1);
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public static int openAndBindPortToLocal(Connector sshConn, String remoteHost, int remotePort) throws JschRuntimeException {
        void var3_3;
        void var2_2;
        void var1_1;
        Connector connector;
        Connector session = JschUtil.openSession(sshConn.getHost(), sshConn.getPort(), sshConn.getUser(), sshConn.getPassword());
        int localPort = JschUtil.generateLocalPort();
        JschUtil.bindPort((Session)connector, (String)var1_1, (int)var2_2, localPort);
        return (int)var3_3;
    }

    public static ChannelSftp openSftp(Session session) {
        return JschUtil.openSftp(session, 0);
    }

    /*
     * WARNING - void declaration
     */
    public static ChannelSftp openSftp(Session session, int timeout) {
        void var1_1;
        return (ChannelSftp)JschUtil.openChannel(session, ChannelType.SFTP, (int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static Sftp createSftp(String sshHost, int sshPort, String sshUser, String sshPass) {
        void var3_3;
        void var2_2;
        void var1_1;
        String string;
        return new Sftp(string, (int)var1_1, (String)var2_2, (String)var3_3);
    }

    public static Sftp createSftp(Session session) {
        Session session2;
        return new Sftp(session2);
    }

    public static ChannelShell openShell(Session session) {
        return (ChannelShell)JschUtil.openChannel(session, ChannelType.SHELL);
    }

    /*
     * WARNING - void declaration
     */
    public static Channel openChannel(Session session, ChannelType channelType) {
        void var1_1;
        return JschUtil.openChannel(session, (ChannelType)var1_1, 0);
    }

    /*
     * WARNING - void declaration
     */
    public static Channel openChannel(Session session, ChannelType channelType, int timeout) {
        Session session2;
        void var1_2;
        Session channel = JschUtil.createChannel(session, (ChannelType)var1_2);
        try {
            void var2_3;
            channel.connect(Math.max((int)var2_3, 0));
        }
        catch (JSchException e) {
            void var0_1;
            throw new JschRuntimeException((Throwable)var0_1);
        }
        return session2;
    }

    /*
     * WARNING - void declaration
     */
    public static Channel createChannel(Session session, ChannelType channelType) {
        Session session2;
        try {
            void var1_2;
            if (!session.isConnected()) {
                session.connect();
            }
            Session channel = session.openChannel(var1_2.getValue());
        }
        catch (JSchException e) {
            throw new JschRuntimeException(e);
        }
        return session2;
    }

    /*
     * WARNING - void declaration
     */
    public static String exec(Session session, String cmd, Charset charset) {
        void var2_2;
        void var1_1;
        return JschUtil.exec(session, (String)var1_1, (Charset)var2_2, System.err);
    }

    /*
     * Loose catch block
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String exec(Session session, String cmd, Charset charset, OutputStream errStream) {
        void var3_6;
        if (charset == null) {
            charset = CharsetUtil.CHARSET_UTF_8;
        }
        Session channel = (ChannelExec)JschUtil.createChannel(session, ChannelType.EXEC);
        channel.setCommand(StrUtil.bytes((CharSequence)cmd, (Charset)charset));
        channel.setInputStream(null);
        channel.setErrStream((OutputStream)var3_6);
        InputStream in = null;
        try {
            channel.connect();
            in = channel.getInputStream();
            charset = IoUtil.read(in, (Charset)charset);
        }
        catch (IOException e) {
            try {
                throw new IORuntimeException(e);
                catch (JSchException e2) {
                    void var2_4;
                    throw new JschRuntimeException((Throwable)var2_4);
                }
            }
            catch (Throwable throwable) {
                Session session2;
                void var1_1;
                IoUtil.close((Closeable)var1_1);
                JschUtil.close((Channel)session2);
                throw throwable;
            }
        }
        IoUtil.close(in);
        JschUtil.close((Channel)channel);
        return charset;
    }

    /*
     * WARNING - void declaration
     */
    public static String execByShell(Session session, String cmd, Charset charset) {
        Session shell = JschUtil.openShell(session);
        shell.setPty(true);
        OutputStream out = null;
        InputStream in = null;
        try {
            void var2_4;
            out = shell.getOutputStream();
            in = shell.getInputStream();
            out.write(StrUtil.bytes((CharSequence)cmd, charset));
            out.flush();
            cmd = IoUtil.read(in, (Charset)var2_4);
        }
        catch (IOException e) {
            try {
                void var1_2;
                throw new IORuntimeException((Throwable)var1_2);
            }
            catch (Throwable throwable) {
                Session session2;
                void var3_5;
                IoUtil.close((Closeable)var3_5);
                IoUtil.close(in);
                JschUtil.close((Channel)session2);
                throw throwable;
            }
        }
        IoUtil.close(out);
        IoUtil.close(in);
        JschUtil.close((Channel)shell);
        return cmd;
    }

    public static void close(Session session) {
        Session session2;
        if (session != null && session.isConnected()) {
            session.disconnect();
        }
        JschSessionPool.INSTANCE.remove(session2);
    }

    public static void close(Channel channel) {
        if (channel != null && channel.isConnected()) {
            Channel channel2;
            channel2.disconnect();
        }
    }

    public static void close(String key) {
        String string;
        JschSessionPool.INSTANCE.close(string);
    }

    public static void closeAll() {
        JschSessionPool.INSTANCE.closeAll();
    }
}

