/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.extra.spring;

import cn.hutool.core.exceptions.UtilException;
import cn.hutool.core.lang.TypeReference;
import cn.hutool.core.util.ArrayUtil;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Map;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.DefaultSingletonBeanRegistry;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.ResolvableType;
import org.springframework.stereotype.Component;

@Component
public class SpringUtil
implements BeanFactoryPostProcessor,
ApplicationContextAware {
    private static ConfigurableListableBeanFactory beanFactory;
    private static ApplicationContext applicationContext;

    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
        SpringUtil.beanFactory = beanFactory;
    }

    public void setApplicationContext(ApplicationContext applicationContext) {
        SpringUtil.applicationContext = applicationContext;
    }

    public static ApplicationContext getApplicationContext() {
        return applicationContext;
    }

    /*
     * WARNING - void declaration
     */
    public static ListableBeanFactory getBeanFactory() {
        void var0;
        ApplicationContext factory;
        Object object = factory = beanFactory == null ? applicationContext : beanFactory;
        if (factory == null) {
            throw new UtilException("No ConfigurableListableBeanFactory or ApplicationContext injected, maybe not in the Spring environment?");
        }
        return var0;
    }

    /*
     * WARNING - void declaration
     */
    public static ConfigurableListableBeanFactory getConfigurableBeanFactory() throws UtilException {
        void var0;
        ConfigurableListableBeanFactory factory;
        if (beanFactory != null) {
            factory = beanFactory;
        } else if (applicationContext instanceof ConfigurableApplicationContext) {
            factory = ((ConfigurableApplicationContext)applicationContext).getBeanFactory();
        } else {
            throw new UtilException("No ConfigurableListableBeanFactory from context!");
        }
        return var0;
    }

    public static <T> T getBean(String name) {
        String string;
        return (T)SpringUtil.getBeanFactory().getBean(string);
    }

    public static <T> T getBean(Class<T> clazz) {
        Class<T> clazz2;
        return (T)SpringUtil.getBeanFactory().getBean(clazz2);
    }

    /*
     * WARNING - void declaration
     */
    public static <T> T getBean(String name, Class<T> clazz) {
        void var1_1;
        String string;
        return (T)SpringUtil.getBeanFactory().getBean(string, (Class)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static <T> T getBean(TypeReference<T> reference) {
        void var1_1;
        Type type2;
        Type parameterizedType = (ParameterizedType)reference.getType();
        Class rawType = (Class)parameterizedType.getRawType();
        Type genericTypes = (Class[])Arrays.stream(parameterizedType.getActualTypeArguments()).map(type -> (Class)type).toArray(Class[]::new);
        type2 = SpringUtil.getBeanFactory().getBeanNamesForType(ResolvableType.forClassWithGenerics((Class)rawType, (Class[])type2));
        return SpringUtil.getBean(type2[0], var1_1);
    }

    public static <T> Map<String, T> getBeansOfType(Class<T> type) {
        Class<T> clazz;
        return SpringUtil.getBeanFactory().getBeansOfType(clazz);
    }

    public static String[] getBeanNamesForType(Class<?> type) {
        Class<?> clazz;
        return SpringUtil.getBeanFactory().getBeanNamesForType(clazz);
    }

    public static String getProperty(String key) {
        String string;
        if (applicationContext == null) {
            return null;
        }
        return applicationContext.getEnvironment().getProperty(string);
    }

    /*
     * WARNING - void declaration
     */
    public static String getProperty(String key, String defaultValue) {
        void var1_1;
        String string;
        if (applicationContext == null) {
            return null;
        }
        return applicationContext.getEnvironment().getProperty(string, (String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static <T> T getProperty(String key, Class<T> targetType, T defaultValue) {
        void var2_2;
        void var1_1;
        String string;
        if (applicationContext == null) {
            return null;
        }
        return (T)applicationContext.getEnvironment().getProperty(string, (Class)var1_1, (Object)var2_2);
    }

    public static String getApplicationName() {
        return SpringUtil.getProperty("spring.application.name");
    }

    public static String[] getActiveProfiles() {
        if (applicationContext == null) {
            return null;
        }
        return applicationContext.getEnvironment().getActiveProfiles();
    }

    /*
     * WARNING - void declaration
     */
    public static String getActiveProfile() {
        String[] activeProfiles = SpringUtil.getActiveProfiles();
        if (ArrayUtil.isNotEmpty(activeProfiles)) {
            void var0;
            return var0[0];
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public static <T> void registerBean(String beanName, T bean) {
        void var1_1;
        String string;
        void var2_2;
        ConfigurableListableBeanFactory factory = SpringUtil.getConfigurableBeanFactory();
        factory.autowireBean(bean);
        var2_2.registerSingleton(string, (Object)var1_1);
    }

    public static void unregisterBean(String beanName) {
        ConfigurableListableBeanFactory factory = SpringUtil.getConfigurableBeanFactory();
        if (factory instanceof DefaultSingletonBeanRegistry) {
            String string;
            DefaultSingletonBeanRegistry defaultSingletonBeanRegistry;
            defaultSingletonBeanRegistry = defaultSingletonBeanRegistry;
            defaultSingletonBeanRegistry.destroySingleton(string);
            return;
        }
        throw new UtilException("Can not unregister bean, the factory is not a DefaultSingletonBeanRegistry!");
    }

    public static void publishEvent(ApplicationEvent event) {
        if (applicationContext != null) {
            ApplicationEvent applicationEvent;
            applicationContext.publishEvent(applicationEvent);
        }
    }

    public static void publishEvent(Object event) {
        if (applicationContext != null) {
            Object object;
            applicationContext.publishEvent(object);
        }
    }
}

