/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.extra.servlet;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.copier.CopyOptions;
import cn.hutool.core.bean.copier.ValueProvider;
import cn.hutool.core.collection.ArrayIter;
import cn.hutool.core.collection.IterUtil;
import cn.hutool.core.collection.ListUtil;
import cn.hutool.core.exceptions.UtilException;
import cn.hutool.core.io.FileUtil;
import cn.hutool.core.io.IORuntimeException;
import cn.hutool.core.io.IoUtil;
import cn.hutool.core.map.CaseInsensitiveMap;
import cn.hutool.core.map.MapUtil;
import cn.hutool.core.net.NetUtil;
import cn.hutool.core.net.multipart.MultipartFormData;
import cn.hutool.core.net.multipart.UploadSetting;
import cn.hutool.core.util.ArrayUtil;
import cn.hutool.core.util.CharsetUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.ReflectUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.core.util.URLUtil;
import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.http.Cookie;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.lang.reflect.Type;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class JakartaServletUtil {
    public static final String METHOD_DELETE = "DELETE";
    public static final String METHOD_HEAD = "HEAD";
    public static final String METHOD_GET = "GET";
    public static final String METHOD_OPTIONS = "OPTIONS";
    public static final String METHOD_POST = "POST";
    public static final String METHOD_PUT = "PUT";
    public static final String METHOD_TRACE = "TRACE";

    public static Map<String, String[]> getParams(ServletRequest request) {
        Object object = request.getParameterMap();
        return Collections.unmodifiableMap(object);
    }

    /*
     * WARNING - void declaration
     */
    public static Map<String, String> getParamMap(ServletRequest request) {
        void var1_1;
        Object object;
        HashMap params = new HashMap();
        for (Map.Entry entry : JakartaServletUtil.getParams((ServletRequest)object).entrySet()) {
            params.put(entry.getKey(), ArrayUtil.join((Object[])entry.getValue(), (CharSequence)","));
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public static String getBody(ServletRequest request) {
        String string;
        block12: {
            BufferedReader reader2 = request.getReader();
            Throwable throwable = null;
            try {
                string = IoUtil.read(reader2);
                if (reader2 == null) break block12;
            }
            catch (Throwable throwable2) {
                try {
                    try {
                        Throwable throwable3 = throwable2;
                        throwable = throwable2;
                        throw throwable3;
                    }
                    catch (Throwable throwable4) {
                        if (reader2 != null) {
                            if (throwable != null) {
                                try {
                                    reader2.close();
                                }
                                catch (Throwable reader2) {
                                    throwable.addSuppressed(reader2);
                                }
                            } else {
                                reader2.close();
                            }
                        }
                        throw throwable4;
                    }
                }
                catch (IOException e) {
                    void var0_2;
                    throw new IORuntimeException((Throwable)var0_2);
                }
            }
            reader2.close();
        }
        return string;
    }

    /*
     * WARNING - void declaration
     */
    public static byte[] getBodyBytes(ServletRequest request) {
        try {
            return IoUtil.readBytes((InputStream)request.getInputStream());
        }
        catch (IOException e) {
            void var0_1;
            throw new IORuntimeException((Throwable)var0_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static <T> T fillBean(ServletRequest request, T bean, CopyOptions copyOptions) {
        void var2_2;
        void var3_3;
        ServletRequest servletRequest;
        void var1_1;
        String beanName = StrUtil.lowerFirst(bean.getClass().getSimpleName());
        return BeanUtil.fillBean(var1_1, new ValueProvider<String>((String)var3_3){
            final /* synthetic */ String val$beanName;
            {
                this.val$beanName = string;
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public final Object value(String key, Type valueType) {
                void var2_2;
                void var1_1;
                String[] values = servletRequest.getParameterValues(key);
                if (ArrayUtil.isEmpty(values) && ArrayUtil.isEmpty(values = servletRequest.getParameterValues(this.val$beanName + "." + (String)var1_1))) {
                    return null;
                }
                if (1 == values.length) {
                    return values[0];
                }
                return var2_2;
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public final boolean containsKey(String key) {
                void var1_1;
                return null != servletRequest.getParameter(key) || null != servletRequest.getParameter(this.val$beanName + "." + (String)var1_1);
            }
        }, (CopyOptions)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public static <T> T fillBean(ServletRequest request, T bean, boolean isIgnoreError) {
        void var2_2;
        void var1_1;
        return JakartaServletUtil.fillBean(request, var1_1, CopyOptions.create().setIgnoreError((boolean)var2_2));
    }

    /*
     * WARNING - void declaration
     */
    public static <T> T toBean(ServletRequest request, Class<T> beanClass, boolean isIgnoreError) {
        void var2_2;
        void var1_1;
        return JakartaServletUtil.fillBean(request, ReflectUtil.newInstanceIfPossible(var1_1), (boolean)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public static String getClientIP(HttpServletRequest request, String ... otherHeaderNames) {
        void var2_2;
        HttpServletRequest httpServletRequest;
        String[] headers = new String[]{"X-Forwarded-For", "X-Real-IP", "Proxy-Client-IP", "WL-Proxy-Client-IP", "HTTP_CLIENT_IP", "HTTP_X_FORWARDED_FOR"};
        if (ArrayUtil.isNotEmpty(otherHeaderNames)) {
            void var1_1;
            headers = ArrayUtil.addAll(new String[][]{headers, var1_1});
        }
        return JakartaServletUtil.getClientIPByHeader(httpServletRequest, (String[])var2_2);
    }

    public static String getClientIPByHeader(HttpServletRequest request, String ... headerNames) {
        HttpServletRequest httpServletRequest;
        String string;
        String[] stringArray = headerNames;
        int n = headerNames.length;
        for (int i = 0; i < n; ++i) {
            String header = stringArray[i];
            String ip = request.getHeader(header);
            if (NetUtil.isUnknown(ip)) continue;
            return NetUtil.getMultistageReverseProxyIp(string);
        }
        string = httpServletRequest.getRemoteAddr();
        return NetUtil.getMultistageReverseProxyIp(string);
    }

    public static MultipartFormData getMultipart(ServletRequest request) throws IORuntimeException {
        return JakartaServletUtil.getMultipart(request, new UploadSetting());
    }

    /*
     * WARNING - void declaration
     */
    public static MultipartFormData getMultipart(ServletRequest request, UploadSetting uploadSetting) throws IORuntimeException {
        void var1_2;
        MultipartFormData formData = new MultipartFormData(uploadSetting);
        try {
            formData.parseRequestStream((InputStream)request.getInputStream(), CharsetUtil.charset(request.getCharacterEncoding()));
        }
        catch (IOException e) {
            void var0_1;
            throw new IORuntimeException((Throwable)var0_1);
        }
        return var1_2;
    }

    /*
     * WARNING - void declaration
     */
    public static Map<String, String> getHeaderMap(HttpServletRequest request) {
        void var1_1;
        HashMap<String, String> headerMap = new HashMap<String, String>();
        Enumeration names = request.getHeaderNames();
        while (names.hasMoreElements()) {
            void var3_3;
            String name = (String)names.nextElement();
            headerMap.put(name, request.getHeader((String)var3_3));
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public static Map<String, List<String>> getHeadersMap(HttpServletRequest request) {
        void var1_1;
        LinkedHashMap headerMap = new LinkedHashMap();
        Enumeration names = request.getHeaderNames();
        while (names.hasMoreElements()) {
            void var3_3;
            String name = (String)names.nextElement();
            headerMap.put(name, ListUtil.list(false, request.getHeaders((String)var3_3)));
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public static Map<String, Collection<String>> getHeadersMap(HttpServletResponse response) {
        void var1_1;
        HashMap<String, Collection> headerMap = new HashMap<String, Collection>();
        Object object = response.getHeaderNames();
        object = object.iterator();
        while (object.hasNext()) {
            void var3_3;
            String name = (String)object.next();
            headerMap.put(name, response.getHeaders((String)var3_3));
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public static String getHeaderIgnoreCase(HttpServletRequest request, String nameIgnoreCase) {
        Enumeration names = request.getHeaderNames();
        while (names.hasMoreElements()) {
            void var3_3;
            HttpServletRequest httpServletRequest;
            String name = (String)names.nextElement();
            if (name == null || !name.equalsIgnoreCase(nameIgnoreCase)) continue;
            return httpServletRequest.getHeader((String)var3_3);
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public static String getHeader(HttpServletRequest request, String name, String charsetName) {
        void var2_2;
        void var1_1;
        return JakartaServletUtil.getHeader(request, (String)var1_1, CharsetUtil.charset((String)var2_2));
    }

    /*
     * WARNING - void declaration
     */
    public static String getHeader(HttpServletRequest request, String name, Charset charset) {
        void var1_1;
        Object header = request.getHeader((String)var1_1);
        if (header != null) {
            void var2_2;
            Object object;
            return CharsetUtil.convert((String)object, CharsetUtil.CHARSET_ISO_8859_1, (Charset)var2_2);
        }
        return null;
    }

    public static boolean isIE(HttpServletRequest request) {
        Object userAgent = JakartaServletUtil.getHeaderIgnoreCase(request, "User-Agent");
        if (StrUtil.isNotBlank((CharSequence)userAgent)) {
            Object object;
            return ((String)(userAgent = ((String)userAgent).toUpperCase())).contains("MSIE") || ((String)object).contains("TRIDENT");
        }
        return false;
    }

    public static boolean isGetMethod(HttpServletRequest request) {
        HttpServletRequest httpServletRequest;
        return METHOD_GET.equalsIgnoreCase(httpServletRequest.getMethod());
    }

    public static boolean isPostMethod(HttpServletRequest request) {
        HttpServletRequest httpServletRequest;
        return METHOD_POST.equalsIgnoreCase(httpServletRequest.getMethod());
    }

    public static boolean isMultipart(HttpServletRequest request) {
        String string;
        if (!JakartaServletUtil.isPostMethod(request)) {
            return false;
        }
        String contentType = request.getContentType();
        if (StrUtil.isBlank(contentType)) {
            return false;
        }
        return string.toLowerCase().startsWith("multipart/");
    }

    /*
     * WARNING - void declaration
     */
    public static Cookie getCookie(HttpServletRequest httpServletRequest, String name) {
        void var1_1;
        return JakartaServletUtil.readCookieMap(httpServletRequest).get(var1_1);
    }

    public static Map<String, Cookie> readCookieMap(HttpServletRequest httpServletRequest) {
        HttpServletRequest httpServletRequest2;
        Cookie[] cookieArray = httpServletRequest.getCookies();
        if (ArrayUtil.isEmpty(cookieArray)) {
            return MapUtil.empty();
        }
        return IterUtil.toMap(new ArrayIter<Cookie>((E[])httpServletRequest2.getCookies()), new CaseInsensitiveMap(), Cookie::getName);
    }

    /*
     * WARNING - void declaration
     */
    public static void addCookie(HttpServletResponse response, Cookie cookie) {
        void var1_1;
        response.addCookie((Cookie)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static void addCookie(HttpServletResponse response, String name, String value) {
        void var2_2;
        void var1_1;
        response.addCookie(new Cookie((String)var1_1, (String)var2_2));
    }

    /*
     * WARNING - void declaration
     */
    public static void addCookie(HttpServletResponse response, String name, String value, int maxAgeInSeconds, String path, String domain) {
        void var1_1;
        HttpServletResponse httpServletResponse;
        void var3_3;
        void var2_2;
        Cookie cookie = new Cookie(name, (String)var2_2);
        if (domain != null) {
            cookie.setDomain(domain);
        }
        cookie.setMaxAge((int)var3_3);
        cookie.setPath(path);
        JakartaServletUtil.addCookie(httpServletResponse, (Cookie)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static void addCookie(HttpServletResponse response, String name, String value, int maxAgeInSeconds) {
        void var3_3;
        void var2_2;
        void var1_1;
        JakartaServletUtil.addCookie(response, (String)var1_1, (String)var2_2, (int)var3_3, "/", null);
    }

    /*
     * WARNING - void declaration
     */
    public static PrintWriter getWriter(HttpServletResponse response) throws IORuntimeException {
        try {
            return response.getWriter();
        }
        catch (IOException e) {
            void var0_1;
            throw new IORuntimeException((Throwable)var0_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void write(HttpServletResponse response, String text, String contentType) {
        response.setContentType(contentType);
        PrintWriter writer = null;
        try {
            void var1_3;
            writer = response.getWriter();
            ((Writer)writer).write((String)var1_3);
            ((Writer)writer).flush();
        }
        catch (IOException e) {
            try {
                void var0_1;
                throw new UtilException((Throwable)var0_1);
            }
            catch (Throwable throwable) {
                void var2_4;
                IoUtil.close((Closeable)var2_4);
                throw throwable;
            }
        }
        IoUtil.close(writer);
        return;
    }

    /*
     * WARNING - void declaration
     */
    public static void write(HttpServletResponse response, File file) {
        String fileName = file.getName();
        String contentType = ObjectUtil.defaultIfNull(FileUtil.getMimeType(fileName), "application/octet-stream");
        BufferedInputStream in = null;
        try {
            void var2_3;
            void var3_4;
            HttpServletResponse httpServletResponse;
            void var1_2;
            in = FileUtil.getInputStream((File)var1_2);
            JakartaServletUtil.write(httpServletResponse, in, (String)var3_4, (String)var2_3);
            return;
        }
        finally {
            IoUtil.close(in);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void write(HttpServletResponse response, InputStream in, String contentType, String fileName) {
        void var1_1;
        HttpServletResponse httpServletResponse;
        void var2_2;
        void var3_3;
        String charset = ObjectUtil.defaultIfNull(response.getCharacterEncoding(), "UTF-8");
        String encodeText = URLUtil.encodeAll(fileName, CharsetUtil.charset(charset));
        response.setHeader("Content-Disposition", StrUtil.format("attachment;filename=\"{}\";filename*={}''{}", encodeText, charset, var3_3));
        response.setContentType((String)var2_2);
        JakartaServletUtil.write(httpServletResponse, (InputStream)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static void write(HttpServletResponse response, InputStream in, String contentType) {
        void var1_1;
        HttpServletResponse httpServletResponse;
        void var2_2;
        response.setContentType((String)var2_2);
        JakartaServletUtil.write(httpServletResponse, (InputStream)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static void write(HttpServletResponse response, InputStream in) {
        void var1_1;
        JakartaServletUtil.write(response, (InputStream)var1_1, 8192);
    }

    /*
     * WARNING - void declaration
     */
    public static void write(HttpServletResponse response, InputStream in, int bufferSize) {
        ServletOutputStream out = null;
        try {
            void var2_4;
            out = response.getOutputStream();
            IoUtil.copy(in, (OutputStream)out, (int)var2_4);
        }
        catch (IOException e) {
            try {
                void var0_1;
                throw new UtilException((Throwable)var0_1);
            }
            catch (Throwable throwable) {
                void var1_3;
                void var3_5;
                IoUtil.close((Closeable)var3_5);
                IoUtil.close((Closeable)var1_3);
                throw throwable;
            }
        }
        IoUtil.close((Closeable)out);
        IoUtil.close(in);
        return;
    }

    /*
     * WARNING - void declaration
     */
    public static void setHeader(HttpServletResponse response, String name, Object value) {
        void var2_2;
        void var1_1;
        HttpServletResponse httpServletResponse;
        if (value instanceof String) {
            response.setHeader(name, (String)value);
            return;
        }
        if (Date.class.isAssignableFrom(value.getClass())) {
            response.setDateHeader(name, ((Date)value).getTime());
            return;
        }
        if (value instanceof Integer || "int".equalsIgnoreCase(value.getClass().getSimpleName())) {
            response.setIntHeader(name, ((Integer)value).intValue());
            return;
        }
        httpServletResponse.setHeader((String)var1_1, var2_2.toString());
    }
}

